package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * AbandonSellerInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class AbandonSellerInvoiceRequest {
  @ApiModelProperty(value = "可作废发票id列表")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("releaseType")
  private Integer releaseType = null;

  @JsonProperty("reason")
  private String reason = null;

  @JsonProperty("status")
  private Integer status;

  @JsonProperty("customAbandonReason")
  private String customAbandonReason = null;

   /**
   * 可作废发票id列表
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "可作废发票id列表")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public AbandonSellerInvoiceRequest releaseType(Integer releaseType) {
    this.releaseType = releaseType;
    return this;
  }

   /**
   * 作废释放模式1-作废后可对预制发票再次开具 2-作废后可对业务单明细选择并开具 3-作废后无法再次开具
   * @return releaseType
  **/
  @ApiModelProperty(value = "作废释放模式1-作废后可对预制发票再次开具 2-作废后可对业务单明细选择并开具 3-作废后无法再次开具")
  public Integer getReleaseType() {
    return releaseType;
  }

  public void setReleaseType(Integer releaseType) {
    this.releaseType = releaseType;
  }


  @JsonIgnore
  public AbandonSellerInvoiceRequest reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * 作废原因
   * @return reason
  **/
  @ApiModelProperty(value = "作废原因")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }


  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public String getCustomAbandonReason() {
    return customAbandonReason;
  }

  public void setCustomAbandonReason(String customAbandonReason) {
    this.customAbandonReason = customAbandonReason;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AbandonSellerInvoiceRequest abandonSellerInvoiceRequest = (AbandonSellerInvoiceRequest) o;
    return  Objects.equals(this.invoiceIds, abandonSellerInvoiceRequest.invoiceIds) &&
        Objects.equals(this.releaseType, abandonSellerInvoiceRequest.releaseType) &&
        Objects.equals(this.reason, abandonSellerInvoiceRequest.reason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, releaseType, reason);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AbandonSellerInvoiceRequest {\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    releaseType: ").append(toIndentedString(releaseType)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
