package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票所属单据的明细信息
 */
@ApiModel(description = "预制发票所属单据的明细信息")

@JsonInclude(NON_NULL)
public class BillOfPreInvoiceItem {
  @JsonProperty("itemName")
  private String itemName = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("quantity")
  private BigDecimal quantity = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("unitPriceWithTax")
  private BigDecimal unitPriceWithTax = null;

  @JsonProperty("unitPrice")
  private BigDecimal unitPrice = null;

  @JsonProperty("outterDiscountWithTax")
  private BigDecimal outterDiscountWithTax = null;

  @JsonProperty("outterDiscountWithoutTax")
  private BigDecimal outterDiscountWithoutTax = null;

  @JsonProperty("outterDiscountTax")
  private BigDecimal outterDiscountTax = null;

  @JsonProperty("innerDiscountWithTax")
  private BigDecimal innerDiscountWithTax = null;

  @JsonProperty("innerDiscountWithoutTax")
  private BigDecimal innerDiscountWithoutTax = null;

  @JsonProperty("innerDiscountTax")
  private BigDecimal innerDiscountTax = null;

  @JsonProperty("outterPrepayAmountWithTax")
  private BigDecimal outterPrepayAmountWithTax = null;

  @JsonProperty("outterPrepayAmountWithoutTax")
  private BigDecimal outterPrepayAmountWithoutTax = null;

  @JsonProperty("outterPrepayAmountTax")
  private BigDecimal outterPrepayAmountTax = null;

  @JsonProperty("innerPrepayAmountWithTax")
  private BigDecimal innerPrepayAmountWithTax = null;

  @JsonProperty("innerPrepayAmountWithoutTax")
  private BigDecimal innerPrepayAmountWithoutTax = null;

  @JsonProperty("innerPrepayAmountTax")
  private BigDecimal innerPrepayAmountTax = null;

  @JsonProperty("taxRate")
  private BigDecimal taxRate = null;

  @JsonIgnore
  public BillOfPreInvoiceItem itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * 货物或应税劳务名称
   * @return itemName
  **/
  @ApiModelProperty(value = "货物或应税劳务名称")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/
  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem quantity(BigDecimal quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量
   * @return quantity
  **/
  @ApiModelProperty(value = "数量")
  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem unitPriceWithTax(BigDecimal unitPriceWithTax) {
    this.unitPriceWithTax = unitPriceWithTax;
    return this;
  }

  @ApiModelProperty("含税单价")
  public BigDecimal getUnitPriceWithTax() {
    return this.unitPriceWithTax;
  }

  public void setUnitPriceWithTax(BigDecimal unitPriceWithTax) {
    this.unitPriceWithTax = unitPriceWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem unitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

  @ApiModelProperty("单价")
  public BigDecimal getUnitPrice() {
    return this.unitPrice;
  }

  public void setUnitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem outterDiscountWithTax(BigDecimal outterDiscountWithTax) {
    this.outterDiscountWithTax = outterDiscountWithTax;
    return this;
  }

  @ApiModelProperty("价外含税折扣")
  public BigDecimal getOutterDiscountWithTax() {
    return this.outterDiscountWithTax;
  }

  public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
    this.outterDiscountWithTax = outterDiscountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem outterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
    this.outterDiscountWithoutTax = outterDiscountWithoutTax;
    return this;
  }

  @ApiModelProperty("价外不含税折扣")
  public BigDecimal getOutterDiscountWithoutTax() {
    return this.outterDiscountWithoutTax;
  }

  public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
    this.outterDiscountWithoutTax = outterDiscountWithoutTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem outterDiscountTax(BigDecimal outterDiscountTax) {
    this.outterDiscountTax = outterDiscountTax;
    return this;
  }

  @ApiModelProperty("价外折扣税额")
  public BigDecimal getOutterDiscountTax() {
    return this.outterDiscountTax;
  }

  public void setOutterDiscountTax(BigDecimal outterDiscountTax) {
    this.outterDiscountTax = outterDiscountTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem innerDiscountWithTax(BigDecimal innerDiscountWithTax) {
    this.innerDiscountWithTax = innerDiscountWithTax;
    return this;
  }

  @ApiModelProperty("价内含税折扣")
  public BigDecimal getInnerDiscountWithTax() {
    return this.innerDiscountWithTax;
  }

  public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
    this.innerDiscountWithTax = innerDiscountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem innerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
    this.innerDiscountWithoutTax = innerDiscountWithoutTax;
    return this;
  }

  @ApiModelProperty("价内不含税折扣")
  public BigDecimal getInnerDiscountWithoutTax() {
    return this.innerDiscountWithoutTax;
  }

  public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
    this.innerDiscountWithoutTax = innerDiscountWithoutTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem innerDiscountTax(BigDecimal innerDiscountTax) {
    this.innerDiscountTax = innerDiscountTax;
    return this;
  }

  @ApiModelProperty("价内折扣税额")
  public BigDecimal getInnerDiscountTax() {
    return this.innerDiscountTax;
  }

  public void setInnerDiscountTax(BigDecimal innerDiscountTax) {
    this.innerDiscountTax = innerDiscountTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem outterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
    this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
    return this;
  }

  @ApiModelProperty("价外预付卡含税金额")
  public BigDecimal getOutterPrepayAmountWithTax() {
    return this.outterPrepayAmountWithTax;
  }

  public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
    this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem outterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
    this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
    return this;
  }

  @ApiModelProperty("价外预付卡不含税金额")
  public BigDecimal getOutterPrepayAmountWithoutTax() {
    return this.outterPrepayAmountWithoutTax;
  }

  public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
    this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem outterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
    this.outterPrepayAmountTax = outterPrepayAmountTax;
    return this;
  }

  @ApiModelProperty("价外预付卡税额")
  public BigDecimal getOutterPrepayAmountTax() {
    return this.outterPrepayAmountTax;
  }

  public void setOutterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
    this.outterPrepayAmountTax = outterPrepayAmountTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem innerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
    this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
    return this;
  }

  @ApiModelProperty("价内预付卡含税金额")
  public BigDecimal getInnerPrepayAmountWithTax() {
    return this.innerPrepayAmountWithTax;
  }

  public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
    this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem innerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
    this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
    return this;
  }

  @ApiModelProperty("价内预付卡不含税金额")
  public BigDecimal getInnerPrepayAmountWithoutTax() {
    return this.innerPrepayAmountWithoutTax;
  }

  public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
    this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem innerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
    this.innerPrepayAmountTax = innerPrepayAmountTax;
    return this;
  }

  @ApiModelProperty("价内预付卡税额")
  public BigDecimal getInnerPrepayAmountTax() {
    return this.innerPrepayAmountTax;
  }

  public void setInnerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
    this.innerPrepayAmountTax = innerPrepayAmountTax;
  }

  @JsonIgnore
  public BillOfPreInvoiceItem taxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
    return this;
  }

  @ApiModelProperty("税率")
  public BigDecimal getTaxRate() {
    return this.taxRate;
  }

  public void setTaxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BillOfPreInvoiceItem billOfPreInvoiceItem = (BillOfPreInvoiceItem) o;
    return Objects.equals(this.itemName, billOfPreInvoiceItem.itemName) &&
        Objects.equals(this.itemSpec, billOfPreInvoiceItem.itemSpec) &&
        Objects.equals(this.goodsTaxNo, billOfPreInvoiceItem.goodsTaxNo) &&
        Objects.equals(this.quantity, billOfPreInvoiceItem.quantity) &&
        Objects.equals(this.quantityUnit, billOfPreInvoiceItem.quantityUnit) &&
        Objects.equals(this.amountWithoutTax, billOfPreInvoiceItem.amountWithoutTax) &&
        Objects.equals(this.taxAmount, billOfPreInvoiceItem.taxAmount) &&
        Objects.equals(this.amountWithTax, billOfPreInvoiceItem.amountWithTax) &&
        Objects.equals(this.unitPrice, billOfPreInvoiceItem.unitPrice) &&
        Objects.equals(this.unitPriceWithTax, billOfPreInvoiceItem.unitPriceWithTax) &&
        Objects.equals(this.outterDiscountWithTax, billOfPreInvoiceItem.outterDiscountWithTax) &&
        Objects.equals(this.outterDiscountWithoutTax, billOfPreInvoiceItem.outterDiscountWithoutTax) &&
        Objects.equals(this.outterDiscountTax, billOfPreInvoiceItem.outterDiscountTax) &&
        Objects.equals(this.innerDiscountWithTax, billOfPreInvoiceItem.innerDiscountWithTax) &&
        Objects.equals(this.innerDiscountWithoutTax, billOfPreInvoiceItem.innerDiscountWithoutTax) &&
        Objects.equals(this.innerDiscountTax, billOfPreInvoiceItem.innerDiscountTax) &&
        Objects.equals(this.outterPrepayAmountWithTax, billOfPreInvoiceItem.outterPrepayAmountWithTax) &&
        Objects.equals(this.outterPrepayAmountWithoutTax, billOfPreInvoiceItem.outterPrepayAmountWithoutTax) &&
        Objects.equals(this.outterPrepayAmountTax, billOfPreInvoiceItem.outterPrepayAmountTax) &&
        Objects.equals(this.innerPrepayAmountWithTax, billOfPreInvoiceItem.innerPrepayAmountWithTax) &&
        Objects.equals(this.innerPrepayAmountWithoutTax, billOfPreInvoiceItem.innerPrepayAmountWithoutTax) &&
        Objects.equals(this.innerPrepayAmountTax, billOfPreInvoiceItem.innerPrepayAmountTax) &&
        Objects.equals(this.taxRate, billOfPreInvoiceItem.taxRate);

  }

  @Override
  public int hashCode() {
    return Objects.hash(itemName, itemSpec, goodsTaxNo, quantity, quantityUnit, amountWithoutTax, taxAmount, amountWithTax,unitPrice,unitPriceWithTax ,outterDiscountWithTax, outterDiscountWithoutTax,outterDiscountTax,innerDiscountWithTax, innerDiscountWithoutTax, innerDiscountTax, outterPrepayAmountWithTax, outterPrepayAmountWithoutTax, outterPrepayAmountTax, innerPrepayAmountWithTax, innerPrepayAmountWithoutTax, innerPrepayAmountTax,taxRate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BillOfPreInvoiceItem {\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    unitPriceWithTax: ").append(toIndentedString(unitPriceWithTax)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    outterDiscountWithTax: ").append(this.toIndentedString(this.outterDiscountWithTax)).append("\n");
    sb.append("    outterDiscountWithoutTax: ").append(this.toIndentedString(this.outterDiscountWithoutTax)).append("\n");
    sb.append("    outterDiscountTax: ").append(this.toIndentedString(this.outterDiscountTax)).append("\n");
    sb.append("    innerDiscountWithTax: ").append(this.toIndentedString(this.innerDiscountWithTax)).append("\n");
    sb.append("    innerDiscountWithoutTax: ").append(this.toIndentedString(this.innerDiscountWithoutTax)).append("\n");
    sb.append("    innerDiscountTax: ").append(this.toIndentedString(this.innerDiscountTax)).append("\n");
    sb.append("    outterPrepayAmountWithTax: ").append(this.toIndentedString(this.outterPrepayAmountWithTax)).append("\n");
    sb.append("    outterPrepayAmountWithoutTax: ").append(this.toIndentedString(this.outterPrepayAmountWithoutTax)).append("\n");
    sb.append("    outterPrepayAmountTax: ").append(this.toIndentedString(this.outterPrepayAmountTax)).append("\n");
    sb.append("    innerPrepayAmountWithTax: ").append(this.toIndentedString(this.innerPrepayAmountWithTax)).append("\n");
    sb.append("    innerPrepayAmountWithoutTax: ").append(this.toIndentedString(this.innerPrepayAmountWithoutTax)).append("\n");
    sb.append("    innerPrepayAmountTax: ").append(this.toIndentedString(this.innerPrepayAmountTax)).append("\n");
    sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
