package com.xforceplus.seller.invoice.client.model;

import java.util.Arrays;

/**
 *
 * 发票对应单据释放类型
 */
public enum BillReleaseType {

    NOT_RELEASE(0,"不释放单据"),
    RELEASE(1, "释放单据"),
    REVERT_RELEASE(2, "取消释放单据");

    private final Integer releaseType;

    private final String desc;

    BillReleaseType(Integer releaseType, String desc) {
        this.releaseType = releaseType;
        this.desc = desc;
    }

    public Integer value() {
        return this.releaseType;
    }

    public String getDesc() {
        return this.desc;
    }

    public static BillReleaseType fromValue(String value){
        return Arrays.stream(BillReleaseType.values())
                .filter(s -> s.value().toString().equals(value))
                .findAny()
                .orElseThrow(() -> new RuntimeException("错误的类型"));
    }
}