package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票商品明细数据
 */
@ApiModel(description = "发票商品明细数据")

@JsonInclude(NON_NULL)
public class InvoiceItem {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("preInvoiceId")
  private Long preInvoiceId = null;

  @JsonProperty("preInvoiceItemId")
  private Long preInvoiceItemId = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("cargoCode")
  private String cargoCode = null;

  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("itemName")
  private String itemName = null;

  @JsonProperty("itemCode")
  private String itemCode = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("quantity")
  private String quantity = null;

  @JsonProperty("taxRate")
  private BigDecimal taxRate = null;

  @JsonProperty("taxRateStr")
  private String taxRateStr = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  /**
   * 发票格式化预览
   */
  @JsonProperty("unitPriceStr")
  private String unitPriceStr = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("taxAmountStr")
  private String taxAmountStr = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("discountWithoutTax")
  private String discountWithoutTax = null;

  @JsonProperty("taxDeduction")
  private String taxDeduction = null;

  /**
   * 折扣税额
   */
  @JsonProperty("discountTax")
  private BigDecimal discountTax = null;

  @JsonProperty("discountWithTax")
  private String discountWithTax = null;

  @JsonProperty("discountRate")
  private String discountRate = null;

  @JsonProperty("taxItem")
  private String taxItem = null;

  @JsonProperty("goodsNoVer")
  private String goodsNoVer = null;

  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("taxPre")
  private String taxPre = null;

  @JsonProperty("taxPreCon")
  private String taxPreCon = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonProperty("discountFlag")
  private String discountFlag = null;

  @JsonProperty("priceMethod")
  private String priceMethod = null;

  @JsonProperty("createTime")
  private Date createTime = null;

  @JsonProperty("updateTime")
  private Date updateTime = null;

  @JsonProperty("deduction")
  private BigDecimal deduction = null;

  @JsonProperty("printContentFlag")
  private String printContentFlag = null;

  @JsonProperty("ext1")
  private String ext1 = null;

  @JsonProperty("ext2")
  private String ext2 = null;

  @JsonProperty("ext3")
  private String ext3 = null;

  @JsonProperty("ext4")
  private String ext4 = null;

  @JsonProperty("ext5")
  private String ext5 = null;

  @JsonProperty("ext6")
  private String ext6 = null;

  @JsonProperty("ext7")
  private String ext7 = null;

  @JsonProperty("ext8")
  private String ext8 = null;

  @JsonProperty("ext9")
  private String ext9 = null;

  @JsonProperty("ext10")
  private String ext10 = null;

  @JsonProperty("ext11")
  private String ext11 = null;

  @JsonProperty("ext12")
  private String ext12 = null;

  @JsonProperty("ext13")
  private String ext13 = null;

  @JsonProperty("ext14")
  private String ext14 = null;

  @JsonProperty("ext15")
  private String ext15 = null;

  @JsonProperty("ext16")
  private String ext16 = null;

  @JsonProperty("ext17")
  private String ext17 = null;

  @JsonProperty("ext18")
  private String ext18 = null;

  @JsonProperty("ext19")
  private String ext19 = null;

  @JsonProperty("ext20")
  private String ext20 = null;

  public String getUnitPriceStr() {
    return unitPriceStr;
  }

  public void setUnitPriceStr(String unitPriceStr) {
    this.unitPriceStr = unitPriceStr;
  }

  @JsonIgnore
  public InvoiceItem id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 发票明细号主键
   * @return id
  **/
  @ApiModelProperty(value = "发票明细号主键")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public InvoiceItem invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票序列号主键
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票序列号主键")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public InvoiceItem preInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
    return this;
  }

   /**
   * 预制发票序列号
   * @return preInvoiceId
  **/
  @ApiModelProperty(value = "预制发票序列号")
  public Long getPreInvoiceId() {
    return preInvoiceId;
  }

  public void setPreInvoiceId(Long preInvoiceId) {
    this.preInvoiceId = preInvoiceId;
  }

  @JsonIgnore
  public InvoiceItem preInvoiceItemId(Long preInvoiceItemId) {
    this.preInvoiceItemId = preInvoiceItemId;
    return this;
  }

   /**
   * 预制发票明细号
   * @return preInvoiceItemId
  **/
  @ApiModelProperty(value = "预制发票明细号")
  public Long getPreInvoiceItemId() {
    return preInvoiceItemId;
  }

  public void setPreInvoiceItemId(Long preInvoiceItemId) {
    this.preInvoiceItemId = preInvoiceItemId;
  }

  @JsonIgnore
  public InvoiceItem invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public InvoiceItem invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public InvoiceItem itemCode(String itemCode) {
    this.itemCode = itemCode;
    return this;
  }

   /**
   * 货物或应税劳务明细代码
   * @return itemCode
  **/
  @ApiModelProperty(value = "货物或应税劳务明细代码")
  public String getItemCode() {
    return itemCode;
  }

  public void setItemCode(String itemCode) {
    this.itemCode = itemCode;
  }

  @JsonIgnore
  public InvoiceItem itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * Get itemName
   * @return itemName
  **/
  @ApiModelProperty(value = "")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  @JsonIgnore
  public InvoiceItem cargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
    return this;
  }

   /**
   * 货物或应税劳务代码
   * @return cargoCode
  **/
  @ApiModelProperty(value = "货物或应税劳务代码")
  public String getCargoCode() {
    return cargoCode;
  }

  public void setCargoCode(String cargoCode) {
    this.cargoCode = cargoCode;
  }

  @JsonIgnore
  public InvoiceItem cargoName(String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * Get cargoName
   * @return cargoName
  **/
  @ApiModelProperty(value = "")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public InvoiceItem itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/
  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public InvoiceItem quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 数量单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "数量单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public InvoiceItem quantity(String quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量
   * @return quantity
  **/
  @ApiModelProperty(value = "数量")
  public String getQuantity() {
    if ("1".equals(getDiscountFlag())) {//是折扣行标志时数量不显示
      return "";
    }
    return quantity;
  }

  public void setQuantity(String quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public InvoiceItem taxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public BigDecimal getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
  }

  /**
   * taxRateStr 税率展示新增字段
   * @return taxRateStr
   **/
  @ApiModelProperty(value = "税率展示字段")
  public String getTaxRateStr() {
    return taxRateStr;
  }

  public void setTaxRateStr(String taxRateStr) {
    this.taxRateStr = taxRateStr;
  }


  @JsonIgnore
  public InvoiceItem unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "单价")
  public String getUnitPrice() {
    if ("1".equals(getDiscountFlag())) {//是折扣行标志时单价不显示
      return "";
    }
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public InvoiceItem amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税总额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税总额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public InvoiceItem taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public InvoiceItem amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

  /**
   * 税额-前端显示字段
   * @return taxAmountStr
   **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmountStr() {
    return taxAmountStr;
  }

  public void setTaxAmountStr(String taxAmountStr) {
    this.taxAmountStr = taxAmountStr;
  }

   /**
   * 含税总额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税总额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public InvoiceItem discountWithoutTax(String discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
    return this;
  }

   /**
   * 不含税折扣金额
   * @return discountWithoutTax
  **/
  @ApiModelProperty(value = "不含税折扣金额")
  public String getDiscountWithoutTax() {
    return discountWithoutTax;
  }

  public void setDiscountWithoutTax(String discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
  }

  @JsonIgnore
  public InvoiceItem discountWithTax(String discountWithTax) {
    this.discountWithTax = discountWithTax;
    return this;
  }

  /**
   * 含税折扣金额
   * @return discountWithTax
  **/
  @ApiModelProperty(value = "含税折扣金额")
  public String getDiscountWithTax() {
    return discountWithTax;
  }

  public void setDiscountWithTax(String discountWithTax) {
    this.discountWithTax = discountWithTax;
  }

  @JsonIgnore
  public InvoiceItem discountRate(String discountRate) {
    this.discountRate = discountRate;
    return this;
  }

   /**
   * 折扣率
   * @return discountRate
  **/
  @ApiModelProperty(value = "折扣率")
  public String getDiscountRate() {
    return discountRate;
  }

  public void setDiscountRate(String discountRate) {
    this.discountRate = discountRate;
  }

  @JsonIgnore
  public InvoiceItem taxItem(String taxItem) {
    this.taxItem = taxItem;
    return this;
  }

   /**
   * 商品税目
   * @return taxItem
  **/
  @ApiModelProperty(value = "商品税目")
  public String getTaxItem() {
    return taxItem;
  }

  public void setTaxItem(String taxItem) {
    this.taxItem = taxItem;
  }

  @JsonIgnore
  public InvoiceItem goodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
    return this;
  }

   /**
   * 税编版本
   * @return goodsNoVer
  **/
  @ApiModelProperty(value = "税编版本")
  public String getGoodsNoVer() {
    return goodsNoVer;
  }

  public void setGoodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
  }

  @JsonIgnore
  public InvoiceItem goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public InvoiceItem taxPre(String taxPre) {
    this.taxPre = taxPre;
    return this;
  }

   /**
   * 是否享受税收优惠政策
   * @return taxPre
  **/
  @ApiModelProperty(value = "是否享受税收优惠政策")
  public String getTaxPre() {
    return taxPre;
  }

  public void setTaxPre(String taxPre) {
    this.taxPre = taxPre;
  }

  @JsonIgnore
  public InvoiceItem taxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
    return this;
  }

   /**
   * 享受税收优惠政策内容
   * @return taxPreCon
  **/
  @ApiModelProperty(value = "享受税收优惠政策内容")
  public String getTaxPreCon() {
    return taxPreCon;
  }

  public void setTaxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
  }

  @JsonIgnore
  public InvoiceItem zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }

  @JsonIgnore
  public InvoiceItem taxDeduction(String taxDeduction) {
    this.taxDeduction = taxDeduction;
    return this;
  }

   /**
   * 折扣税额
   * @return taxDeduction
  **/
  @ApiModelProperty(value = "折扣税额")
  public String getTaxDeduction() {
    return taxDeduction;
  }

  public void setTaxDeduction(String taxDeduction) {
    this.taxDeduction = taxDeduction;
  }

  /**
   * @return inv_seller_invoice_item.discount_tax：折扣税额
   **/
  public BigDecimal getDiscountTax() {
    return discountTax;
  }

  /**
   * set method
   *
   * @param discountTax  折扣税额
   */
  public void setDiscountTax(BigDecimal discountTax) {
    this.discountTax = discountTax;
  }

  @JsonIgnore
  public InvoiceItem discountFlag(String discountFlag) {
    this.discountFlag = discountFlag;
    return this;
  }

   /**
   * 折扣行标志
   * @return discountFlag
  **/
  @ApiModelProperty(value = "折扣行标志")
  public String getDiscountFlag() {
    return discountFlag;
  }

  public void setDiscountFlag(String discountFlag) {
    this.discountFlag = discountFlag;
  }

  @JsonIgnore
  public InvoiceItem priceMethod(String priceMethod) {
    this.priceMethod = priceMethod;
    return this;
  }

   /**
   * 价格方式
   * @return priceMethod
  **/
  @ApiModelProperty(value = "价格方式")
  public String getPriceMethod() {
    return priceMethod;
  }

  public void setPriceMethod(String priceMethod) {
    this.priceMethod = priceMethod;
  }

  @JsonIgnore
  public InvoiceItem createTime(Date createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * 更新时间
   * @return updateTime
   **/
  @ApiModelProperty(value = "更新时间")
  public Date getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }
   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }


  @JsonIgnore
  public InvoiceItem deduction(BigDecimal deduction) {
    this.deduction = deduction;
    return this;
  }

   /**
   * 折扣金额
   * @return deduction
  **/
  @ApiModelProperty(value = "折扣金额")
  public BigDecimal getDeduction() {
    return deduction;
  }

  public void setDeduction(BigDecimal deduction) {
    this.deduction = deduction;
  }

  @JsonIgnore
  public InvoiceItem printContentFlag(String printContentFlag) {
    this.printContentFlag = printContentFlag;
    return this;
  }

   /**
   * 是否打印单价数量（0：打印，1：不打印）
   * @return printContentFlag
  **/
  @ApiModelProperty(value = "是否打印单价数量（0：打印，1：不打印）")
  public String getPrintContentFlag() {
    return printContentFlag;
  }

  public void setPrintContentFlag(String printContentFlag) {
    this.printContentFlag = printContentFlag;
  }

  @JsonIgnore
  public InvoiceItem ext1(String ext1) {
    this.ext1 = ext1;
    return this;
  }

   /**
   * ext1
   * @return ext1
  **/
  @ApiModelProperty(value = "ext1")
  public String getExt1() {
    return ext1;
  }

  public void setExt1(String ext1) {
    this.ext1 = ext1;
  }

  @JsonIgnore
  public InvoiceItem ext2(String ext2) {
    this.ext2 = ext2;
    return this;
  }

   /**
   * ext2
   * @return ext2
  **/
  @ApiModelProperty(value = "ext2")
  public String getExt2() {
    return ext2;
  }

  public void setExt2(String ext2) {
    this.ext2 = ext2;
  }

  @JsonIgnore
  public InvoiceItem ext3(String ext3) {
    this.ext3 = ext3;
    return this;
  }

   /**
   * ext3
   * @return ext3
  **/
  @ApiModelProperty(value = "ext3")
  public String getExt3() {
    return ext3;
  }

  public void setExt3(String ext3) {
    this.ext3 = ext3;
  }

  @JsonIgnore
  public InvoiceItem ext4(String ext4) {
    this.ext4 = ext4;
    return this;
  }

   /**
   * ext4
   * @return ext4
  **/
  @ApiModelProperty(value = "ext4")
  public String getExt4() {
    return ext4;
  }

  public void setExt4(String ext4) {
    this.ext4 = ext4;
  }

  @JsonIgnore
  public InvoiceItem ext5(String ext5) {
    this.ext5 = ext5;
    return this;
  }

   /**
   * ext5
   * @return ext5
  **/
  @ApiModelProperty(value = "ext5")
  public String getExt5() {
    return ext5;
  }

  public void setExt5(String ext5) {
    this.ext5 = ext5;
  }
  @JsonIgnore
  public InvoiceItem ext6(String ext6) {
    this.ext6 = ext6;
    return this;
  }

  /**
   * ext6
   * @return ext6
   **/
  @ApiModelProperty(value = "ext6")
  public String getExt6() {
    return ext6;
  }

  public void setExt6(String ext6) {
    this.ext6 = ext6;
  }

  @JsonIgnore
  public InvoiceItem ext7(String ext7) {
    this.ext7 = ext7;
    return this;
  }

  /**
   * ext7
   * @return ext7
   **/
  @ApiModelProperty(value = "ext7")
  public String getExt7() {
    return ext7;
  }

  public void setExt7(String ext7) {
    this.ext7 = ext7;
  }

  @JsonIgnore
  public InvoiceItem ext8(String ext8) {
    this.ext8 = ext8;
    return this;
  }

  /**
   * ext8
   * @return ext8
   **/
  @ApiModelProperty(value = "ext8")
  public String getExt8() {
    return ext8;
  }

  public void setExt8(String ext8) {
    this.ext8 = ext8;
  }

  @JsonIgnore
  public InvoiceItem ext9(String ext9) {
    this.ext9 = ext9;
    return this;
  }

  /**
   * ext9
   * @return ext9
   **/
  @ApiModelProperty(value = "ext9")
  public String getExt9() {
    return ext9;
  }

  public void setExt9(String ext9) {
    this.ext9 = ext9;
  }

  @JsonIgnore
  public InvoiceItem ext10(String ext10) {
    this.ext10 = ext10;
    return this;
  }

  /**
   * ext10
   * @return ext10
   **/
  @ApiModelProperty(value = "ext10")
  public String getExt10() {
    return ext10;
  }

  public void setExt10(String ext10) {
    this.ext10 = ext10;
  }

  @JsonIgnore
  public InvoiceItem ext11(String ext11) {
    this.ext11 = ext11;
    return this;
  }

  /**
   * ext11
   * @return ext11
   **/
  @ApiModelProperty(value = "ext11")
  public String getExt11() {
    return ext11;
  }

  public void setExt11(String ext11) {
    this.ext11 = ext11;
  }

  @JsonIgnore
  public InvoiceItem ext12(String ext12) {
    this.ext12 = ext12;
    return this;
  }

  /**
   * ext12
   * @return ext12
   **/
  @ApiModelProperty(value = "ext12")
  public String getExt12() {
    return ext12;
  }

  public void setExt12(String ext12) {
    this.ext12 = ext12;
  }

  @JsonIgnore
  public InvoiceItem ext13(String ext13) {
    this.ext13 = ext13;
    return this;
  }

  /**
   * ext13
   * @return ext13
   **/
  @ApiModelProperty(value = "ext13")
  public String getExt13() {
    return ext13;
  }

  public void setExt13(String ext13) {
    this.ext13 = ext13;
  }

  @JsonIgnore
  public InvoiceItem ext14(String ext14) {
    this.ext14 = ext14;
    return this;
  }

  /**
   * ext14
   * @return ext14
   **/
  @ApiModelProperty(value = "ext14")
  public String getExt14() {
    return ext14;
  }

  public void setExt14(String ext14) {
    this.ext14 = ext14;
  }

  @JsonIgnore
  public InvoiceItem ext15(String ext15) {
    this.ext15 = ext15;
    return this;
  }

  /**
   * ext15
   * @return ext15
   **/
  @ApiModelProperty(value = "ext15")
  public String getExt15() {
    return ext15;
  }

  public void setExt15(String ext15) {
    this.ext15 = ext15;
  }

  @JsonIgnore
  public InvoiceItem ext16(String ext16) {
    this.ext16 = ext16;
    return this;
  }

  /**
   * ext16
   * @return ext16
   **/
  @ApiModelProperty(value = "ext16")
  public String getExt16() {
    return ext16;
  }

  public void setExt16(String ext16) {
    this.ext16 = ext16;
  }

  @JsonIgnore
  public InvoiceItem ext17(String ext17) {
    this.ext17 = ext17;
    return this;
  }

  /**
   * ext17
   * @return ext17
   **/
  @ApiModelProperty(value = "ext17")
  public String getExt17() {
    return ext17;
  }

  public void setExt17(String ext17) {
    this.ext17 = ext17;
  }

  @JsonIgnore
  public InvoiceItem ext18(String ext18) {
    this.ext18 = ext18;
    return this;
  }

  /**
   * ext18
   * @return ext18
   **/
  @ApiModelProperty(value = "ext18")
  public String getExt18() {
    return ext18;
  }

  public void setExt18(String ext18) {
    this.ext18 = ext18;
  }

  @JsonIgnore
  public InvoiceItem ext19(String ext19) {
    this.ext19 = ext19;
    return this;
  }

  /**
   * ext19
   * @return ext19
   **/
  @ApiModelProperty(value = "ext19")
  public String getExt19() {
    return ext19;
  }

  public void setExt19(String ext19) {
    this.ext19 = ext19;
  }

  @JsonIgnore
  public InvoiceItem ext20(String ext20) {
    this.ext20 = ext20;
    return this;
  }

  /**
   * ext20
   * @return ext20
   **/
  @ApiModelProperty(value = "ext20")
  public String getExt20() {
    return ext20;
  }

  public void setExt20(String ext20) {
    this.ext20 = ext20;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceItem invoiceItem = (InvoiceItem) o;
    return Objects.equals(this.id, invoiceItem.id) &&
        Objects.equals(this.invoiceId, invoiceItem.invoiceId) &&
        Objects.equals(this.preInvoiceId, invoiceItem.preInvoiceId) &&
        Objects.equals(this.preInvoiceItemId, invoiceItem.preInvoiceItemId) &&
        Objects.equals(this.invoiceCode, invoiceItem.invoiceCode) &&
        Objects.equals(this.invoiceNo, invoiceItem.invoiceNo) &&
        Objects.equals(this.itemCode, invoiceItem.itemCode) &&
        Objects.equals(this.itemName, invoiceItem.itemName) &&
        Objects.equals(this.cargoCode, invoiceItem.cargoCode) &&
        Objects.equals(this.cargoName, invoiceItem.cargoName) &&
        Objects.equals(this.itemSpec, invoiceItem.itemSpec) &&
        Objects.equals(this.quantityUnit, invoiceItem.quantityUnit) &&
        Objects.equals(this.quantity, invoiceItem.quantity) &&
        Objects.equals(this.taxRate, invoiceItem.taxRate) &&
        Objects.equals(this.unitPrice, invoiceItem.unitPrice) &&
        Objects.equals(this.amountWithoutTax, invoiceItem.amountWithoutTax) &&
        Objects.equals(this.taxAmount, invoiceItem.taxAmount) &&
        Objects.equals(this.amountWithTax, invoiceItem.amountWithTax) &&
        Objects.equals(this.discountWithoutTax, invoiceItem.discountWithoutTax) &&
        Objects.equals(this.discountWithTax, invoiceItem.discountWithTax) &&
        Objects.equals(this.discountRate, invoiceItem.discountRate) &&
        Objects.equals(this.taxItem, invoiceItem.taxItem) &&
        Objects.equals(this.goodsNoVer, invoiceItem.goodsNoVer) &&
        Objects.equals(this.goodsTaxNo, invoiceItem.goodsTaxNo) &&
        Objects.equals(this.taxPre, invoiceItem.taxPre) &&
        Objects.equals(this.taxPreCon, invoiceItem.taxPreCon) &&
        Objects.equals(this.zeroTax, invoiceItem.zeroTax) &&
        Objects.equals(this.taxDeduction, invoiceItem.taxDeduction) &&
        Objects.equals(this.discountFlag, invoiceItem.discountFlag) &&
        Objects.equals(this.priceMethod, invoiceItem.priceMethod) &&
        Objects.equals(this.createTime, invoiceItem.createTime) &&
        Objects.equals(this.deduction, invoiceItem.deduction) &&
        Objects.equals(this.printContentFlag, invoiceItem.printContentFlag) &&
        Objects.equals(this.ext1, invoiceItem.ext1) &&
        Objects.equals(this.ext2, invoiceItem.ext2) &&
        Objects.equals(this.ext3, invoiceItem.ext3) &&
        Objects.equals(this.ext4, invoiceItem.ext4) &&
        Objects.equals(this.ext5, invoiceItem.ext5);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, invoiceId, preInvoiceId, preInvoiceItemId, invoiceCode, invoiceNo, itemCode, itemName, cargoCode, cargoName, itemSpec, quantityUnit, quantity, taxRate, unitPrice, amountWithoutTax, taxAmount, amountWithTax, discountWithoutTax, discountWithTax, discountRate, taxItem, goodsNoVer, goodsTaxNo, taxPre, taxPreCon, zeroTax, taxDeduction, discountFlag, priceMethod, createTime, deduction, printContentFlag, ext1, ext2, ext3, ext4, ext5);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceItem {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    preInvoiceId: ").append(toIndentedString(preInvoiceId)).append("\n");
    sb.append("    preInvoiceItemId: ").append(toIndentedString(preInvoiceItemId)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    itemCode: ").append(toIndentedString(itemCode)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    cargoCode: ").append(toIndentedString(cargoCode)).append("\n");
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    discountWithoutTax: ").append(toIndentedString(discountWithoutTax)).append("\n");
    sb.append("    discountWithTax: ").append(toIndentedString(discountWithTax)).append("\n");
    sb.append("    discountRate: ").append(toIndentedString(discountRate)).append("\n");
    sb.append("    taxItem: ").append(toIndentedString(taxItem)).append("\n");
    sb.append("    goodsNoVer: ").append(toIndentedString(goodsNoVer)).append("\n");
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
    sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("    taxDeduction: ").append(toIndentedString(taxDeduction)).append("\n");
    sb.append("    discountFlag: ").append(toIndentedString(discountFlag)).append("\n");
    sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    deduction: ").append(toIndentedString(deduction)).append("\n");
    sb.append("    printContentFlag: ").append(toIndentedString(printContentFlag)).append("\n");
    sb.append("    ext1: ").append(toIndentedString(ext1)).append("\n");
    sb.append("    ext2: ").append(toIndentedString(ext2)).append("\n");
    sb.append("    ext3: ").append(toIndentedString(ext3)).append("\n");
    sb.append("    ext4: ").append(toIndentedString(ext4)).append("\n");
    sb.append("    ext5: ").append(toIndentedString(ext5)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
