package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 返回详情
 */
@ApiModel(description = "返回详情")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetApplyResultResponseResult {
  @JsonProperty("serialNo")
  private String serialNo = null;

  @JsonProperty("traceId")
  private String traceId = null;

  @JsonProperty("resultInfo")
  private List<MsGetApplyResultResponseResultResultInfo> resultInfo = new ArrayList<MsGetApplyResultResponseResultResultInfo>();

  @JsonIgnore
  public MsGetApplyResultResponseResult serialNo(String serialNo) {
    this.serialNo = serialNo;
    return this;
  }

   /**
   * return serialNo
   * @return serialNo
  **/
  @ApiModelProperty(value = "return serialNo")
  public String getSerialNo() {
    return serialNo;
  }

  public void setSerialNo(String serialNo) {
    this.serialNo = serialNo;
  }

  @JsonIgnore
  public MsGetApplyResultResponseResult traceId(String traceId) {
    this.traceId = traceId;
    return this;
  }

   /**
   * return traceId
   * @return traceId
  **/
  @ApiModelProperty(value = "return traceId")
  public String getTraceId() {
    return traceId;
  }

  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }

  @JsonIgnore
  public MsGetApplyResultResponseResult resultInfo(List<MsGetApplyResultResponseResultResultInfo> resultInfo) {
    this.resultInfo = resultInfo;
    return this;
  }

  public MsGetApplyResultResponseResult addResultInfoItem(MsGetApplyResultResponseResultResultInfo resultInfoItem) {
    this.resultInfo.add(resultInfoItem);
    return this;
  }

   /**
   * 返回详情
   * @return resultInfo
  **/
  @ApiModelProperty(value = "返回详情")
  public List<MsGetApplyResultResponseResultResultInfo> getResultInfo() {
    return resultInfo;
  }

  public void setResultInfo(List<MsGetApplyResultResponseResultResultInfo> resultInfo) {
    this.resultInfo = resultInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetApplyResultResponseResult getApplyResultResponseResult = (MsGetApplyResultResponseResult) o;
    return Objects.equals(this.serialNo, getApplyResultResponseResult.serialNo) &&
        Objects.equals(this.traceId, getApplyResultResponseResult.traceId) &&
        Objects.equals(this.resultInfo, getApplyResultResponseResult.resultInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serialNo, traceId, resultInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetApplyResultResponseResult {\n");

    sb.append("    serialNo: ").append(toIndentedString(serialNo)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    resultInfo: ").append(toIndentedString(resultInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
