package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * null
 */
@ApiModel(description = "null")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRedNoByInvoiceDto {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("billId")
  private Long billId = null;

  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("deduction")
  private BigDecimal deduction = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("proposerName")
  private String proposerName = null;

  @JsonProperty("proposerTel")
  private String proposerTel = null;

  @JsonProperty("applyType")
  private Integer applyType = null;

  @JsonProperty("originInvoiceType")
  private String originInvoiceType = null;

  public String getOriginInvoiceType() {
    return originInvoiceType;
  }

  public void setOriginInvoiceType(String originInvoiceType) {
    this.originInvoiceType = originInvoiceType;
  }

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  public String getPaperDrawDate() {
    return paperDrawDate;
  }

  public void setPaperDrawDate(String paperDrawDate) {
    this.paperDrawDate = paperDrawDate;
  }

  @JsonProperty("paperDrawDate")
  private String paperDrawDate = null;

  @JsonProperty("applyTaxNo")
  private String applyTaxNo = null;

  @ApiModelProperty(value = "申请失败原因")
  public String getApplyRemark() {
    return applyRemark;
  }

  @JsonProperty("saleListFileFlag")
  private Integer saleListFileFlag;

  public void setApplyRemark(String applyRemark) {
    this.applyRemark = applyRemark;
  }

  @JsonProperty("applyRemark")
  private String applyRemark = null;

  @JsonProperty("applyStatus")
  private Integer applyStatus = null;

  @JsonProperty("applyingStatus")
  private Integer applyingStatus = null;

  @JsonProperty("sellerNumber")
  private String sellerNumber = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("requestBillNo")
  private String requestBillNo = null;

  /**
   * 0,未同步，1在同步中，2同步失败，3同步成功
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_status
   */
  private Integer syncStatus;

  /**
   * TZD0000 - 审核通过,TZD0074 - 已核销,TZD0072 - 已核销，待查证,TZD0082 - 已撤销
   * 表 : inv_seller_red_notification
   * 对应字段 : red_status
   */
  private String redStatus;

  /**
   * 开票机号
   * 表 : inv_seller_red_notification
   * 对应字段 : machine_code
   */
  private String machineCode;

  /**
   * 同步异常原因
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_message
   */
  private String syncMessage;

  /**
   * 同步code 0 没有异常,1.同步数据成功更新失败,2 发送到税件 失败，3 其他异常
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_code
   */
  private Integer syncCode;

  /**
   * 同步序号
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_serial_no
   */
  private String syncSerialNo;

  /**
   * 同步状态文字
   * 表 : inv_seller_red_notification
   * 对应字段 : sync_status_msg
   */
  private String syncStatusMsg;

  @JsonProperty("details")
  private List<MsSysRedNoDetailDto> details = new ArrayList<MsSysRedNoDetailDto>();

  @JsonIgnore
  public MsSysRedNoByInvoiceDto id(Long id) {
    this.id = id;
    return this;
  }

  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  public String getRequestBillNo() { return requestBillNo;}

  public void setRequestBillNo(String requestBillNo) { this.requestBillNo = requestBillNo;}

  /**
   * 主键ID
   * @return id
   **/
  @ApiModelProperty(value = "主键ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto billId(Long billId) {
    this.billId = billId;
    return this;
  }

  /**
   * 业务单ID
   * @return billId
   **/
  @ApiModelProperty(value = "业务单ID")
  public Long getBillId() {
    return billId;
  }

  public void setBillId(Long billId) {
    this.billId = billId;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto billNo(String billNo) {
    this.billNo = billNo;
    return this;
  }

  /**
   * 业务单号
   * @return billNo
   **/
  @ApiModelProperty(value = "业务单号")
  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

  /**
   * 发票代码
   * @return invoiceCode
   **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

  /**
   * 发票号码
   * @return invoiceNo
   **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

  /**
   * 价税合计
   * @return amountWithTax
   **/
  @ApiModelProperty(value = "价税合计")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

  /**
   * 合计金额
   * @return amountWithoutTax
   **/
  @ApiModelProperty(value = "合计金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

  /**
   * 合计税额
   * @return taxAmount
   **/
  @ApiModelProperty(value = "合计税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto deduction(BigDecimal deduction) {
    this.deduction = deduction;
    return this;
  }

  /**
   * 扣除额
   * @return deduction
   **/
  @ApiModelProperty(value = "扣除额")
  public BigDecimal getDeduction() {
    return deduction;
  }

  public void setDeduction(BigDecimal deduction) {
    this.deduction = deduction;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

  /**
   * 销方税号
   * @return sellerTaxNo
   **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

  /**
   * 销方名称
   * @return sellerName
   **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

  /**
   * 购方税号
   * @return purchaserTaxNo
   **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

  /**
   * 购方名称
   * @return purchaserName
   **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto proposerName(String proposerName) {
    this.proposerName = proposerName;
    return this;
  }

  /**
   * 申请人名称
   * @return proposerName
   **/
  @ApiModelProperty(value = "申请人名称")
  public String getProposerName() {
    return proposerName;
  }

  public void setProposerName(String proposerName) {
    this.proposerName = proposerName;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto proposerTel(String proposerTel) {
    this.proposerTel = proposerTel;
    return this;
  }

  /**
   * 申请方联系方式
   * @return proposerTel
   **/
  @ApiModelProperty(value = "申请方联系方式")
  public String getProposerTel() {
    return proposerTel;
  }

  public void setProposerTel(String proposerTel) {
    this.proposerTel = proposerTel;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto applyType(Integer applyType) {
    this.applyType = applyType;
    return this;
  }

  /**
   * 申请类型 1-销方申请,2-购方申请——未抵扣,3-购方申请——已抵扣
   * @return applyType
   **/
  @ApiModelProperty(value = "申请类型 1-销方申请,2-购方申请——未抵扣,3-购方申请——已抵扣")
  public Integer getApplyType() {
    return applyType;
  }

  public void setApplyType(Integer applyType) {
    this.applyType = applyType;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto applyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
    return this;
  }

  /**
   * 红字信息表编号
   * @return applyTaxNo
   **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getApplyTaxNo() {
    return applyTaxNo;
  }

  public void setApplyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto applyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
    return this;
  }

  /**
   * 申请结果:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？
   * @return applyStatus
   **/
  @ApiModelProperty(value = "申请结果:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？")
  public Integer getApplyStatus() {
    return applyStatus;
  }

  public void setApplyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto applyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
    return this;
  }

  /**
   * 申请状态:1.未申请 2.申请中 3.已申请
   * @return applyingStatus
   **/
  @ApiModelProperty(value = "申请状态:1.未申请 2.申请中 3.已申请")
  public Integer getApplyingStatus() {
    return applyingStatus;
  }

  public void setApplyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto sellerNumber(String sellerNumber) {
    this.sellerNumber = sellerNumber;
    return this;
  }

  /**
   * 流水号
   * @return sellerNumber
   **/
  @ApiModelProperty(value = "流水号")
  public String getSellerNumber() {
    return sellerNumber;
  }

  public void setSellerNumber(String sellerNumber) {
    this.sellerNumber = sellerNumber;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * 创建时间
   * @return createTime
   **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsSysRedNoByInvoiceDto details(List<MsSysRedNoDetailDto> details) {
    this.details = details;
    return this;
  }

  public MsSysRedNoByInvoiceDto addDetailsItem(MsSysRedNoDetailDto detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

  public Integer getSaleListFileFlag() {
    return saleListFileFlag;
  }

  public void setSaleListFileFlag(Integer saleListFileFlag) {
    this.saleListFileFlag = saleListFileFlag;
  }

  /**
   * 详情
   * @return details
   **/
  @ApiModelProperty(value = "详情")
  public List<MsSysRedNoDetailDto> getDetails() {
    return details;
  }

  public void setDetails(List<MsSysRedNoDetailDto> details) {
    this.details = details;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRedNoByInvoiceDto sysRedNoByInvoiceDto = (MsSysRedNoByInvoiceDto) o;
    return Objects.equals(this.id, sysRedNoByInvoiceDto.id) &&
            Objects.equals(this.billId, sysRedNoByInvoiceDto.billId) &&
            Objects.equals(this.billNo, sysRedNoByInvoiceDto.billNo) &&
            Objects.equals(this.invoiceCode, sysRedNoByInvoiceDto.invoiceCode) &&
            Objects.equals(this.invoiceNo, sysRedNoByInvoiceDto.invoiceNo) &&
            Objects.equals(this.amountWithTax, sysRedNoByInvoiceDto.amountWithTax) &&
            Objects.equals(this.amountWithoutTax, sysRedNoByInvoiceDto.amountWithoutTax) &&
            Objects.equals(this.taxAmount, sysRedNoByInvoiceDto.taxAmount) &&
            Objects.equals(this.deduction, sysRedNoByInvoiceDto.deduction) &&
            Objects.equals(this.sellerTaxNo, sysRedNoByInvoiceDto.sellerTaxNo) &&
            Objects.equals(this.sellerName, sysRedNoByInvoiceDto.sellerName) &&
            Objects.equals(this.purchaserTaxNo, sysRedNoByInvoiceDto.purchaserTaxNo) &&
            Objects.equals(this.purchaserName, sysRedNoByInvoiceDto.purchaserName) &&
            Objects.equals(this.proposerName, sysRedNoByInvoiceDto.proposerName) &&
            Objects.equals(this.proposerTel, sysRedNoByInvoiceDto.proposerTel) &&
            Objects.equals(this.applyType, sysRedNoByInvoiceDto.applyType) &&
            Objects.equals(this.applyTaxNo, sysRedNoByInvoiceDto.applyTaxNo) &&
            Objects.equals(this.applyStatus, sysRedNoByInvoiceDto.applyStatus) &&
            Objects.equals(this.applyingStatus, sysRedNoByInvoiceDto.applyingStatus) &&
            Objects.equals(this.sellerNumber, sysRedNoByInvoiceDto.sellerNumber) &&
            Objects.equals(this.createTime, sysRedNoByInvoiceDto.createTime) &&
            Objects.equals(this.details, sysRedNoByInvoiceDto.details) &&
            Objects.equals(this.requestBillNo, sysRedNoByInvoiceDto.requestBillNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, billId, billNo, invoiceCode, invoiceNo, amountWithTax, amountWithoutTax, taxAmount, deduction, sellerTaxNo, sellerName, purchaserTaxNo, purchaserName, proposerName, proposerTel, applyType, applyTaxNo, applyStatus, applyingStatus, sellerNumber, createTime, details, requestBillNo);
  }

  @Override
  public String toString() {
    return "MsSysRedNoByInvoiceDto{" +
            "id=" + id +
            ", billId=" + billId +
            ", billNo='" + billNo + '\'' +
            ", invoiceCode='" + invoiceCode + '\'' +
            ", invoiceNo='" + invoiceNo + '\'' +
            ", amountWithTax=" + amountWithTax +
            ", amountWithoutTax=" + amountWithoutTax +
            ", taxAmount=" + taxAmount +
            ", deduction=" + deduction +
            ", sellerTaxNo='" + sellerTaxNo + '\'' +
            ", sellerName='" + sellerName + '\'' +
            ", purchaserTaxNo='" + purchaserTaxNo + '\'' +
            ", purchaserName='" + purchaserName + '\'' +
            ", proposerName='" + proposerName + '\'' +
            ", proposerTel='" + proposerTel + '\'' +
            ", applyType=" + applyType +
            ", applyTaxNo='" + applyTaxNo + '\'' +
            ", applyRemark='" + applyRemark + '\'' +
            ", applyStatus=" + applyStatus +
            ", applyingStatus=" + applyingStatus +
            ", sellerNumber='" + sellerNumber + '\'' +
            ", createTime='" + createTime + '\'' +
            ", sellerNo='" + sellerNo + '\'' +
            ", purchaserNo='" + purchaserNo + '\'' +
            ", details=" + details +
            ", requestBillNo = \'" + requestBillNo + '\''+
            '}';
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  public Integer getSyncStatus() {
    return syncStatus;
  }

  public void setSyncStatus(Integer syncStatus) {
    this.syncStatus = syncStatus;
  }

  public String getRedStatus() {
    return redStatus;
  }

  public void setRedStatus(String redStatus) {
    this.redStatus = redStatus;
  }

  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  public String getSyncMessage() {
    return syncMessage;
  }

  public void setSyncMessage(String syncMessage) {
    this.syncMessage = syncMessage;
  }

  public Integer getSyncCode() {
    return syncCode;
  }

  public void setSyncCode(Integer syncCode) {
    this.syncCode = syncCode;
  }

  public String getSyncSerialNo() {
    return syncSerialNo;
  }

  public void setSyncSerialNo(String syncSerialNo) {
    this.syncSerialNo = syncSerialNo;
  }

  public String getSyncStatusMsg() {
    return syncStatusMsg;
  }

  public void setSyncStatusMsg(String syncStatusMsg) {
    this.syncStatusMsg = syncStatusMsg;
  }
}
