package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * SplitInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class QueryInvoicesByBillIdRequest {

    @JsonProperty("billId")
    private Long billId = null;

    @ApiModelProperty(value = "业务单id")
    public Long getBillId() {
        return billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((billId == null) ? 0 : billId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QueryInvoicesByBillIdRequest other = (QueryInvoicesByBillIdRequest) obj;
        if (billId == null) {
            if (other.billId != null)
                return false;
        } else if (!billId.equals(other.billId))
            return false;
        return true;
    }

}
