package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * @author <a href="mail to: libaozhong@xforceplus.com" rel="nofollow">libaozhong</a>
 * @Description: [功能描述]
 * @version: 1.0
 * @CreateDate: 2019-06-10 15:39</p>
 */
@JsonInclude(NON_NULL)
public class QueryInvoicesByIdsRequest {

    @JsonProperty("invoiceIds")
    private List<Long> invoiceIds = null;

    @ApiModelProperty(value = "发票ids")
    public List<Long> getInvoiceIds() {
        return invoiceIds;
    }

    public void setInvoiceIds(List<Long> invoiceIds) {
        this.invoiceIds = invoiceIds;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((invoiceIds == null) ? 0 : invoiceIds.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QueryInvoicesByIdsRequest other = (QueryInvoicesByIdsRequest) obj;
        if (invoiceIds == null) {
            if (other.invoiceIds != null)
                return false;
        } else if (!invoiceIds.equals(other.invoiceIds))
            return false;
        return true;
    }
}
