package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class RedInvoiceConfigItem {

    @JsonProperty("text")
    private String text;

    @JsonProperty("value")
    private Integer value = null;

    @JsonIgnore
    public RedInvoiceConfigItem text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty("配置描述")
    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @JsonIgnore
    public RedInvoiceConfigItem value(Integer value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty("配置值")
    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RedInvoiceConfigItem that = (RedInvoiceConfigItem) o;
        return Objects.equals(text, that.text) &&
                Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {

        return Objects.hash(text, value);
    }

    @Override
    public String toString() {
        return "RedInvoiceConfigItem{" +
                "text='" + text + '\'' +
                ", value=" + value +
                '}';
    }
}
