package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * SendEinvoiceEmailRequest
 */

@JsonInclude(NON_NULL)
public class SendEinvoiceEmailRequest {
    @JsonProperty("conditions")
    private Conditions conditions = null;

  @JsonProperty("isAllSelected")
  private Boolean isAllSelected = null;

  @JsonProperty("includes")
  private List<Long> includes = new ArrayList<Long>();

  @JsonProperty("excludes")
  private List<Long> excludes = new ArrayList<Long>();

  @JsonProperty("emailList")
  private List<String> emailList = new ArrayList<String>();

  @JsonProperty("telephones")
  private List<String> telephones = new ArrayList<String>();

  private String type ;

  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @JsonIgnore
  public SendEinvoiceEmailRequest coditions(Conditions coditions) {
      this.conditions = coditions;
    return this;
  }

   /**
    * Get conditions
    * @return conditions
  **/
  @ApiModelProperty(value = "")
  public Conditions getConditions() {
      return conditions;
  }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
  }

  @JsonIgnore
  public SendEinvoiceEmailRequest isAllSelected(Boolean isAllSelected) {
    this.isAllSelected = isAllSelected;
    return this;
  }

   /**
   * 是否全选：true-全选 false-非全选
   * @return isAllSelected
  **/
  @ApiModelProperty(value = "是否全选：true-全选 false-非全选")
  public Boolean getIsAllSelected() {
    return isAllSelected;
  }

  public void setIsAllSelected(Boolean isAllSelected) {
    this.isAllSelected = isAllSelected;
  }

  @JsonIgnore
  public SendEinvoiceEmailRequest includes(List<Long> includes) {
    this.includes = includes;
    return this;
  }

  public SendEinvoiceEmailRequest addIncludesItem(Long includesItem) {
    this.includes.add(includesItem);
    return this;
  }

   /**
   * 包含项-发票序列号主键列表
   * @return includes
  **/
  @ApiModelProperty(value = "包含项-发票序列号主键列表")
  public List<Long> getIncludes() {
    return includes;
  }

  public void setIncludes(List<Long> includes) {
    this.includes = includes;
  }

  @JsonIgnore
  public SendEinvoiceEmailRequest excludes(List<Long> excludes) {
    this.excludes = excludes;
    return this;
  }

  public SendEinvoiceEmailRequest addExcludesItem(Long excludesItem) {
    this.excludes.add(excludesItem);
    return this;
  }

   /**
   * 排除项-发票序列号主键列表
   * @return excludes
  **/
  @ApiModelProperty(value = "排除项-发票序列号主键列表")
  public List<Long> getExcludes() {
    return excludes;
  }

  public void setExcludes(List<Long> excludes) {
    this.excludes = excludes;
  }

  @JsonIgnore
  public SendEinvoiceEmailRequest emailList(List<String> emailList) {
    this.emailList = emailList;
    return this;
  }

  public SendEinvoiceEmailRequest addEmailListItem(String emailListItem) {
    this.emailList.add(emailListItem);
    return this;
  }



  /**
   * 发送邮箱列表
   * @return emailList
  **/
  @ApiModelProperty(value = "发送邮箱列表")
  public List<String> getEmailList() {
    return emailList;
  }

  public void setEmailList(List<String> emailList) {
    this.emailList = emailList;
  }

  @ApiModelProperty(value = "手机号列表")
  public List<String> getTelephones() {
    return telephones;
  }

  public void setTelephones(List<String> telephones) {
    this.telephones = telephones;
  }




  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SendEinvoiceEmailRequest sendEinvoiceEmailRequest = (SendEinvoiceEmailRequest) o;
      return Objects.equals(this.conditions, sendEinvoiceEmailRequest.conditions) &&
        Objects.equals(this.isAllSelected, sendEinvoiceEmailRequest.isAllSelected) &&
        Objects.equals(this.includes, sendEinvoiceEmailRequest.includes) &&
        Objects.equals(this.excludes, sendEinvoiceEmailRequest.excludes) &&
        Objects.equals(this.emailList, sendEinvoiceEmailRequest.emailList);
  }

  @Override
  public int hashCode() {
      return Objects.hash(conditions, isAllSelected, includes, excludes, emailList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SendEinvoiceEmailRequest {\n");

      sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
    sb.append("    isAllSelected: ").append(toIndentedString(isAllSelected)).append("\n");
    sb.append("    includes: ").append(toIndentedString(includes)).append("\n");
    sb.append("    excludes: ").append(toIndentedString(excludes)).append("\n");
    sb.append("    emailList: ").append(toIndentedString(emailList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
