package com.xforceplus.seller.invoice.client.model.pdf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

public class AutoPdfProductionInfo {

    @JsonProperty("productionName")
    private String productionName = null;
    @JsonProperty("specification")
    private String specification = null;
    @JsonProperty("unitName")
    private String unitName = null;

    public AutoPdfProductionInfo(String productionName, String specification, String unitName) {
        this.productionName = productionName;
        this.specification = specification;
        this.unitName = unitName;
    }

    public AutoPdfProductionInfo() {
    }

    @JsonIgnore
    public AutoPdfProductionInfo productionName(String productionName) {
        this.productionName = productionName;
        return this;
    }

    @ApiModelProperty("货物或应税劳务名称")
    public String getProductionName() {
        return this.productionName;
    }

    public void setProductionName(String productionName) {
        this.productionName = productionName;
    }

    @JsonIgnore
    public AutoPdfProductionInfo specification(String specification) {
        this.specification = specification;
        return this;
    }

    @ApiModelProperty("规格型号")
    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    @JsonIgnore
    public AutoPdfProductionInfo unitName(String unitName) {
        this.unitName = unitName;
        return this;
    }

    @ApiModelProperty("单位")
    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AutoPdfProductionInfo that = (AutoPdfProductionInfo) o;
        return Objects.equals(productionName, that.productionName) &&
                Objects.equals(specification, that.specification) &&
                Objects.equals(unitName, that.unitName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(productionName, specification, unitName);
    }

    @Override
    public String toString() {
        return "AutoPdfProductionInfo{" +
                "productionName='" + productionName + '\'' +
                ", specification='" + specification + '\'' +
                ", unitName='" + unitName + '\'' +
                '}';
    }
}
