package com.xforceplus.seller.invoice.client.model.report;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel("导入报表信息请求实体")
@JsonInclude(NON_NULL)
public class SyncReportDataRequest {
    /**
     * 客户编号
     */
    @ApiModelProperty("客户编号 住友商事-1")
    private Integer customId;

    /**
     * 集团Id
     */
    @ApiModelProperty("集团Id")
    private Long groupId;

    /**
     * 进销项类型 AR 或 AP
     */
    @ApiModelProperty("进销项类型AR 获取 AP")
    private String businessBillType;

    /**
     * 报表类型
     */
    @ApiModelProperty("报表类型:业务定义枚举值（customId:为1的情况下-reportType 值为 1 代表 记账信息同步 ）")
    private Integer reportType;

    /**
     * 远程文件地址
     */
    @ApiModelProperty("远程文件地址")
    private String importJsonFile;

    public Integer getCustomId() {
        return customId;
    }

    public void setCustomId(Integer customId) {
        this.customId = customId;
    }

    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getBusinessBillType() {
        return businessBillType;
    }

    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
    }

    public Integer getReportType() {
        return reportType;
    }

    public void setReportType(Integer reportType) {
        this.reportType = reportType;
    }

    public String getImportJsonFile() {
        return importJsonFile;
    }

    public void setImportJsonFile(String importJsonFile) {
        this.importJsonFile = importJsonFile;
    }

    @Override
    public String toString() {
        return "ImportReportDataRequest{" +
                "customId=" + customId +
                ", groupId=" + groupId +
                ", businessBillType='" + businessBillType + '\'' +
                ", reportType=" + reportType +
                ", importJsonFile='" + importJsonFile + '\'' +
                '}';
    }
}
