package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

@ApiModel(
        description = "发票开具结果状态"
)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class StatusInfo {

    @JsonProperty("printFlag")
    private String printFlag;
    @JsonProperty("processFlag")
    private String processFlag;
    @JsonProperty("processCode")
    private String processCode;
    @JsonProperty("processRemark")
    private String processRemark;

    public StatusInfo(String printFlag, String processFlag, String processCode, String processRemark) {
        this.printFlag = printFlag;
        this.processFlag = processFlag;
        this.processCode = processCode;
        this.processRemark = processRemark;
    }

    public StatusInfo() {
    }

    @ApiModelProperty("打印状态 - 开具并打印时值有效 - 0:失败 1:成功")
    public String getPrintFlag() {
        return printFlag;
    }

    public void setPrintFlag(String printFlag) {
        this.printFlag = printFlag;
    }

    @ApiModelProperty("处理状态 0-开具失败 1-开具成功 7-开具异常")
    public String getProcessFlag() {
        return processFlag;
    }

    public void setProcessFlag(String processFlag) {
        this.processFlag = processFlag;
    }

    @ApiModelProperty("处理码")
    public String getProcessCode() {
        return processCode;
    }

    public void setProcessCode(String processCode) {
        this.processCode = processCode;
    }

    @ApiModelProperty("处理信息")
    public String getProcessRemark() {
        return processRemark;
    }

    public void setProcessRemark(String processRemark) {
        this.processRemark = processRemark;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StatusInfo that = (StatusInfo) o;
        return Objects.equals(printFlag, that.printFlag) &&
                Objects.equals(processFlag, that.processFlag) &&
                Objects.equals(processCode, that.processCode) &&
                Objects.equals(processRemark, that.processRemark);
    }

    @Override
    public int hashCode() {
        return Objects.hash(printFlag, processFlag, processCode, processRemark);
    }

    @Override
    public String toString() {
        return "StatusInfo{" +
                "printFlag='" + printFlag + '\'' +
                ", processFlag='" + processFlag + '\'' +
                ", processCode='" + processCode + '\'' +
                ", processRemark='" + processRemark + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
