package com.xforceplus.seller.invoice.clientl.v2.request;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Objects;

public class QueryMakeOutResultRequest {

    @JsonProperty("serialNo")
    private String serialNo;
    @JsonProperty("pids")
    List<String> pids;

    public QueryMakeOutResultRequest(String serialNo, List<String> pids) {
        this.serialNo = serialNo;
        this.pids = pids;
    }

    public String getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public List<String> getPids() {
        return pids;
    }

    public void setPids(List<String> pids) {
        this.pids = pids;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QueryMakeOutResultRequest that = (QueryMakeOutResultRequest) o;
        return Objects.equals(serialNo, that.serialNo) &&
                Objects.equals(pids, that.pids);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serialNo, pids);
    }

    @Override
    public String toString() {
        return "QueryMakeOutResultRequest{" +
                "serialNo='" + serialNo + '\'' +
                ", pids=" + pids +
                '}';
    }
}
