package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.BlueInvoiceForRedFieldInfoRequest;
import com.xforceplus.seller.invoice.client.model.PreInvoiceForRedFieldInfoRequest;
import com.xforceplus.seller.invoice.client.model.RedInvoiceInfoTableUpdateRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author <a href="mail to: libaozhong@xforceplus.com" rel="nofollow">libaozhong</a>
 * @Description: [功能描述]
 * @version: 1.0
 * @CreateDate: 2019-08-05 10:25</p>
 */

@Api(value = "RedInvoiceInfoTableApi", description = "the RedInvoiceInfoTableApi API")
public interface RedInvoiceInfoTableApi {


    @ApiOperation(value = "更新红字信息表进入预制发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "RedInvoiceInfoTableApi", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/applyRedInfoTableNo/updateRedInvoiceInfoTable",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response updateRedTableNoToPReInvoice(@ApiParam(value = "更新红字信息表字段请求", required = true) @RequestBody RedInvoiceInfoTableUpdateRequest redInvoiceInfoTableUpdateRequest);


    @ApiOperation(value = "从蓝票申请红字信息表", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "RedInvoiceInfoTableApi", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/applyRedInfoTableNo/applyForRedInfoNoFromBlueInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response applyForRedInfoNoFromBlueInvoice(@ApiParam(value = "蓝票申请红字信息表字段请求", required = true) @RequestBody BlueInvoiceForRedFieldInfoRequest blueInvoiceForRedFieldInfoRequest);




    @ApiOperation(value = "从预制发票申请红字信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "RedInvoiceInfoTableApi", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/applyRedInfoTableNo/applyForRedInfoNoFromPreInvoice",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response applyForRedInfoNoFromPreInvoice(@ApiParam(value = "预制发票申请红字信息表字段请求", required = true) @RequestBody PreInvoiceForRedFieldInfoRequest preInvoiceForRedFieldInfoRequest);



}
