package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.PreInvoiceDeleteRequest;
import com.xforceplus.seller.invoice.client.model.PreInvoiceDeleteResponse;
import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceDeleteRequest;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/7/2 20:53
 */
public interface SellerPreInvoiceOperationApi {

    @ApiOperation(value = "批量删除预制发票", notes = "", response = PreInvoiceDeleteResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PreInvoiceDeleteResponse.class) })
    @RequestMapping(value = "/delete",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PreInvoiceDeleteResponse deletePreInvoice(@ApiParam(value = "待删除预制发票信息", required = true) @RequestBody PreInvoiceDeleteRequest preInvoiceDeleteRequest);

    @ApiOperation(value = "批量删除预制发票", notes = "", response = PreInvoiceDeleteResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PreInvoiceDeleteResponse.class) })
    @RequestMapping(value = "preInvoice/deleteBy",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PreInvoiceDeleteResponse deletePreInvoiceBy(@ApiParam(value = "待删除预制发票信息" ,required=true ) @RequestBody PreInvoiceDeleteRequest preInvoiceDeleteRequest);

    @ApiOperation(value = "完全匹配单据后批量删除其下预制发票", notes = "", response = PreInvoiceDeleteResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PreInvoiceDeleteResponse.class) })
    @RequestMapping(value = "/deleteAfterBillMatched",
            produces = { "application/json" },
            method = RequestMethod.POST)
    PreInvoiceDeleteResponse deletePreInvoiceAfterBillMatched(@ApiParam(value = "待删除预制发票信息", required = true) @RequestBody SellerPreInvoiceDeleteRequest sellerPreInvoiceDeleteRequest);

}
