package com.xforceplus.seller.invoice.client.api.open;

import com.xforceplus.seller.invoice.client.model.open.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "openInvoiceOperation", description = "the sellerPreInvoice API")
public interface OpenInvoiceOperationApi {

    @ApiOperation(value = "根据发票号码代码作废发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/abandon",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response openInvoiceAbandon(@RequestBody OpenInvoiceAbandonRequest
                                        request);

    @ApiOperation(value = "根据发票号码代码红冲发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/redflush",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response openInvoiceRedflush(@RequestBody OpenInvoiceRedflushRequest request);

    @ApiOperation(value = "根据业务单号查询发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/queryInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response queryInvoice(@RequestBody QueryInvoiceModel request);


    @ApiOperation(value = "根据预制发票id开具（for TaxWare）", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"openInvoiceOperation",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "结果", response = Response.class)})
    @RequestMapping(value = "/open/invoiceOperation/issueByPid",
            produces = {"application/json"},
            method = RequestMethod.POST)
    IssueResponse issueByPid(@RequestBody QueryMakeOutResultForTaxWareRequest request);

}
