package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 单据信息
 */
@ApiModel(description = "单据信息")

@JsonInclude(NON_NULL)
public class BillInfo {
  @JsonProperty("salesbillId")
  private String salesbillId = null;

  @JsonProperty("importBatchNo")
  private String importBatchNo = null;

  @JsonProperty("salesbillNo")
  private String salesbillNo = null;

  @JsonProperty("sellerTenantId")
  private Long sellerTenantId = null;

  @JsonProperty("sellerGroupId")
  private Long sellerGroupId;

  @JsonProperty("sellerId")
  private Long sellerId;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTenantId")
  private Long purchaserTenantId = null;

  @JsonProperty("purchaserCode")
  private String purchaserCode = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("purchaserId")
  private Long purchaserId = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId;

  @JsonProperty("systemOrig")
  private String systemOrig = null;

  @JsonProperty("sysOrgId")
  private Long sysOrgId;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("salesbillType")
  private String salesbillType = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("priceMethod")
  private String priceMethod = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("alreadyMakeAmountWithTax")
  private BigDecimal alreadyMakeAmountWithTax;

  @JsonProperty("alreadyMakeAmountWithoutTax")
  private BigDecimal alreadyMakeAmountWithoutTax;

  @JsonProperty("alreadyMakeAmountTaxAmount")
  private BigDecimal alreadyMakeAmountTaxAmount;

  @JsonProperty("discountWithTax")
  private String discountWithTax = null;

  @JsonProperty("discountWithoutTax")
  private String discountWithoutTax = null;

  @JsonProperty("discountTax")
  private String discountTax = null;

  @JsonProperty("prePayWithoutTax")
  private String prePayWithoutTax = null;

  @JsonProperty("prePayTax")
  private String prePayTax = null;

  @JsonProperty("prePayWithTax")
  private String prePayWithTax = null;

  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("originInvoiceType")
  private String originInvoiceType ;

  @JsonProperty("originPaperDrawDate")
  private String originPaperDrawDate ;

  @JsonProperty("redNotification")
  private String redNotification = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("receiveUserEmail")
  private String receiveUserEmail = null;

  @JsonProperty("receiveUserTel")
  private String receiveUserTel = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("modifyMark")
  private Integer  modifyMark = null;

  @JsonProperty("customerNo")
  private String customerNo;

  @JsonProperty("remark")
  private String remark;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo;

  @JsonProperty("ext1")
  private String ext1 = null;

  @JsonProperty("ext2")
  private String ext2 = null;

  @JsonProperty("ext3")
  private String ext3 = null;

  @JsonProperty("ext4")
  private String ext4 = null;

  @JsonProperty("ext5")
  private String ext5 = null;

  @JsonProperty("ext6")
  private String ext6 = null;

  @JsonProperty("ext7")
  private String ext7 = null;

  @JsonProperty("ext8")
  private String ext8 = null;

  @JsonProperty("ext9")
  private String ext9 = null;

  @JsonProperty("ext10")
  private String ext10 = null;

  @JsonProperty("ext11")
  private String ext11 = null;

  @JsonProperty("ext12")
  private String ext12 = null;

  @JsonProperty("ext13")
  private String ext13 = null;

  @JsonProperty("ext14")
  private String ext14 = null;

  @JsonProperty("ext15")
  private String ext15 = null;

  @JsonProperty("ext16")
  private String ext16 = null;

  @JsonProperty("ext17")
  private String ext17 = null;

  @JsonProperty("ext18")
  private String ext18 = null;

  @JsonProperty("ext19")
  private String ext19 = null;

  @JsonProperty("ext20")
  private String ext20 = null;

  @JsonProperty("ext21")
  private String ext21 = null;

  @JsonProperty("ext22")
  private String ext22 = null;

  @JsonProperty("ext23")
  private String ext23 = null;

  @JsonProperty("ext24")
  private String ext24 = null;

  @JsonProperty("ext25")
  private String ext25 = null;

  @JsonProperty("extInfo")
  private String extInfo = null;

  @JsonProperty("billItems")
  private List<BillItem> billItems = new ArrayList<BillItem>();

  public String getOriginInvoiceType() {
    return originInvoiceType;
  }

  public void setOriginInvoiceType(String originInvoiceType) {
    this.originInvoiceType = originInvoiceType;
  }

  @JsonIgnore
  public BillInfo salesbillId(String salesbillId) {
    this.salesbillId = salesbillId;
    return this;
  }

  /**
   * 单据主键
   * @return salesbillId
   **/
  @ApiModelProperty(value = "单据主键")
  public String getSalesbillId() {
    return salesbillId;
  }

  public void setSalesbillId(String salesbillId) {
    this.salesbillId = salesbillId;
  }

  @JsonIgnore
  public BillInfo importBatchNo(String importBatchNo) {
    this.importBatchNo = importBatchNo;
    return this;
  }

  /**
   * 导入批次号
   * @return importBatchNo
   **/
  @ApiModelProperty(value = "导入批次号")
  public String getImportBatchNo() {
    return importBatchNo;
  }

  public void setImportBatchNo(String importBatchNo) {
    this.importBatchNo = importBatchNo;
  }

  @JsonIgnore
  public BillInfo salesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
    return this;
  }

  /**
   * 单据编号No
   * @return salesbillNo
   **/
  @ApiModelProperty(value = "单据编号No")
  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public BillInfo sellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
    return this;
  }

  /**
   * 销方租户Id
   * @return sellerTenantId
   **/
  @ApiModelProperty(value = "销方租户Id")
  public Long getSellerTenantId() {
    return sellerTenantId;
  }

  public void setSellerTenantId(Long sellerTenantId) {
    this.sellerTenantId = sellerTenantId;
  }

  @JsonIgnore
  public BillInfo sellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
    return this;
  }

  /**
   * 销方租户公司编号
   * @return sellerNo
   **/
  @ApiModelProperty(value = "销方租户公司编号")
  public String getSellerNo() {
    return sellerNo;
  }

  public void setSellerNo(String sellerNo) {
    this.sellerNo = sellerNo;
  }

  @JsonIgnore
  public BillInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

  /**
   * 销方名称
   * @return sellerName
   **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public BillInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

  /**
   * 销方纳税人识别号
   * @return sellerTaxNo
   **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public BillInfo sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

  /**
   * 销方电话
   * @return sellerTel
   **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public BillInfo sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

  /**
   * 销方地址
   * @return sellerAddress
   **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public BillInfo sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

  /**
   * 销方银行名称
   * @return sellerBankName
   **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public BillInfo sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

  /**
   * 销方银行账号
   * @return sellerBankAccount
   **/
  @ApiModelProperty(value = "销方银行账号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public BillInfo purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

  /**
   * 购方名称
   * @return purchaserName
   **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public BillInfo purchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
    return this;
  }

  /**
   * 购方租户Id
   * @return purchaserTenantId
   **/
  @ApiModelProperty(value = "购方租户Id")
  public Long getPurchaserTenantId() {
    return purchaserTenantId;
  }

  public void setPurchaserTenantId(Long purchaserTenantId) {
    this.purchaserTenantId = purchaserTenantId;
  }

  @JsonIgnore
  public BillInfo purchaserCode(String purchaserCode) {
    this.purchaserCode = purchaserCode;
    return this;
  }

  /**
   * 购方公司代码
   * @return purchaserCode
   **/
  @ApiModelProperty(value = "购方公司代码")
  public String getPurchaserCode() {
    return purchaserCode;
  }

  public void setPurchaserCode(String purchaserCode) {
    this.purchaserCode = purchaserCode;
  }

  @JsonIgnore
  public BillInfo purchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
    return this;
  }

  /**
   * 购方租户公司编号
   * @return purchaserNo
   **/
  @ApiModelProperty(value = "购方租户公司编号")
  public String getPurchaserNo() {
    return purchaserNo;
  }

  public void setPurchaserNo(String purchaserNo) {
    this.purchaserNo = purchaserNo;
  }

  @JsonIgnore
  public BillInfo purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

  /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
   **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public BillInfo purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

  /**
   * 购方电话
   * @return purchaserTel
   **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public BillInfo purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

  /**
   * 购方地址
   * @return purchaserAddress
   **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public BillInfo purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

  /**
   * 购方银行名称
   * @return purchaserBankName
   **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public BillInfo purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

  /**
   * 购方银行账号
   * @return purchaserBankAccount
   **/
  @ApiModelProperty(value = "购方银行账号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public BillInfo purchaserId(Long purchaserId) {
    this.purchaserId = purchaserId;
    return this;
  }

  /**
   * 购方Id
   * @return purchaserId
   **/
  @ApiModelProperty(value = "购方Id")
  public Long getPurchaserId() {
    return purchaserId;
  }

  public void setPurchaserId(Long purchaserId) {
    this.purchaserId = purchaserId;
  }

  @JsonIgnore
  public BillInfo systemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
    return this;
  }

  /**
   * 系统来源
   * @return systemOrig
   **/
  @ApiModelProperty(value = "系统来源")
  public String getSystemOrig() {
    return systemOrig;
  }

  public void setSystemOrig(String systemOrig) {
    this.systemOrig = systemOrig;
  }

  @JsonIgnore
  public BillInfo businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

  /**
   * 适用业务单据类型
   * @return businessBillType
   **/
  @ApiModelProperty(value = "适用业务单据类型")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public BillInfo salesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
    return this;
  }

  /**
   * 单据类型
   * @return salesbillType
   **/
  @ApiModelProperty(value = "单据类型")
  public String getSalesbillType() {
    return salesbillType;
  }

  public void setSalesbillType(String salesbillType) {
    this.salesbillType = salesbillType;
  }

  @JsonIgnore
  public BillInfo invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  /**
   * 发票类型
   * @return invoiceType
   **/
  @ApiModelProperty(value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public BillInfo priceMethod(String priceMethod) {
    this.priceMethod = priceMethod;
    return this;
  }

  /**
   * 价格方式(0-不含税金额 1-含税金额)
   * @return priceMethod
   **/
  @ApiModelProperty(value = "价格方式(0-不含税金额 1-含税金额)")
  public String getPriceMethod() {
    return priceMethod;
  }

  public void setPriceMethod(String priceMethod) {
    this.priceMethod = priceMethod;
  }

  @JsonIgnore
  public BillInfo amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

  /**
   * 含税金额
   * @return amountWithTax
   **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public BillInfo amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

  /**
   * 不含税金额
   * @return amountWithoutTax
   **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public BillInfo taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

  /**
   * 税额
   * @return taxAmount
   **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }


  @JsonIgnore
  public BillInfo alreadyMakeAmountWithTax(BigDecimal alreadyMakeAmountWithTax) {
    this.alreadyMakeAmountWithTax = alreadyMakeAmountWithTax;
    return this;
  }

  /**
   * 已开含税金额
   * @return alreadyMakeAmountWithTax
   **/
  @ApiModelProperty(value = "已开含税金额")
  public BigDecimal getAlreadyMakeAmountWithTax() {
    return alreadyMakeAmountWithTax;
  }

  public void setAlreadyMakeAmountWithTax(BigDecimal alreadyMakeAmountWithTax) {
    this.alreadyMakeAmountWithTax = alreadyMakeAmountWithTax;
  }

  @JsonIgnore
  public BillInfo alreadyMakeAmountWithoutTax(BigDecimal alreadyMakeAmountWithoutTax) {
    this.alreadyMakeAmountWithTax = alreadyMakeAmountWithoutTax;
    return this;
  }

  /**
   * 已开不含税金额
   * @return alreadyMakeAmountWithoutTax
   **/
  @ApiModelProperty(value = "已开不含税金额")
  public BigDecimal getAlreadyMakeAmountWithoutTax() {
    return alreadyMakeAmountWithoutTax;
  }

  public void setAlreadyMakeAmountWithoutTax(BigDecimal alreadyMakeAmountWithoutTax) {
    this.alreadyMakeAmountWithoutTax = alreadyMakeAmountWithoutTax;
  }

  @JsonIgnore
  public BillInfo alreadyMakeAmountTaxAmount(BigDecimal alreadyMakeAmountTaxAmount) {
    this.alreadyMakeAmountTaxAmount = alreadyMakeAmountTaxAmount;
    return this;
  }

  /**
   * 已开税额
   * @return alreadyMakeAmountTaxAmount
   **/
  @ApiModelProperty(value = "已开税额")
  public BigDecimal getAlreadyMakeAmountTaxAmount() {
    return alreadyMakeAmountTaxAmount;
  }

  public void setAlreadyMakeAmountTaxAmount(BigDecimal alreadyMakeAmountTaxAmount) {
    this.alreadyMakeAmountTaxAmount = alreadyMakeAmountTaxAmount;
  }


  @JsonIgnore
  public BillInfo discountWithTax(String discountWithTax) {
    this.discountWithTax = discountWithTax;
    return this;
  }

  /**
   * 含税折扣额
   * @return discountWithTax
   **/
  @ApiModelProperty(value = "含税折扣额")
  public String getDiscountWithTax() {
    return discountWithTax;
  }

  public void setDiscountWithTax(String discountWithTax) {
    this.discountWithTax = discountWithTax;
  }

  @JsonIgnore
  public BillInfo discountWithoutTax(String discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
    return this;
  }

  /**
   * 不含税折扣额
   * @return discountWithoutTax
   **/
  @ApiModelProperty(value = "不含税折扣额")
  public String getDiscountWithoutTax() {
    return discountWithoutTax;
  }

  public void setDiscountWithoutTax(String discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
  }

  @JsonIgnore
  public BillInfo discountTax(String discountTax) {
    this.discountTax = discountTax;
    return this;
  }

  /**
   * 折扣税额
   * @return discountTax
   **/
  @ApiModelProperty(value = "折扣税额")
  public String getDiscountTax() {
    return discountTax;
  }

  public void setDiscountTax(String discountTax) {
    this.discountTax = discountTax;
  }

  @JsonIgnore
  public BillInfo prePayWithoutTax(String prePayWithoutTax) {
    this.prePayWithoutTax = prePayWithoutTax;
    return this;
  }

  /**
   * 不含税预付额
   * @return prePayWithoutTax
   **/
  @ApiModelProperty(value = "不含税预付额")
  public String getPrePayWithoutTax() {
    return prePayWithoutTax;
  }

  public void setPrePayWithoutTax(String prePayWithoutTax) {
    this.prePayWithoutTax = prePayWithoutTax;
  }

  @JsonIgnore
  public BillInfo prePayTax(String prePayTax) {
    this.prePayTax = prePayTax;
    return this;
  }

  /**
   * 预付税额
   * @return prePayTax
   **/
  @ApiModelProperty(value = "预付税额")
  public String getPrePayTax() {
    return prePayTax;
  }

  public void setPrePayTax(String prePayTax) {
    this.prePayTax = prePayTax;
  }

  @JsonIgnore
  public BillInfo prePayWithTax(String prePayWithTax) {
    this.prePayWithTax = prePayWithTax;
    return this;
  }

  /**
   * 含税预付额
   * @return prePayWithTax
   **/
  @ApiModelProperty(value = "含税预付额")
  public String getPrePayWithTax() {
    return prePayWithTax;
  }

  public void setPrePayWithTax(String prePayWithTax) {
    this.prePayWithTax = prePayWithTax;
  }

  @JsonIgnore
  public BillInfo originInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
    return this;
  }

  /**
   * 原发票号码
   * @return originInvoiceNo
   **/
  @ApiModelProperty(value = "原发票号码")
  public String getOriginInvoiceNo() {
    return originInvoiceNo;
  }

  public void setOriginInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
  }

  @JsonIgnore
  public BillInfo originInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
    return this;
  }

  /**
   * 原发票代码
   * @return originInvoiceCode
   **/
  @ApiModelProperty(value = "原发票代码")
  public String getOriginInvoiceCode() {
    return originInvoiceCode;
  }

  public void setOriginInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
  }

  @JsonIgnore
  public BillInfo redNotification(String redNotification) {
    this.redNotification = redNotification;
    return this;
  }

  /**
   * 红字信息编号
   * @return redNotification
   **/
  @ApiModelProperty(value = "红字信息编号")
  public String getRedNotification() {
    return redNotification;
  }

  public void setRedNotification(String redNotification) {
    this.redNotification = redNotification;
  }

  @JsonIgnore
  public BillInfo checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

  /**
   * 复核人
   * @return checkerName
   **/
  @ApiModelProperty(value = "复核人")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public BillInfo cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

  /**
   * 出纳员
   * @return cashierName
   **/
  @ApiModelProperty(value = "出纳员")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public BillInfo invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

  /**
   * 开票人
   * @return invoicerName
   **/
  @ApiModelProperty(value = "开票人")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public BillInfo receiveUserEmail(String receiveUserEmail) {
    this.receiveUserEmail = receiveUserEmail;
    return this;
  }

  /**
   * 接收方邮箱
   * @return receiveUserEmail
   **/
  @ApiModelProperty(value = "接收方邮箱")
  public String getReceiveUserEmail() {
    return receiveUserEmail;
  }

  public void setReceiveUserEmail(String receiveUserEmail) {
    this.receiveUserEmail = receiveUserEmail;
  }

  @JsonIgnore
  public BillInfo receiveUserTel(String receiveUserTel) {
    this.receiveUserTel = receiveUserTel;
    return this;
  }

  /**
   * 接收方电话
   * @return receiveUserTel
   **/
  @ApiModelProperty(value = "接收方电话")
  public String getReceiveUserTel() {
    return receiveUserTel;
  }

  public void setReceiveUserTel(String receiveUserTel) {
    this.receiveUserTel = receiveUserTel;
  }

  @JsonIgnore
  public BillInfo status(String status) {
    this.status = status;
    return this;
  }

  /**
   * 状态
   * @return status
   **/
  @ApiModelProperty(value = "状态")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public BillInfo modifyMark(Integer modifyMark) {
    this.modifyMark = modifyMark;
    return this;
  }

  /**
   * 修改标识计数
   * @return modifyMark
   **/
  @ApiModelProperty(value = "修改标识计数")
  public Integer getModifyMark() {
    return modifyMark;
  }

  public void setModifyMark(Integer modifyMark) {
    this.modifyMark = modifyMark;
  }



  @JsonIgnore
  public BillInfo ext1(String ext1) {
    this.ext1 = ext1;
    return this;
  }

  /**
   * ext1
   * @return ext1
   **/
  @ApiModelProperty(value = "ext1")
  public String getExt1() {
    return ext1;
  }

  public void setExt1(String ext1) {
    this.ext1 = ext1;
  }

  @JsonIgnore
  public BillInfo ext2(String ext2) {
    this.ext2 = ext2;
    return this;
  }

  /**
   * ext2
   * @return ext2
   **/
  @ApiModelProperty(value = "ext2")
  public String getExt2() {
    return ext2;
  }

  public void setExt2(String ext2) {
    this.ext2 = ext2;
  }

  @JsonIgnore
  public BillInfo ext3(String ext3) {
    this.ext3 = ext3;
    return this;
  }

  /**
   * ext3
   * @return ext3
   **/
  @ApiModelProperty(value = "ext3")
  public String getExt3() {
    return ext3;
  }

  public void setExt3(String ext3) {
    this.ext3 = ext3;
  }

  @JsonIgnore
  public BillInfo ext4(String ext4) {
    this.ext4 = ext4;
    return this;
  }

  /**
   * ext4
   * @return ext4
   **/
  @ApiModelProperty(value = "ext4")
  public String getExt4() {
    return ext4;
  }

  public void setExt4(String ext4) {
    this.ext4 = ext4;
  }

  @JsonIgnore
  public BillInfo ext5(String ext5) {
    this.ext5 = ext5;
    return this;
  }

  /**
   * ext5
   * @return ext5
   **/
  @ApiModelProperty(value = "ext5")
  public String getExt5() {
    return ext5;
  }

  public void setExt5(String ext5) {
    this.ext5 = ext5;
  }

  @JsonIgnore
  public BillInfo ext6(String ext6) {
    this.ext6 = ext6;
    return this;
  }

  /**
   * ext6
   * @return ext6
   **/
  @ApiModelProperty(value = "ext6")
  public String getExt6() {
    return ext6;
  }

  public void setExt6(String ext6) {
    this.ext6 = ext6;
  }

  @JsonIgnore
  public BillInfo ext7(String ext7) {
    this.ext7 = ext7;
    return this;
  }

  /**
   * ext7
   * @return ext7
   **/
  @ApiModelProperty(value = "ext7")
  public String getExt7() {
    return ext7;
  }

  public void setExt7(String ext7) {
    this.ext7 = ext7;
  }

  @JsonIgnore
  public BillInfo ext8(String ext8) {
    this.ext8 = ext8;
    return this;
  }

  /**
   * ext8
   * @return ext8
   **/
  @ApiModelProperty(value = "ext8")
  public String getExt8() {
    return ext8;
  }

  public void setExt8(String ext8) {
    this.ext8 = ext8;
  }

  @JsonIgnore
  public BillInfo ext9(String ext9) {
    this.ext9 = ext9;
    return this;
  }

  /**
   * ext9
   * @return ext9
   **/
  @ApiModelProperty(value = "ext9")
  public String getExt9() {
    return ext9;
  }

  public void setExt9(String ext9) {
    this.ext9 = ext9;
  }

  @JsonIgnore
  public BillInfo ext10(String ext10) {
    this.ext10 = ext10;
    return this;
  }

  /**
   * ext10
   * @return ext10
   **/
  @ApiModelProperty(value = "ext10")
  public String getExt10() {
    return ext10;
  }

  public void setExt10(String ext10) {
    this.ext10 = ext10;
  }

  @JsonIgnore
  public BillInfo ext11(String ext11) {
    this.ext11 = ext11;
    return this;
  }

  /**
   * ext11
   * @return ext11
   **/
  @ApiModelProperty(value = "ext11")
  public String getExt11() {
    return ext11;
  }

  public void setExt11(String ext11) {
    this.ext11 = ext11;
  }

  @JsonIgnore
  public BillInfo ext12(String ext12) {
    this.ext12 = ext12;
    return this;
  }

  /**
   * ext12
   * @return ext12
   **/
  @ApiModelProperty(value = "ext12")
  public String getExt12() {
    return ext12;
  }

  public void setExt12(String ext12) {
    this.ext12 = ext12;
  }

  @JsonIgnore
  public BillInfo ext13(String ext13) {
    this.ext13 = ext13;
    return this;
  }

  /**
   * ext13
   * @return ext13
   **/
  @ApiModelProperty(value = "ext13")
  public String getExt13() {
    return ext13;
  }

  public void setExt13(String ext13) {
    this.ext13 = ext13;
  }

  @JsonIgnore
  public BillInfo ext14(String ext14) {
    this.ext14 = ext14;
    return this;
  }

  /**
   * ext14
   * @return ext14
   **/
  @ApiModelProperty(value = "ext14")
  public String getExt14() {
    return ext14;
  }

  public void setExt14(String ext14) {
    this.ext14 = ext14;
  }

  @JsonIgnore
  public BillInfo ext15(String ext15) {
    this.ext15 = ext15;
    return this;
  }

  /**
   * ext15
   * @return ext15
   **/
  @ApiModelProperty(value = "ext15")
  public String getExt15() {
    return ext15;
  }

  public void setExt15(String ext15) {
    this.ext15 = ext15;
  }

  @JsonIgnore
  public BillInfo ext16(String ext16) {
    this.ext16 = ext16;
    return this;
  }

  /**
   * ext16
   * @return ext16
   **/
  @ApiModelProperty(value = "ext16")
  public String getExt16() {
    return ext16;
  }

  public void setExt16(String ext16) {
    this.ext16 = ext16;
  }

  @JsonIgnore
  public BillInfo ext17(String ext17) {
    this.ext17 = ext17;
    return this;
  }

  /**
   * ext17
   * @return ext17
   **/
  @ApiModelProperty(value = "ext17")
  public String getExt17() {
    return ext17;
  }

  public void setExt17(String ext17) {
    this.ext17 = ext17;
  }

  @JsonIgnore
  public BillInfo ext18(String ext18) {
    this.ext18 = ext18;
    return this;
  }

  /**
   * ext18
   * @return ext18
   **/
  @ApiModelProperty(value = "ext18")
  public String getExt18() {
    return ext18;
  }

  public void setExt18(String ext18) {
    this.ext18 = ext18;
  }

  @JsonIgnore
  public BillInfo ext19(String ext19) {
    this.ext19 = ext19;
    return this;
  }

  /**
   * ext19
   * @return ext19
   **/
  @ApiModelProperty(value = "ext19")
  public String getExt19() {
    return ext19;
  }

  public void setExt19(String ext19) {
    this.ext19 = ext19;
  }

  @JsonIgnore
  public BillInfo ext20(String ext20) {
    this.ext20 = ext20;
    return this;
  }

  /**
   * ext20
   * @return ext20
   **/
  @ApiModelProperty(value = "ext20")
  public String getExt20() {
    return ext20;
  }

  public void setExt20(String ext20) {
    this.ext20 = ext20;
  }

  @JsonIgnore
  public BillInfo ext21(String ext21) {
    this.ext21 = ext21;
    return this;
  }

  /**
   * ext21
   * @return ext21
   **/
  @ApiModelProperty(value = "ext21")
  public String getExt21() {
    return ext21;
  }

  public void setExt21(String ext21) {
    this.ext21 = ext21;
  }

  @JsonIgnore
  public BillInfo ext22(String ext22) {
    this.ext22 = ext22;
    return this;
  }

  /**
   * ext22
   * @return ext22
   **/
  @ApiModelProperty(value = "ext22")
  public String getExt22() {
    return ext22;
  }

  public void setExt22(String ext22) {
    this.ext22 = ext22;
  }

  @JsonIgnore
  public BillInfo ext23(String ext23) {
    this.ext23 = ext23;
    return this;
  }

  /**
   * ext23
   * @return ext23
   **/
  @ApiModelProperty(value = "ext23")
  public String getExt23() {
    return ext23;
  }

  public void setExt23(String ext23) {
    this.ext23 = ext23;
  }

  @JsonIgnore
  public BillInfo ext24(String ext24) {
    this.ext24 = ext24;
    return this;
  }

  /**
   * ext24
   * @return ext24
   **/
  @ApiModelProperty(value = "ext24")
  public String getExt24() {
    return ext24;
  }

  public void setExt24(String ext24) {
    this.ext24 = ext24;
  }

  @JsonIgnore
  public BillInfo ext25(String ext25) {
    this.ext25 = ext25;
    return this;
  }

  /**
   * ext25
   * @return ext25
   **/
  @ApiModelProperty(value = "ext25")
  public String getExt25() {
    return ext25;
  }

  public void setExt25(String ext25) {
    this.ext25 = ext25;
  }

  @JsonIgnore
  public BillInfo extInfo(String extInfo) {
    this.extInfo = extInfo;
    return this;
  }

  /**
   * extInfo
   * @return extInfo
   **/
  @ApiModelProperty(value = "extInfo")
  public String getExtInfo() {
    return extInfo;
  }

  public void setExtInfo(String extInfo) {
    this.extInfo = extInfo;
  }


  public String getOriginPaperDrawDate() {
    return originPaperDrawDate;
  }

  public void setOriginPaperDrawDate(String originPaperDrawDate) {
    this.originPaperDrawDate = originPaperDrawDate;
  }

  @JsonIgnore
  public BillInfo billItems(List<BillItem> billItems) {
    this.billItems = billItems;
    return this;
  }

  public BillInfo addBillItemsItem(BillItem billItemsItem) {
    this.billItems.add(billItemsItem);
    return this;
  }

  /**
   * 单据明细列表
   * @return billItems
   **/
  @ApiModelProperty(value = "单据明细列表")
  public List<BillItem> getBillItems() {
    return billItems;
  }

  public void setBillItems(List<BillItem> billItems) {
    this.billItems = billItems;
  }

  public Long getSellerGroupId() {
    return sellerGroupId;
  }

  public void setSellerGroupId(Long sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
  }

  public Long getSellerId() {
    return sellerId;
  }

  public void setSellerId(Long sellerId) {
    this.sellerId = sellerId;
  }

  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  public Long getSysOrgId() {
    return sysOrgId;
  }

  public void setSysOrgId(Long sysOrgId) {
    this.sysOrgId = sysOrgId;
  }

  public String getCustomerNo() {
    return customerNo;
  }

  public void setCustomerNo(String customerNo) {
    this.customerNo = customerNo;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BillInfo billInfo = (BillInfo) o;
    return Objects.equals(this.salesbillId, billInfo.salesbillId) &&
            Objects.equals(this.importBatchNo, billInfo.importBatchNo) &&
            Objects.equals(this.salesbillNo, billInfo.salesbillNo) &&
            Objects.equals(this.sellerTenantId, billInfo.sellerTenantId) &&
            Objects.equals(this.sellerNo, billInfo.sellerNo) &&
            Objects.equals(this.sellerName, billInfo.sellerName) &&
            Objects.equals(this.sellerTaxNo, billInfo.sellerTaxNo) &&
            Objects.equals(this.sellerTel, billInfo.sellerTel) &&
            Objects.equals(this.sellerAddress, billInfo.sellerAddress) &&
            Objects.equals(this.sellerBankName, billInfo.sellerBankName) &&
            Objects.equals(this.sellerBankAccount, billInfo.sellerBankAccount) &&
            Objects.equals(this.purchaserName, billInfo.purchaserName) &&
            Objects.equals(this.purchaserTenantId, billInfo.purchaserTenantId) &&
            Objects.equals(this.purchaserCode, billInfo.purchaserCode) &&
            Objects.equals(this.purchaserNo, billInfo.purchaserNo) &&
            Objects.equals(this.purchaserTaxNo, billInfo.purchaserTaxNo) &&
            Objects.equals(this.purchaserTel, billInfo.purchaserTel) &&
            Objects.equals(this.purchaserAddress, billInfo.purchaserAddress) &&
            Objects.equals(this.purchaserBankName, billInfo.purchaserBankName) &&
            Objects.equals(this.purchaserBankAccount, billInfo.purchaserBankAccount) &&
            Objects.equals(this.purchaserId, billInfo.purchaserId) &&
            Objects.equals(this.systemOrig, billInfo.systemOrig) &&
            Objects.equals(this.businessBillType, billInfo.businessBillType) &&
            Objects.equals(this.salesbillType, billInfo.salesbillType) &&
            Objects.equals(this.invoiceType, billInfo.invoiceType) &&
            Objects.equals(this.priceMethod, billInfo.priceMethod) &&
            Objects.equals(this.amountWithTax, billInfo.amountWithTax) &&
            Objects.equals(this.amountWithoutTax, billInfo.amountWithoutTax) &&
            Objects.equals(this.taxAmount, billInfo.taxAmount) &&

            Objects.equals(this.alreadyMakeAmountWithTax, billInfo.alreadyMakeAmountWithTax) &&
            Objects.equals(this.alreadyMakeAmountWithoutTax, billInfo.alreadyMakeAmountWithoutTax) &&
            Objects.equals(this.alreadyMakeAmountTaxAmount, billInfo.alreadyMakeAmountTaxAmount) &&

            Objects.equals(this.discountWithTax, billInfo.discountWithTax) &&
            Objects.equals(this.discountWithoutTax, billInfo.discountWithoutTax) &&
            Objects.equals(this.discountTax, billInfo.discountTax) &&
            Objects.equals(this.prePayWithoutTax, billInfo.prePayWithoutTax) &&
            Objects.equals(this.prePayTax, billInfo.prePayTax) &&
            Objects.equals(this.prePayWithTax, billInfo.prePayWithTax) &&
            Objects.equals(this.originInvoiceNo, billInfo.originInvoiceNo) &&
            Objects.equals(this.originInvoiceCode, billInfo.originInvoiceCode) &&
            Objects.equals(this.redNotification, billInfo.redNotification) &&
            Objects.equals(this.checkerName, billInfo.checkerName) &&
            Objects.equals(this.cashierName, billInfo.cashierName) &&
            Objects.equals(this.invoicerName, billInfo.invoicerName) &&
            Objects.equals(this.receiveUserEmail, billInfo.receiveUserEmail) &&
            Objects.equals(this.receiveUserTel, billInfo.receiveUserTel) &&
            Objects.equals(this.status, billInfo.status) &&
            Objects.equals(this.modifyMark, billInfo.modifyMark) &&
            Objects.equals(this.ext1, billInfo.ext1) &&
            Objects.equals(this.ext2, billInfo.ext2) &&
            Objects.equals(this.ext3, billInfo.ext3) &&
            Objects.equals(this.ext4, billInfo.ext4) &&
            Objects.equals(this.ext5, billInfo.ext5) &&
            Objects.equals(this.ext6, billInfo.ext6) &&
            Objects.equals(this.ext7, billInfo.ext7) &&
            Objects.equals(this.ext8, billInfo.ext8) &&
            Objects.equals(this.ext9, billInfo.ext9) &&
            Objects.equals(this.ext10, billInfo.ext10) &&
            Objects.equals(this.ext11, billInfo.ext11) &&
            Objects.equals(this.ext12, billInfo.ext12) &&
            Objects.equals(this.ext13, billInfo.ext13) &&
            Objects.equals(this.ext14, billInfo.ext14) &&
            Objects.equals(this.ext15, billInfo.ext15) &&
            Objects.equals(this.ext16, billInfo.ext16) &&
            Objects.equals(this.ext17, billInfo.ext17) &&
            Objects.equals(this.ext18, billInfo.ext18) &&
            Objects.equals(this.ext19, billInfo.ext19) &&
            Objects.equals(this.ext20, billInfo.ext20) &&
            Objects.equals(this.ext21, billInfo.ext21) &&
            Objects.equals(this.ext22, billInfo.ext22) &&
            Objects.equals(this.ext23, billInfo.ext23) &&
            Objects.equals(this.ext24, billInfo.ext24) &&
            Objects.equals(this.ext25, billInfo.ext25) &&
            Objects.equals(this.extInfo, billInfo.extInfo) &&
            Objects.equals(this.billItems, billInfo.billItems) &&
            Objects.equals(this.sellerGroupId, billInfo.sellerGroupId) &&
            Objects.equals(this.sellerId, billInfo.sellerId) &&
            Objects.equals(this.purchaserGroupId, billInfo.purchaserGroupId) &&
            Objects.equals(this.sysOrgId, billInfo.sysOrgId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillId, importBatchNo, salesbillNo, sellerTenantId, sellerNo, sellerName, sellerTaxNo, sellerTel, sellerAddress, sellerBankName, sellerBankAccount, purchaserName, purchaserTenantId, purchaserCode, purchaserNo, purchaserTaxNo, purchaserTel, purchaserAddress, purchaserBankName, purchaserBankAccount, purchaserId, systemOrig, businessBillType, salesbillType, invoiceType, priceMethod, amountWithTax, amountWithoutTax,
            taxAmount, alreadyMakeAmountWithTax, alreadyMakeAmountWithoutTax, alreadyMakeAmountTaxAmount, discountWithTax, discountWithoutTax, discountTax, prePayWithoutTax, prePayTax, prePayWithTax, originInvoiceNo, originInvoiceCode, redNotification, checkerName, cashierName, invoicerName, receiveUserEmail, receiveUserTel, status,modifyMark, ext1, ext2, ext3, ext4, ext5, ext6, ext7, ext8, ext9, ext10, ext11, ext12, ext13, ext14, ext15, ext16, ext17, ext18, ext19, ext20, ext21, ext22, ext23, ext24, ext25,
            extInfo, billItems, sellerGroupId,sellerId,purchaserGroupId,sysOrgId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BillInfo {\n");

    sb.append("    salesbillId: ").append(toIndentedString(salesbillId)).append("\n");
    sb.append("    importBatchNo: ").append(toIndentedString(importBatchNo)).append("\n");
    sb.append("    salesbillNo: ").append(toIndentedString(salesbillNo)).append("\n");
    sb.append("    sellerTenantId: ").append(toIndentedString(sellerTenantId)).append("\n");
    sb.append("    sellerNo: ").append(toIndentedString(sellerNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserTenantId: ").append(toIndentedString(purchaserTenantId)).append("\n");
    sb.append("    purchaserCode: ").append(toIndentedString(purchaserCode)).append("\n");
    sb.append("    purchaserNo: ").append(toIndentedString(purchaserNo)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    purchaserId: ").append(toIndentedString(purchaserId)).append("\n");
    sb.append("    systemOrig: ").append(toIndentedString(systemOrig)).append("\n");
    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    salesbillType: ").append(toIndentedString(salesbillType)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");

    sb.append("    alreadyMakeAmountWithTax: ").append(toIndentedString(alreadyMakeAmountWithTax)).append("\n");
    sb.append("    alreadyMakeAmountWithoutTax: ").append(toIndentedString(alreadyMakeAmountWithoutTax)).append("\n");
    sb.append("    alreadyMakeAmountTaxAmount: ").append(toIndentedString(alreadyMakeAmountTaxAmount)).append("\n");

    sb.append("    discountWithTax: ").append(toIndentedString(discountWithTax)).append("\n");
    sb.append("    discountWithoutTax: ").append(toIndentedString(discountWithoutTax)).append("\n");
    sb.append("    discountTax: ").append(toIndentedString(discountTax)).append("\n");
    sb.append("    prePayWithoutTax: ").append(toIndentedString(prePayWithoutTax)).append("\n");
    sb.append("    prePayTax: ").append(toIndentedString(prePayTax)).append("\n");
    sb.append("    prePayWithTax: ").append(toIndentedString(prePayWithTax)).append("\n");
    sb.append("    originInvoiceNo: ").append(toIndentedString(originInvoiceNo)).append("\n");
    sb.append("    originInvoiceCode: ").append(toIndentedString(originInvoiceCode)).append("\n");
    sb.append("    redNotification: ").append(toIndentedString(redNotification)).append("\n");
    sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
    sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    receiveUserEmail: ").append(toIndentedString(receiveUserEmail)).append("\n");
    sb.append("    receiveUserTel: ").append(toIndentedString(receiveUserTel)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    modifyMark: ").append(toIndentedString(modifyMark)).append("\n");

    sb.append("    ext1: ").append(toIndentedString(ext1)).append("\n");
    sb.append("    ext2: ").append(toIndentedString(ext2)).append("\n");
    sb.append("    ext3: ").append(toIndentedString(ext3)).append("\n");
    sb.append("    ext4: ").append(toIndentedString(ext4)).append("\n");
    sb.append("    ext5: ").append(toIndentedString(ext5)).append("\n");
    sb.append("    ext6: ").append(toIndentedString(ext6)).append("\n");
    sb.append("    ext7: ").append(toIndentedString(ext7)).append("\n");
    sb.append("    ext8: ").append(toIndentedString(ext8)).append("\n");
    sb.append("    ext9: ").append(toIndentedString(ext9)).append("\n");
    sb.append("    ext10: ").append(toIndentedString(ext10)).append("\n");
    sb.append("    ext11: ").append(toIndentedString(ext11)).append("\n");
    sb.append("    ext12: ").append(toIndentedString(ext12)).append("\n");
    sb.append("    ext13: ").append(toIndentedString(ext13)).append("\n");
    sb.append("    ext14: ").append(toIndentedString(ext14)).append("\n");
    sb.append("    ext15: ").append(toIndentedString(ext15)).append("\n");
    sb.append("    ext16: ").append(toIndentedString(ext16)).append("\n");
    sb.append("    ext17: ").append(toIndentedString(ext17)).append("\n");
    sb.append("    ext18: ").append(toIndentedString(ext18)).append("\n");
    sb.append("    ext19: ").append(toIndentedString(ext19)).append("\n");
    sb.append("    ext20: ").append(toIndentedString(ext20)).append("\n");
    sb.append("    ext21: ").append(toIndentedString(ext21)).append("\n");
    sb.append("    ext22: ").append(toIndentedString(ext22)).append("\n");
    sb.append("    ext23: ").append(toIndentedString(ext23)).append("\n");
    sb.append("    ext24: ").append(toIndentedString(ext24)).append("\n");
    sb.append("    ext25: ").append(toIndentedString(ext25)).append("\n");
    sb.append("    extInfo: ").append(toIndentedString(extInfo)).append("\n");
    sb.append("    billItems: ").append(toIndentedString(billItems)).append("\n");
    sb.append("    sellerGroupId: ").append(toIndentedString(sellerGroupId)).append("\n");
    sb.append("    sellerGroupId: ").append(toIndentedString(sellerGroupId)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    sysOrgId: ").append(toIndentedString(sysOrgId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
