package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ApiModel(description = "单据号")
public class BillNoRequest {

    @JsonProperty("pageNo")
    @Min(value = 1, message = "页码不能小于1")
    @ApiModelProperty(value = "页码")
    private Integer pageNo;

    @JsonProperty("pageSize")
    @Min(value = 1, message = "每页数据不能小于1")
    @ApiModelProperty(value = "每页数据量")
    private Integer pageSize;

    @NotNull
    @ApiModelProperty("单据号")
    private Long billNo;

    public Long getBillNo() {
        return billNo;
    }

    public void setBillNo(Long billNo) {
        this.billNo = billNo;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return "BillNoRequest{" +
                "billNo=" + billNo +
                '}';
    }
}
