package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 查询条件
 */
@ApiModel(description = "查询条件")

@JsonInclude(NON_NULL)
public class ConditionRequest {
    @JsonProperty("status")
    private String status = null;

    @JsonProperty("userRole")
    private String userRole = null;

    @JsonProperty("sort")
    private  List<Sort> sort = null;

    @JsonProperty("groups")
    private List<List<RequestField>> groups = new ArrayList<List<RequestField>>();


    @JsonIgnore
    public ConditionRequest status(String status) {
        this.status = status;
        return this;
    }

    /**
     * 分类状态，wait_confirmed=待确认,change=有变更,confirming=对方确认中,pending_invoice=待开票
     *
     * @return status
     **/
    @ApiModelProperty(value = "分类状态，wait_confirmed=待确认,change=有变更,confirming=对方确认中,pending_invoice=待开票")
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonIgnore
    public ConditionRequest userRole(String userRole) {
        this.userRole = userRole;
        return this;
    }

    /**
     * seller-销项、purchaser-进项
     *
     * @return userRole
     **/
    @ApiModelProperty(value = "seller-销项、purchaser-进项")
    public String getUserRole() {
        return userRole;
    }

    public void setUserRole(String userRole) {
        this.userRole = userRole;
    }

    @JsonIgnore
    public ConditionRequest filters(List<List<RequestField>> filters) {
        this.groups = filters;
        return this;
    }

    public ConditionRequest addFiltersItem(List<RequestField> filtersItem) {
        this.groups.add(filtersItem);
        return this;
    }

    /**
     * 过滤器条件
     *
     * @return groups
     **/
    @ApiModelProperty(value = "过滤器条件")
    public List<List<RequestField>> getGroups() {
        return groups;
    }

    public void setGroups(List<List<RequestField>> groups) {
        this.groups = groups;
    }


    public List<Sort> getSort() {
        return sort;
    }

    public void setSort(List<Sort> sortList) {
        this.sort = sortList;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ConditionRequest conditionRequest = (ConditionRequest) o;
        return Objects.equals(this.status, conditionRequest.status) &&
                Objects.equals(this.userRole, conditionRequest.userRole) &&
                Objects.equals(this.sort, conditionRequest.sort) &&
                Objects.equals(this.groups, conditionRequest.groups);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, userRole, groups);
    }


    @Override
    public String toString() {
        return "ConditionRequest{" +
                "status='" + status + '\'' +
                ", userRole='" + userRole + '\'' +
                ", sort='" + sort + '\'' +
                ", groups=" + groups +
                '}';
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
