package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 发票详情--包含发票详情信息、发票明细列表信息、发票操作日志列表信息
 */
@ApiModel(description = "发票详情--包含发票详情信息、发票明细列表信息、发票操作日志列表信息")

@JsonInclude(NON_NULL)
public class InvoiceDetails {
  @JsonProperty("invoiceInfo")
  private SellerInvoiceInfo invoiceInfo = null;

  @JsonProperty("sellerInvoiceVehicleInfo")
  private SellerInvoiceVehicleInfo sellerInvoiceVehicleInfo = null;

  @JsonProperty("operationLogList")
  private List<InvoiceOperationLog> operationLogList = new ArrayList<InvoiceOperationLog>();

  @JsonProperty("invoiceItemList")
  private List<InvoiceItem> invoiceItemList = new ArrayList<InvoiceItem>();

  @JsonIgnore
  public InvoiceDetails invoiceInfo(SellerInvoiceInfo invoiceInfo) {
    this.invoiceInfo = invoiceInfo;
    return this;
  }

   /**
   * 发票主信息
   * @return invoiceInfo
  **/
  @ApiModelProperty(value = "发票主信息")
  public SellerInvoiceInfo getInvoiceInfo() {
    return invoiceInfo;
  }

  public void setInvoiceInfo(SellerInvoiceInfo invoiceInfo) {
    this.invoiceInfo = invoiceInfo;
  }

  @ApiModelProperty(value = "机动车发票信息")
  public SellerInvoiceVehicleInfo getSellerInvoiceVehicleInfo() {
    return sellerInvoiceVehicleInfo;
  }

  public void setSellerInvoiceVehicleInfo(SellerInvoiceVehicleInfo sellerInvoiceVehicleInfo) {
    this.sellerInvoiceVehicleInfo = sellerInvoiceVehicleInfo;
  }

  @JsonIgnore
  public InvoiceDetails sellerInvoiceVehicleInfo(SellerInvoiceVehicleInfo sellerInvoiceVehicleInfo) {
    this.sellerInvoiceVehicleInfo = sellerInvoiceVehicleInfo;
    return this;
  }

  @JsonIgnore
  public InvoiceDetails operationLogList(List<InvoiceOperationLog> operationLogList) {
    this.operationLogList = operationLogList;
    return this;
  }

  public InvoiceDetails addOperationLogListItem(InvoiceOperationLog operationLogListItem) {
    this.operationLogList.add(operationLogListItem);
    return this;
  }

   /**
   * 发票操作日志列表
   * @return operationLogList
  **/
  @ApiModelProperty(value = "发票操作日志列表")
  public List<InvoiceOperationLog> getOperationLogList() {
    return operationLogList;
  }

  public void setOperationLogList(List<InvoiceOperationLog> operationLogList) {
    this.operationLogList = operationLogList;
  }

  @JsonIgnore
  public InvoiceDetails invoiceItemList(List<InvoiceItem> invoiceItemList) {
    this.invoiceItemList = invoiceItemList;
    return this;
  }

  public InvoiceDetails addInvoiceItemListItem(InvoiceItem invoiceItemListItem) {
    this.invoiceItemList.add(invoiceItemListItem);
    return this;
  }

   /**
   * 发票明细列表
   * @return invoiceItemList
  **/
  @ApiModelProperty(value = "发票明细列表")
  public List<InvoiceItem> getInvoiceItemList() {
    return invoiceItemList;
  }

  public void setInvoiceItemList(List<InvoiceItem> invoiceItemList) {
    this.invoiceItemList = invoiceItemList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceDetails invoiceDetails = (InvoiceDetails) o;
    return Objects.equals(this.invoiceInfo, invoiceDetails.invoiceInfo) &&
        Objects.equals(this.operationLogList, invoiceDetails.operationLogList) &&
        Objects.equals(this.sellerInvoiceVehicleInfo, invoiceDetails.sellerInvoiceVehicleInfo) &&
        Objects.equals(this.invoiceItemList, invoiceDetails.invoiceItemList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceInfo, operationLogList, invoiceItemList, sellerInvoiceVehicleInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceDetails {\n");

    sb.append("    invoiceInfo: ").append(toIndentedString(invoiceInfo)).append("\n");
    sb.append("    operationLogList: ").append(toIndentedString(operationLogList)).append("\n");
    sb.append("    invoiceItemList: ").append(toIndentedString(invoiceItemList)).append("\n");
    sb.append("    sellerInvoiceVehicleInfo: ").append(toIndentedString(sellerInvoiceVehicleInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
