package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/4/23 16:16
 */
@ApiModel(description = "业务系统发票取消操作请求")

@JsonInclude(NON_NULL)
public class InvoiceOperationCancelRequest {

    @JsonProperty("invoiceCode")
    @ApiModelProperty(value = "发票号码")
    private String invoiceCode;

    @JsonProperty("invoiceNo")
    @ApiModelProperty(value = "发票代码")
    private String invoiceNo;

    @JsonProperty("invoiceType")
    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    @JsonProperty("sellerTaxNo")
    @ApiModelProperty(value = "销方税号")
    private String sellerTaxNo;

    @JsonProperty("purchaserTaxNo")
    @ApiModelProperty(value = "购方税号")
    private String purchaserTaxNo;

    @JsonProperty("requestFrom")
    @ApiModelProperty(value = "请求来源 1 业务系统 2 进项")
    private int requestFrom;

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    public int getRequestFrom() {
        return requestFrom;
    }

    public void setRequestFrom(int requestFrom) {
        this.requestFrom = requestFrom;
    }
}
