package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class MsLogisticsDataRequest {

	@JsonProperty("invoiceNo")
	private String invoiceNo;

	@JsonProperty("invoiceCode")
	private String invoiceCode;

	@JsonProperty("fileType")
	private Integer fileType;

	@JsonProperty("sender")
	private Integer sender;

	@JsonProperty("coverBussinessType")
	private String coverBussinessType;

	/**
	 * 发送类型 1-封面， 2-发票 (含销售清单) 3-附件
	 */
	public Integer getFileType() {
		return fileType;
	}

	public void setFileType(Integer fileType) {
		this.fileType = fileType;
	}

	/**
	 * 寄送者 1-销方 2-购方
	 * 
	 * @return
	 */
	public Integer getSender() {
		return sender;
	}

	public void setSender(Integer sender) {
		this.sender = sender;
	}

	public String getInvoiceNo() {
		return invoiceNo;
	}

	/**
	 * 封面的业务类型 中文 如: 采购订单
	 * 
	 * @return
	 */
	public String getCoverBussinessType() {
		return coverBussinessType;
	}

	public void setCoverBussinessType(String coverBussinessType) {
		this.coverBussinessType = coverBussinessType;
	}

	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public String getInvoiceCode() {
		return invoiceCode;
	}

	public void setInvoiceCode(String invoiceCode) {
		this.invoiceCode = invoiceCode;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		MsLogisticsDataRequest logisticsInvoiceRequest = (MsLogisticsDataRequest) o;
		return Objects.equals(this.invoiceNo, logisticsInvoiceRequest.invoiceNo)
				&& Objects.equals(this.invoiceCode, logisticsInvoiceRequest.invoiceCode)
				&& Objects.equals(this.sender, logisticsInvoiceRequest.sender)
				&& Objects.equals(this.fileType, logisticsInvoiceRequest.fileType);
	}

	@Override
	public int hashCode() {
		return Objects.hash(invoiceCode, invoiceNo, sender, fileType);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class MsLogisticsInvoiceRequest {\n");
		sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
		sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
		sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
		sb.append("    fileType: ").append(toIndentedString(fileType)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}
