package com.xforceplus.seller.invoice.client.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票批次附件
 */
@JsonInclude(NON_NULL)
public class MsUploadAttachment {

	@JsonProperty("batchNo")
	@JSONField(serializeUsing = ToStringSerializer.class)
	private Long batchNo;
	/**
	 * 1-封面 2-附件
	 */
	@JsonProperty("fileType")
	private Integer fileType;
	@JsonProperty("fileInfoList")
	private List<MsFileInfo> fileInfoList = Lists.newArrayList();

	public Long getBatchNo() {
		return batchNo;
	}

	public void setBatchNo(Long batchNo) {
		this.batchNo = batchNo;
	}

	public Integer getFileType() {
		return fileType;
	}

	public void setFileType(Integer fileType) {
		this.fileType = fileType;
	}

	public List<MsFileInfo> getFileInfoList() {
		return fileInfoList;
	}

	public void setFileInfoList(List<MsFileInfo> fileInfoList) {
		this.fileInfoList = fileInfoList;
	}
}
