package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 打印发票或者销货清单结果
 */
@ApiModel(description = "打印发票或者销货清单结果")

@JsonInclude(NON_NULL)
public class PollingPrintInvoiceResult extends PollingModel {

    @ApiModelProperty(value = "发票打印失败总数")
    private int invoiceFailedCount = 0;
    @ApiModelProperty(value = "发票打印成功总数")
    private int invoiceSuccessCount = 0;

    @ApiModelProperty(value = "是否包含销货清单打印 0-不包含 1-包含")
    private String containSellList = "0";

    @ApiModelProperty(value = "打印失败总数")
    private int sellListFailedCount = 0;
    @ApiModelProperty(value = "销货清单打印成功总数")
    private int sellListSuccessCount = 0;

    public int getInvoiceFailedCount() {
        return invoiceFailedCount;
    }

    public void setInvoiceFailedCount(int invoiceFailedCount) {
        this.invoiceFailedCount = invoiceFailedCount;
    }

    public int getInvoiceSuccessCount() {
        return invoiceSuccessCount;
    }

    public void setInvoiceSuccessCount(int invoiceSuccessCount) {
        this.invoiceSuccessCount = invoiceSuccessCount;
    }

    public String getContainSellList() {
        return containSellList;
    }

    public void setContainSellList(String containSellList) {
        this.containSellList = containSellList;
    }

    public int getSellListFailedCount() {
        return sellListFailedCount;
    }

    public void setSellListFailedCount(int sellListFailedCount) {
        this.sellListFailedCount = sellListFailedCount;
    }

    public int getSellListSuccessCount() {
        return sellListSuccessCount;
    }

    public void setSellListSuccessCount(int sellListSuccessCount) {
        this.sellListSuccessCount = sellListSuccessCount;
    }


}
