package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票信息
 */
@ApiModel(description = "预制发票信息")

@JsonInclude(NON_NULL)
public class PreInvoiceInfoPolling {

    @JsonProperty("preInvoiceInfo")
    private PreInvoicePolling preInvoiceInfo = null;

    @JsonProperty("preInvoiceDetails")
    private List<PreInvoiceDetail> preInvoiceDetails = null;

    @ApiModelProperty(value = "预制发票主信息")
    public PreInvoicePolling getPreInvoiceInfo() {
        return preInvoiceInfo;
    }

    public void setPreInvoiceInfo(PreInvoicePolling preInvoiceInfo) {
        this.preInvoiceInfo = preInvoiceInfo;
    }

    @ApiModelProperty(value = "预制发票明细信息")
    public List<PreInvoiceDetail> getPreInvoiceDetails() {
        return preInvoiceDetails;
    }

    public void setPreInvoiceDetails(List<PreInvoiceDetail> preInvoiceDetails) {
        this.preInvoiceDetails = preInvoiceDetails;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((preInvoiceDetails == null) ? 0 : preInvoiceDetails.hashCode());
        result = prime * result + ((preInvoiceInfo == null) ? 0 : preInvoiceInfo.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PreInvoiceInfoPolling other = (PreInvoiceInfoPolling) obj;
        if (preInvoiceDetails == null) {
            if (other.preInvoiceDetails != null)
                return false;
        } else if (!preInvoiceDetails.equals(other.preInvoiceDetails))
            return false;
        if (preInvoiceInfo == null) {
            if (other.preInvoiceInfo != null)
                return false;
        } else if (!preInvoiceInfo.equals(other.preInvoiceInfo))
            return false;
        return true;
    }

}
