package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 打印校验通用接口结果
 */
@ApiModel(description = "打印校验通用接口结果对象")

@JsonInclude(NON_NULL)
public class PrintSellerInvoiceCheckResult {

    @ApiModelProperty(value = "校验结果 0-校验失败 1-校验成功")
    @JsonProperty("checked")
    private Integer checked;

    @ApiModelProperty(value = "打印内容 0-发票带销货清单 1-发票（不含销货清单） 2-销货清单")
    @JsonProperty("printContent")
    private String printContent ;

    @ApiModelProperty(value = "可打印发票id列表")
    @JsonProperty("invoiceIds")
    private List<String> invoiceIds;

    @ApiModelProperty(value = "发票张数  组合")
    @JsonProperty("invoiceSheets")
    private String invoiceSheets ;

    @ApiModelProperty(value = "发票代码")
    @JsonProperty("invoiceCode")
    private String invoiceCode ;

    @ApiModelProperty(value = "发票号码段")
    @JsonProperty("invoiceNoWage")
    private String invoiceNoWage ;

    @ApiModelProperty(value = "含税金额")
    @JsonProperty("totalAmountWithTax")
    private BigDecimal totalAmountWithTax ;

    @ApiModelProperty(value = "不含税金额")
    @JsonProperty("totalAmountWithOutTax")
    private BigDecimal totalAmountWithOutTax ;

    @ApiModelProperty(value = "税额")
    @JsonProperty("totalTaxAmount")
    private BigDecimal totalTaxAmount ;

    @ApiModelProperty(value = "打印公司")
    @JsonProperty("companyName")
    private String companyName ;

    public Integer getChecked() {
        return checked;
    }

    public void setChecked(Integer checked) {
        this.checked = checked;
    }

    public String getPrintContent() {
        return printContent;
    }

    public void setPrintContent(String printContent) {
        this.printContent = printContent;
    }

    public List<String> getInvoiceIds() {
        return invoiceIds;
    }

    public void setInvoiceIds(List<String> invoiceIds) {
        this.invoiceIds = invoiceIds;
    }

    public String getInvoiceSheets() {
        return invoiceSheets;
    }

    public void setInvoiceSheets(String invoiceSheets) {
        this.invoiceSheets = invoiceSheets;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceNoWage() {
        return invoiceNoWage;
    }

    public void setInvoiceNoWage(String invoiceNoWage) {
        this.invoiceNoWage = invoiceNoWage;
    }

    public BigDecimal getTotalAmountWithTax() {
        return totalAmountWithTax;
    }

    public void setTotalAmountWithTax(BigDecimal totalAmountWithTax) {
        this.totalAmountWithTax = totalAmountWithTax;
    }

    public BigDecimal getTotalAmountWithOutTax() {
        return totalAmountWithOutTax;
    }

    public void setTotalAmountWithOutTax(BigDecimal totalAmountWithOutTax) {
        this.totalAmountWithOutTax = totalAmountWithOutTax;
    }

    public BigDecimal getTotalTaxAmount() {
        return totalTaxAmount;
    }

    public void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.totalTaxAmount = totalTaxAmount;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }


    @Override
    public String toString() {
        return "PrintSellerInvoiceCheckResult{" +
                "checked=" + checked + "printContain" + printContent +
                "} " + super.toString();
    }
}
