package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "打印终端信息")
public class PrintTerminalInfo {

    @ApiModelProperty(value = "终端id")
    private String terminalId;

    @ApiModelProperty(value = "设备id")
    private String deviceId;

    @ApiModelProperty(value = "终端名称")
    private String terminalName;

    @JsonProperty("directOnlineFlag")
    private Integer directOnlineFlag;

    @JsonProperty("printerOnlineFlag")
    private Integer printerOnlineFlag;


    @ApiModelProperty(value = "设备唯一编码")
    private String deviceUn;
    @ApiModelProperty(value = "终端唯一编码")
    private String terminalUn;

    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }
    public String getTerminalUn() {
        return terminalUn;
    }

    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
    }


    public String getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getTerminalName() {
        return terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    public Integer getDirectOnlineFlag() {
        return directOnlineFlag;
    }

    public void setDirectOnlineFlag(Integer directOnlineFlag) {
        this.directOnlineFlag = directOnlineFlag;
    }

    public Integer getPrinterOnlineFlag() {
        return printerOnlineFlag;
    }

    public void setPrinterOnlineFlag(Integer printerOnlineFlag) {
        this.printerOnlineFlag = printerOnlineFlag;
    }


    @Override
    public String toString() {
        return "PrintTerminalInfo{" +
                "terminalId='" + terminalId + '\'' +
                ", deviceId='" + deviceId + '\'' +
                ", terminalName='" + terminalName + '\'' +
                ", directOnlineFlag=" + directOnlineFlag +
                ", printerOnlineFlag=" + printerOnlineFlag +
                ", deviceUn='" + deviceUn + '\'' +
                ", terminalUn='" + terminalUn + '\'' +
                '}';
    }
}
