package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * RedflushSellerInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class RedflushSellerInvoiceRequest {
  @ApiModelProperty(value = "可红冲发票id列表")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("terminalId")
  @NotNull
  private Long terminalId;


  @JsonProperty("deviceUn")
  private String deviceUn;

  @JsonProperty("terminalUn")
  private String terminalUn;

  @ApiModelProperty(value = "开票模式, 1=单盘，2=服务器")
  @NotNull
  private String terminalType;

  @JsonProperty("tenantNo")
  private String tenantNo = null;

  @JsonProperty("companyId")
  private String companyId = null;

  @JsonProperty("nextInvoiceNo")
  private String nextInvoiceNo = null;

  @JsonProperty("nextInvoiceCode")
  private String nextInvoiceCode = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("releaseType")
  private Integer releaseType = null;

  @JsonProperty("reason")
  private String reason = null;

  @JsonProperty("customRedFlusReason")
  private String customRedFlusReason = null;

  @Getter
  @Setter
  private String makingReason = null;

  public String getCustomRedFlusReason() {
    return customRedFlusReason;
  }

  public void setCustomRedFlusReason(String customRedFlusReason) {
    this.customRedFlusReason = customRedFlusReason;
  }

  /**
   * 红冲时
   * 红冲票的发票类型
   */
  @JsonProperty("redflushInvoiceType")
  private String redflushInvoiceType = null;

  /**
   * 是否为 自动开具发起的红冲   AutoInvoiceFlag VIRTUAL = 2 为虚拟开具
   */
  @JsonProperty("autoInvoiceFlag")
  private Integer autoInvoiceFlag = null;

  public String getRedflushInvoiceType() {
    return redflushInvoiceType;
  }

  public void setRedflushInvoiceType(String redflushInvoiceType) {
    this.redflushInvoiceType = redflushInvoiceType;
  }

  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  /**
   * 可红冲发票id列表
   * @return invoiceIds
   **/
  @ApiModelProperty(value = "可红冲发票id列表")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 开票设备ID
   * @return deviceId
  **/
  @ApiModelProperty(value = "开票设备ID")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest terminalId(Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * Get terminalId 终端id
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端id")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest terminalType(String terminalType) {
    this.terminalType = terminalType;
    return this;
  }

   /**
   * Get terminalType 终端开票模式, 1=单盘，2=服务器
   * @return terminalType
  **/
  @ApiModelProperty(value = "终端开票模式, 1=单盘，2=服务器")
  public String getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(String terminalType) {
    this.terminalType = terminalType;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest nextInvoiceNo(String nextInvoiceNo) {
    this.nextInvoiceNo = nextInvoiceNo;
    return this;
  }

   /**
   * 下一张发票号码
   * @return nextInvoiceNo
  **/
  @ApiModelProperty(value = "下一张发票号码")
  public String getNextInvoiceNo() {
    return nextInvoiceNo;
  }

  public void setNextInvoiceNo(String nextInvoiceNo) {
    this.nextInvoiceNo = nextInvoiceNo;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest nextInvoiceCode(String nextInvoiceCode) {
    this.nextInvoiceCode = nextInvoiceCode;
    return this;
  }

   /**
   * 下一张发票代码
   * @return nextInvoiceCode
  **/
  @ApiModelProperty(value = "下一张发票代码")
  public String getNextInvoiceCode() {
    return nextInvoiceCode;
  }

  public void setNextInvoiceCode(String nextInvoiceCode) {
    this.nextInvoiceCode = nextInvoiceCode;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest tenantNo(String tenantNo) {
    this.tenantNo = tenantNo;
    return this;
  }

   /**
   * 集团代码
   * @return tenantNo
  **/
  @ApiModelProperty(value = "集团代码")
  public String getTenantNo() {
    return tenantNo;
  }

  public void setTenantNo(String tenantNo) {
    this.tenantNo = tenantNo;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest companyId(String companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public String getCompanyId() {
    return companyId;
  }

  public void setCompanyId(String companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest releaseType(Integer releaseType) {
    this.releaseType = releaseType;
    return this;
  }

   /**
   * 红冲释放模式1-红冲后可对预制发票再次开具 2-红冲后可对业务单明细选择并开具 3-红冲后无法再次开具
   * @return redFlushModel
  **/
  @ApiModelProperty(value = "红冲释放模式1-红冲后可对预制发票再次开具 2-红冲后可对业务单明细选择并开具 3-红冲后无法再次开具")
  public Integer getReleaseType() {
    return releaseType;
  }

  public void setReleaseType(Integer releaseType) {
    this.releaseType = releaseType;
  }

  @JsonIgnore
  public RedflushSellerInvoiceRequest reason(String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * 红冲原因
   * @return reason
  **/
  @ApiModelProperty(value = "红冲原因")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }


  /**
   * 红字信息编号
   * @return redNotificationNo
   **/
  @ApiModelProperty(value = "红字信息编号 ")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  public Integer getAutoInvoiceFlag() {
    return autoInvoiceFlag;
  }

  public void setAutoInvoiceFlag(Integer autoInvoiceFlag) {
    this.autoInvoiceFlag = autoInvoiceFlag;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedflushSellerInvoiceRequest redflushSellerInvoiceRequest = (RedflushSellerInvoiceRequest) o;
    return Objects.equals(this.invoiceIds, redflushSellerInvoiceRequest.invoiceIds) &&
        Objects.equals(this.deviceId, redflushSellerInvoiceRequest.deviceId) &&
        Objects.equals(this.terminalId, redflushSellerInvoiceRequest.terminalId) &&
        Objects.equals(this.terminalType, redflushSellerInvoiceRequest.terminalType) &&
        Objects.equals(this.nextInvoiceNo, redflushSellerInvoiceRequest.nextInvoiceNo) &&
        Objects.equals(this.nextInvoiceCode, redflushSellerInvoiceRequest.nextInvoiceCode) &&
        Objects.equals(this.invoicerName, redflushSellerInvoiceRequest.invoicerName) &&
        Objects.equals(this.tenantNo, redflushSellerInvoiceRequest.tenantNo) &&
        Objects.equals(this.companyId, redflushSellerInvoiceRequest.companyId) &&
        Objects.equals(this.releaseType, redflushSellerInvoiceRequest.releaseType) &&
        Objects.equals(this.redNotificationNo, redflushSellerInvoiceRequest.redNotificationNo) &&
        Objects.equals(this.reason, redflushSellerInvoiceRequest.reason) &&
        Objects.equals(this.autoInvoiceFlag, redflushSellerInvoiceRequest.autoInvoiceFlag)
            ;
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, deviceId, terminalId, terminalType, nextInvoiceNo, nextInvoiceCode, invoicerName, tenantNo, companyId, redNotificationNo, releaseType, reason, autoInvoiceFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedflushSellerInvoiceRequest {\n");

    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    terminalType: ").append(toIndentedString(terminalType)).append("\n");
    sb.append("    nextInvoiceNo: ").append(toIndentedString(nextInvoiceNo)).append("\n");
    sb.append("    nextInvoiceCode: ").append(toIndentedString(nextInvoiceCode)).append("\n");
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    tenantNo: ").append(toIndentedString(tenantNo)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    redFlushModel: ").append(toIndentedString(releaseType)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    autoInvoiceFlag: ").append(toIndentedString(autoInvoiceFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
