package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 数据
 */
@ApiModel(description = "数据")

@JsonInclude(NON_NULL)
public class ResponseData {

    @JsonProperty("preInvoiceIds")
    private List<Long> preInvoiceIds = new ArrayList<Long>();

    @JsonProperty("leftPreInvoiceIds")
    private List<Long> leftPreInvoiceIds = new ArrayList<Long>();

    @JsonProperty("companyName")
    private String companyName = null;

    @ApiModelProperty("最新公司名称")
    private String newCompanyName;

    @JsonProperty("companyId")
    private Long companyId = null;

    @JsonProperty("invoiceCount")
    private Integer invoiceCount = null;

    @JsonProperty("amountWithTax")
    private String amountWithTax = null;

    @JsonProperty("amountWithoutTax")
    private String amountWithoutTax = null;

    @JsonProperty("taxAmount")
    private String taxAmount = null;

    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    @JsonProperty("terminalList")
    private List<TerminalInfo> terminalList = new ArrayList<TerminalInfo>();

    @ApiModelProperty(value = "打印终端列表")
    @JsonProperty("printerTerminalList")
    private List<PrintTerminalInfo> printerTerminalList;

    @ApiModelProperty(value = "蓝字发票号码")
    private String invoiceNo;

    @ApiModelProperty(value = "蓝字发票代码")
    private String invoiceCode;

    @ApiModelProperty(value = "是否跳转发票详情")
    private boolean forwardFlag;

    @ApiModelProperty(value = "单点登陆路径")
    private String ssoUrl;

    @ApiModelProperty(value = "蓝字发票状态")
    private Integer status;

    @ApiModelProperty(value = "红字信息比对信息")
    private RedNoCompareInfo redNoCompareInfo;

    public RedNoCompareInfo getRedNoCompareInfo() {
        return redNoCompareInfo;
    }

    public void setRedNoCompareInfo(RedNoCompareInfo redNoCompareInfo) {
        this.redNoCompareInfo = redNoCompareInfo;
    }

    @JsonIgnore
    public ResponseData preInvoiceIds(List<Long> preInvoiceIds) {
        this.preInvoiceIds = preInvoiceIds;
        return this;
    }

    @JsonIgnore
    public ResponseData leftPreInvoiceIds(List<Long> leftPreInvoiceIds) {
        this.leftPreInvoiceIds = leftPreInvoiceIds;
        return this;
    }

    public ResponseData addPreInvoiceIdsItem(Long preInvoiceIdsItem) {
        this.preInvoiceIds.add(preInvoiceIdsItem);
        return this;
    }

    /**
     * 开具预制发票id集合
     *
     * @return preInvoiceIds
     **/
    @ApiModelProperty(value = "开具预制发票id集合")
    public List<Long> getPreInvoiceIds() {
        return preInvoiceIds;
    }

    public void setPreInvoiceIds(List<Long> preInvoiceIds) {
        this.preInvoiceIds = preInvoiceIds;
    }

    /**
     * 剩余批量开具预制发票id集合
     *
     * @return preInvoiceIds
     **/
    @ApiModelProperty(value = "剩余批量开具预制发票id集合")
    public List<Long> getLeftPreInvoiceIds() {
        return leftPreInvoiceIds;
    }

    public void setLeftPreInvoiceIds(List<Long> leftPreInvoiceIds) {
        this.leftPreInvoiceIds = leftPreInvoiceIds;
    }

    @JsonIgnore
    public ResponseData companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
     * 公司名称
     *
     * @return companyName
     **/
    @ApiModelProperty(value = "公司名称")
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @JsonIgnore
    public ResponseData companyId(Long companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
     * 公司id
     *
     * @return companyId
     **/
    @ApiModelProperty(value = "公司id")
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    @JsonIgnore
    public ResponseData invoiceCount(Integer invoiceCount) {
        this.invoiceCount = invoiceCount;
        return this;
    }

    /**
     * 发票数量
     *
     * @return invoiceCount
     **/
    @ApiModelProperty(value = "发票数量")
    public Integer getInvoiceCount() {
        return invoiceCount;
    }

    public void setInvoiceCount(Integer invoiceCount) {
        this.invoiceCount = invoiceCount;
    }

    @JsonIgnore
    public ResponseData amountWithTax(String amountWithTax) {
        this.amountWithTax = amountWithTax;
        return this;
    }

    /**
     * 含税金额
     *
     * @return amountWithTax
     **/
    @ApiModelProperty(value = "含税金额")
    public String getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(String amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @JsonIgnore
    public ResponseData amountWithoutTax(String amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    /**
     * 不含税金额
     *
     * @return amountWithoutTax
     **/
    @ApiModelProperty(value = "不含税金额")
    public String getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(String amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public ResponseData taxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    /**
     * 税额
     *
     * @return taxAmount
     **/
    @ApiModelProperty(value = "税额")
    public String getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    @JsonIgnore
    public ResponseData terminalList(List<TerminalInfo> terminalList) {
        this.terminalList = terminalList;
        return this;
    }

    public ResponseData addTerminalListItem(TerminalInfo terminalListItem) {
        this.terminalList.add(terminalListItem);
        return this;
    }

    /**
     * 终端列表
     *
     * @return terminalList
     **/
    @ApiModelProperty(value = "终端列表")
    public List<TerminalInfo> getTerminalList() {
        return terminalList;
    }

    public void setTerminalList(List<TerminalInfo> terminalList) {
        this.terminalList = terminalList;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public boolean isForwardFlag() {
        return forwardFlag;
    }

    public void setForwardFlag(boolean forwardFlag) {
        this.forwardFlag = forwardFlag;
    }

    public String getSsoUrl() {
        return ssoUrl;
    }

    public void setSsoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResponseData responseData = (ResponseData) o;
        return Objects.equals(this.preInvoiceIds, responseData.preInvoiceIds)
                && Objects.equals(this.leftPreInvoiceIds, responseData.leftPreInvoiceIds)
                && Objects.equals(this.companyName, responseData.companyName)
                && Objects.equals(this.companyId, responseData.companyId)
                && Objects.equals(this.invoiceCount, responseData.invoiceCount)
                && Objects.equals(this.amountWithTax, responseData.amountWithTax)
                && Objects.equals(this.amountWithoutTax, responseData.amountWithoutTax)
                && Objects.equals(this.taxAmount, responseData.taxAmount)
                && Objects.equals(this.terminalList, responseData.terminalList)
                && Objects.equals(this.redNoCompareInfo, responseData.redNoCompareInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(preInvoiceIds, leftPreInvoiceIds, companyName, companyId, invoiceCount, amountWithTax, amountWithoutTax,
                taxAmount, terminalList,redNoCompareInfo);
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public List<PrintTerminalInfo> getPrinterTerminalList() {
        return printerTerminalList;
    }

    public void setPrinterTerminalList(List<PrintTerminalInfo> printerTerminalList) {
        this.printerTerminalList = printerTerminalList;
    }

    public String getNewCompanyName() {
        return newCompanyName;
    }

    public void setNewCompanyName(String newCompanyName) {
        this.newCompanyName = newCompanyName;
    }

    @Override
    public String toString() {
        return "ResponseData{" + "preInvoiceIds=" + preInvoiceIds + ", leftPreInvoiceIds=" + leftPreInvoiceIds + ", companyName='" + companyName + '\''
                + ", newCompanyName='" + newCompanyName + '\'' + ", companyId=" + companyId + ", invoiceCount="
                + invoiceCount + ", amountWithTax='" + amountWithTax + '\'' + ", amountWithoutTax='" + amountWithoutTax
                + '\'' + ", taxAmount='" + taxAmount + '\'' + ", invoiceType='" + invoiceType + '\''
                + ", terminalList=" + terminalList
                + ", printerTerminalList=" + printerTerminalList
                + ", redNoCompareInfo=" + redNoCompareInfo
                +'}';
    }
}
