package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Size;
import java.math.BigDecimal;

@Data
public class RestRedNotificationMain {

    @ApiModelProperty("申请流水号")
    private String sellerNumber;

    @ApiModelProperty("申请类型")
    private Integer applyType;

    @ApiModelProperty("成品油申请原因")
    private String petroleumReason;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("原发票类型")
    private String originInvoiceType;

    @ApiModelProperty("原蓝字发票代码")
    private String invoiceCode;

    @ApiModelProperty("原蓝字发票号码")
    private String invoiceNo;

    @ApiModelProperty("销方名称")
    private String sellerName;

    @ApiModelProperty("销方税号")
    private String sellerTaxNo;

    @ApiModelProperty("购方名称")
    private String purchaserName;

    @ApiModelProperty("购方名称税号")
    private String purchaserTaxNo;

    @ApiModelProperty("价税合计")
    private BigDecimal amountWithTax;

    @ApiModelProperty("合计金额")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty("合计税额")
    private BigDecimal taxAmount;

    @ApiModelProperty("业务单号")
    @Size(max = 50, message = "业务单号最大长度为50")
    private String billNo;

    @ApiModelProperty("扣除额")
    private BigDecimal deduction;

    @ApiModelProperty("申请人名称")
    private String proposerName;

    @ApiModelProperty("申请人电话")
    private String proposerTel;

    @ApiModelProperty("开票日期")
    private String paperDrawDate;

    @ApiModelProperty("销方编号")
    private String sellerNo;

    @ApiModelProperty("购方编号")
    private String purchaserNo;

    @ApiModelProperty("业务单类型")
    @Size(max = 50, message = "业务单类型最大长度为50")
    private String salesbillType;

    @ApiModelProperty(value = "业务类型", notes = "AP：购方 AR-销方")
    private String businessBillType;

    @ApiModelProperty("预制发票Id")
    private Long invoiceId;

    @ApiModelProperty(value = "协同标识",notes = "0 不协同， 1协同")
    private Integer cooperateFlag;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("发票颜色")
    private Integer invoiceColor;

    @ApiModelProperty(value = "红字信息来源", notes = "0 excel 1 发票 2 预制发票")
    private Integer invoiceOrigin;

    @ApiModelProperty(value = "红字信息导入批次号，兼容历史数据")
    private Long importBatchNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("申请终端")
    private String proposerTerminal;

    @ApiModelProperty("税率")
    private String taxRate;

    @ApiModelProperty("1 销方 2购方")
    private Integer userRole;

    @ApiModelProperty("组织权限Id")
    private Long sysOrgId;

    @ApiModelProperty("开票机号")
    private String machineCode;

    @ApiModelProperty("销方集团id")
    private String sellerGroupId;

    @ApiModelProperty("销方租户id")
    private String sellerTenantId;

    @ApiModelProperty("销方组织ID")
    private String sellerId;

    @ApiModelProperty("购方集团id")
    private String purchaserGroupId;

    @ApiModelProperty("购方租户id")
    private String purchaserTenantId;

    @ApiModelProperty("购方组织ID")
    private String purchaserId;

    @ApiModelProperty("特殊发票标识")
    private Integer specialInvoiceFlag;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

    private String ext6;

    private String ext7;

    private String ext8;

    private String ext9;

    private String ext10;

    private String ext11;

    private String ext12;

    private String ext13;

    private String ext14;

    private String ext15;

    private String ext16;

    private String ext17;

    private String ext18;

    private String ext19;

    private String ext20;

    private String ext21;

    private String ext22;

    private String ext23;

    private String ext24;

    private String ext25;

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setOriginInvoiceType(String originInvoiceType) {
        this.originInvoiceType = originInvoiceType;
    }

    public String getOriginInvoiceType() {
        return originInvoiceType;
    }

    public void setPaperDrawDate(String paperDrawDate) {
        this.paperDrawDate = paperDrawDate;
    }

    public String getPaperDrawDate() {
        return paperDrawDate;
    }

    public Integer getUserRole() {
        return userRole;
    }

    public String getSellerNumber() {
        return sellerNumber;
    }

    public void setSellerNumber(String sellerNumber) {
        this.sellerNumber = sellerNumber;
    }

    public Integer getApplyType() {
        return applyType;
    }

    public void setApplyType(Integer applyType) {
        this.applyType = applyType;
    }

    public String getPetroleumReason() {
        return petroleumReason;
    }

    public void setPetroleumReason(String petroleumReason) {
        this.petroleumReason = petroleumReason;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public BigDecimal getDeduction() {
        return deduction;
    }

    public void setDeduction(BigDecimal deduction) {
        this.deduction = deduction;
    }

    public String getProposerName() {
        return proposerName;
    }

    public void setProposerName(String proposerName) {
        this.proposerName = proposerName;
    }

    public String getProposerTel() {
        return proposerTel;
    }

    public void setProposerTel(String proposerTel) {
        this.proposerTel = proposerTel;
    }

    public String getSellerNo() {
        return sellerNo;
    }

    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
    }

    public String getPurchaserNo() {
        return purchaserNo;
    }

    public void setPurchaserNo(String purchaserNo) {
        this.purchaserNo = purchaserNo;
    }

    public String getSalesbillType() {
        return salesbillType;
    }

    public void setSalesbillType(String salesbillType) {
        this.salesbillType = salesbillType;
    }

    public String getBusinessBillType() {
        return businessBillType;
    }

    public void setBusinessBillType(String businessBillType) {
        this.businessBillType = businessBillType;
    }

    public Long getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    public Integer getCooperateFlag() {
        return cooperateFlag;
    }

    public void setCooperateFlag(Integer cooperateFlag) {
        this.cooperateFlag = cooperateFlag;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Integer getInvoiceColor() {
        return invoiceColor;
    }

    public void setInvoiceColor(Integer invoiceColor) {
        this.invoiceColor = invoiceColor;
    }

    public Integer getInvoiceOrigin() {
        return invoiceOrigin;
    }

    public void setInvoiceOrigin(Integer invoiceOrigin) {
        this.invoiceOrigin = invoiceOrigin;
    }

    public Long getImportBatchNo() {
        return importBatchNo;
    }

    public void setImportBatchNo(Long importBatchNo) {
        this.importBatchNo = importBatchNo;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getProposerTerminal() {
        return proposerTerminal;
    }

    public void setProposerTerminal(String proposerTerminal) {
        this.proposerTerminal = proposerTerminal;
    }

    public String getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    public void setUserRole(Integer userRole) {
        this.userRole = userRole;
    }

    public Long getSysOrgId() {
        return sysOrgId;
    }

    public void setSysOrgId(Long sysOrgId) {
        this.sysOrgId = sysOrgId;
    }

    public String getMachineCode() {
        return machineCode;
    }

    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode;
    }

    public String getSellerGroupId() {
        return sellerGroupId;
    }

    public void setSellerGroupId(String sellerGroupId) {
        this.sellerGroupId = sellerGroupId;
    }

    public String getSellerTenantId() {
        return sellerTenantId;
    }

    public void setSellerTenantId(String sellerTenantId) {
        this.sellerTenantId = sellerTenantId;
    }

    public String getSellerId() {
        return sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public String getPurchaserGroupId() {
        return purchaserGroupId;
    }

    public void setPurchaserGroupId(String purchaserGroupId) {
        this.purchaserGroupId = purchaserGroupId;
    }

    public String getPurchaserTenantId() {
        return purchaserTenantId;
    }

    public void setPurchaserTenantId(String purchaserTenantId) {
        this.purchaserTenantId = purchaserTenantId;
    }

    public String getPurchaserId() {
        return purchaserId;
    }

    public void setPurchaserId(String purchaserId) {
        this.purchaserId = purchaserId;
    }

    public Integer getSpecialInvoiceFlag() {
        return specialInvoiceFlag;
    }

    public void setSpecialInvoiceFlag(Integer specialInvoiceFlag) {
        this.specialInvoiceFlag = specialInvoiceFlag;
    }

    public String getExt1() {
        return ext1;
    }

    public void setExt1(String ext1) {
        this.ext1 = ext1;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getExt4() {
        return ext4;
    }

    public void setExt4(String ext4) {
        this.ext4 = ext4;
    }

    public String getExt5() {
        return ext5;
    }

    public void setExt5(String ext5) {
        this.ext5 = ext5;
    }

    public String getExt6() {
        return ext6;
    }

    public void setExt6(String ext6) {
        this.ext6 = ext6;
    }

    public String getExt7() {
        return ext7;
    }

    public void setExt7(String ext7) {
        this.ext7 = ext7;
    }

    public String getExt8() {
        return ext8;
    }

    public void setExt8(String ext8) {
        this.ext8 = ext8;
    }

    public String getExt9() {
        return ext9;
    }

    public void setExt9(String ext9) {
        this.ext9 = ext9;
    }

    public String getExt10() {
        return ext10;
    }

    public void setExt10(String ext10) {
        this.ext10 = ext10;
    }

    public String getExt11() {
        return ext11;
    }

    public void setExt11(String ext11) {
        this.ext11 = ext11;
    }

    public String getExt12() {
        return ext12;
    }

    public void setExt12(String ext12) {
        this.ext12 = ext12;
    }

    public String getExt13() {
        return ext13;
    }

    public void setExt13(String ext13) {
        this.ext13 = ext13;
    }

    public String getExt14() {
        return ext14;
    }

    public void setExt14(String ext14) {
        this.ext14 = ext14;
    }

    public String getExt15() {
        return ext15;
    }

    public void setExt15(String ext15) {
        this.ext15 = ext15;
    }

    public String getExt16() {
        return ext16;
    }

    public void setExt16(String ext16) {
        this.ext16 = ext16;
    }

    public String getExt17() {
        return ext17;
    }

    public void setExt17(String ext17) {
        this.ext17 = ext17;
    }

    public String getExt18() {
        return ext18;
    }

    public void setExt18(String ext18) {
        this.ext18 = ext18;
    }

    public String getExt19() {
        return ext19;
    }

    public void setExt19(String ext19) {
        this.ext19 = ext19;
    }

    public String getExt20() {
        return ext20;
    }

    public void setExt20(String ext20) {
        this.ext20 = ext20;
    }

    public String getExt21() {
        return ext21;
    }

    public void setExt21(String ext21) {
        this.ext21 = ext21;
    }

    public String getExt22() {
        return ext22;
    }

    public void setExt22(String ext22) {
        this.ext22 = ext22;
    }

    public String getExt23() {
        return ext23;
    }

    public void setExt23(String ext23) {
        this.ext23 = ext23;
    }

    public String getExt24() {
        return ext24;
    }

    public void setExt24(String ext24) {
        this.ext24 = ext24;
    }

    public String getExt25() {
        return ext25;
    }

    public void setExt25(String ext25) {
        this.ext25 = ext25;
    }
}
