package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 机动车发票信息
 */
@ApiModel(description = "机动车发票信息")

@JsonInclude(NON_NULL)
public class SellerInvoiceVehicleInfo {

    @JsonProperty("invoiceId")
    private Long invoiceId = null;

    @JsonProperty("manufacturerName")
    private String manufacturerName = null;

    @JsonProperty("vehicleType")
    private String vehicleType = null;

    @JsonProperty("vehicleBrand")
    private String vehicleBrand = null;

    @JsonProperty("productionArea")
    private String productionArea = null;

    @JsonProperty("certificationNo")
    private String certificationNo = null;

    @JsonProperty("importCertificateNo")
    private String importCertificateNo = null;

    @JsonProperty("commodityInspectionNo")
    private String commodityInspectionNo = null;

    @JsonProperty("engineNo")
    private String engineNo = null;

    @JsonProperty("vehicleNo")
    private String vehicleNo = null;

    @JsonProperty("tonnage")
    private String tonnage = null;

    @JsonProperty("maxCapacity")
    private String maxCapacity = null;

    @JsonProperty("taxPaidProof")
    private String taxPaidProof = null;

    @JsonProperty("identificationId")
    private String identificationId = null;

    @JsonProperty("storeNo")
    private String storeNo = null;

    @JsonProperty("vehicleSellerTel")
    private String vehicleSellerTel = null;

    @JsonProperty("ext1")
    private String ext1 = null;

    @JsonProperty("ext2")
    private String ext2 = null;

    @JsonProperty("printedCode")
    private String printedCode = null;

    @JsonProperty("printedNo")
    private String printedNo = null;

    @JsonProperty("chargeTaxAuthorityName")
    private String chargeTaxAuthorityName = null;

    @JsonProperty("chargeTaxAuthorityCode")
    private String chargeTaxAuthorityCode = null;


    public Long getInvoiceId() {
        return invoiceId;
    }

    /**
     * set method
     *
     * @param invoiceId  主键
     */
    public void setInvoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo invoiceId(Long invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.manufacturer_name：制造商名称
     */
    public String getManufacturerName() {
        return manufacturerName;
    }

    /**
     * set method
     *
     * @param manufacturerName  制造商名称
     */
    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName == null ? null : manufacturerName.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo manufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
        return this;
    }


    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.vehicle_type：车辆类型
     */
    public String getVehicleType() {
        return vehicleType;
    }

    /**
     * set method
     *
     * @param vehicleType  车辆类型
     */
    public void setVehicleType(String vehicleType) {
        this.vehicleType = vehicleType == null ? null : vehicleType.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo vehicleType(String vehicleType) {
        this.vehicleType = vehicleType;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.vehicle_brand：汽车品牌
     */
    public String getVehicleBrand() {
        return vehicleBrand;
    }

    /**
     * set method
     *
     * @param vehicleBrand  汽车品牌
     */
    public void setVehicleBrand(String vehicleBrand) {
        this.vehicleBrand = vehicleBrand == null ? null : vehicleBrand.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo vehicleBrand(String vehicleBrand) {
        this.vehicleBrand = vehicleBrand;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.production_area：产地
     */
    public String getProductionArea() {
        return productionArea;
    }

    /**
     * set method
     *
     * @param productionArea  产地
     */
    public void setProductionArea(String productionArea) {
        this.productionArea = productionArea == null ? null : productionArea.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo productionArea(String productionArea) {
        this.productionArea = productionArea;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.certification_no：机动车合格证编号
     */
    public String getCertificationNo() {
        return certificationNo;
    }

    /**
     * set method
     *
     * @param certificationNo  机动车合格证编号
     */
    public void setCertificationNo(String certificationNo) {
        this.certificationNo = certificationNo == null ? null : certificationNo.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo certificationNo(String certificationNo) {
        this.certificationNo = certificationNo;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.import_certificate_no：进口机动车合格证编号
     */
    public String getImportCertificateNo() {
        return importCertificateNo;
    }

    /**
     * set method
     *
     * @param importCertificateNo  进口机动车合格证编号
     */
    public void setImportCertificateNo(String importCertificateNo) {
        this.importCertificateNo = importCertificateNo == null ? null : importCertificateNo.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo importCertificateNo(String importCertificateNo) {
        this.importCertificateNo = importCertificateNo;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.commodity_inspection_no：商检单号
     */
    public String getCommodityInspectionNo() {
        return commodityInspectionNo;
    }

    /**
     * set method
     *
     * @param commodityInspectionNo  商检单号
     */
    public void setCommodityInspectionNo(String commodityInspectionNo) {
        this.commodityInspectionNo = commodityInspectionNo == null ? null : commodityInspectionNo.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo commodityInspectionNo(String commodityInspectionNo) {
        this.commodityInspectionNo = commodityInspectionNo;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.engine_no：发动机号
     */
    public String getEngineNo() {
        return engineNo;
    }

    /**
     * set method
     *
     * @param engineNo  发动机号
     */
    public void setEngineNo(String engineNo) {
        this.engineNo = engineNo == null ? null : engineNo.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo engineNo(String engineNo) {
        this.engineNo = engineNo;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.vehicle_no：车辆识别号
     */
    public String getVehicleNo() {
        return vehicleNo;
    }

    /**
     * set method
     *
     * @param vehicleNo  车辆识别号
     */
    public void setVehicleNo(String vehicleNo) {
        this.vehicleNo = vehicleNo == null ? null : vehicleNo.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo vehicleNo(String vehicleNo) {
        this.vehicleNo = vehicleNo;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.tonnage：吨位
     */
    public String getTonnage() {
        return tonnage;
    }

    /**
     * set method
     *
     * @param tonnage  吨位
     */
    public void setTonnage(String tonnage) {
        this.tonnage = tonnage == null ? null : tonnage.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo tonnage(String tonnage) {
        this.tonnage = tonnage;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.max_capacity：限乘人数
     */
    public String getMaxCapacity() {
        return maxCapacity;
    }

    /**
     * set method
     *
     * @param maxCapacity  限乘人数
     */
    public void setMaxCapacity(String maxCapacity) {
        this.maxCapacity = maxCapacity == null ? null : maxCapacity.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo maxCapacity(String maxCapacity) {
        this.maxCapacity = maxCapacity;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.tax_paid_proof：完税凭证号码
     */
    public String getTaxPaidProof() {
        return taxPaidProof;
    }

    /**
     * set method
     *
     * @param taxPaidProof  完税凭证号码
     */
    public void setTaxPaidProof(String taxPaidProof) {
        this.taxPaidProof = taxPaidProof == null ? null : taxPaidProof.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo taxPaidProof(String taxPaidProof) {
        this.taxPaidProof = taxPaidProof;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.purchaser_id：消费者身份证号码
     */
    public String getIdentificationId() {
        return identificationId;
    }

    /**
     * set method
     *
     * @param identificationId  消费者身份证号码
     */
    public void setIdentificationId(String identificationId) {
        this.identificationId = identificationId == null ? null : identificationId.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo identificationId(String identificationId) {
        this.identificationId = identificationId;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.storeNo：门店号
     */
    public String getStoreNo() {
        return storeNo;
    }

    /**
     * set method
     *
     * @param storeNo  门店号
     */
    public void setStoreNo(String storeNo) {
        this.storeNo = storeNo == null ? null : storeNo.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo storeNo(String storeNo) {
        this.storeNo = storeNo;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.vehicle_seller_tel：机动销方方电话 （仅机动车使用）
     */
    public String getVehicleSellerTel() {
        return vehicleSellerTel;
    }

    /**
     * set method
     *
     * @param vehicleSellerTel  机动销方方电话 （仅机动车使用）
     */
    public void setVehicleSellerTel(String vehicleSellerTel) {
        this.vehicleSellerTel = vehicleSellerTel == null ? null : vehicleSellerTel.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo vehicleSellerTel(String vehicleSellerTel) {
        this.vehicleSellerTel = vehicleSellerTel;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.ext1：
     */
    public String getExt1() {
        return ext1;
    }

    /**
     * set method
     *
     * @param ext1
     */
    public void setExt1(String ext1) {
        this.ext1 = ext1 == null ? null : ext1.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo ext1(String ext1) {
        this.ext1 = ext1;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.ext2：
     */
    public String getExt2() {
        return ext2;
    }

    /**
     * set method
     *
     * @param ext2
     */
    public void setExt2(String ext2) {
        this.ext2 = ext2 == null ? null : ext2.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo ext2(String ext2) {
        this.ext2 = ext2;
        return this;
    }


    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.printed_code：机打代码
     */
    public String getPrintedCode() {
        return printedCode;
    }

    /**
     * set method
     *
     * @param printedCode  机打代码
     */
    public void setPrintedCode(String printedCode) {
        this.printedCode = printedCode == null ? null : printedCode.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo printedCode(String printedCode) {
        this.printedCode = printedCode;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.printed_no：机打号码
     */
    public String getPrintedNo() {
        return printedNo;
    }

    /**
     * set method
     *
     * @param printedNo  机打号码
     */
    public void setPrintedNo(String printedNo) {
        this.printedNo = printedNo == null ? null : printedNo.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo printedNo(String printedNo) {
        this.printedNo = printedNo;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.charge_tax_authority_name：主管税务机关名称
     */
    public String getChargeTaxAuthorityName() {
        return chargeTaxAuthorityName;
    }

    /**
     * set method
     *
     * @param chargeTaxAuthorityName  主管税务机关名称
     */
    public void setChargeTaxAuthorityName(String chargeTaxAuthorityName) {
        this.chargeTaxAuthorityName = chargeTaxAuthorityName == null ? null : chargeTaxAuthorityName.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo chargeTaxAuthorityName(String chargeTaxAuthorityName) {
        this.chargeTaxAuthorityName = chargeTaxAuthorityName;
        return this;
    }

    /**
     * get method
     *
     * @return inv_seller_invoice_vehicle_info.charge_tax_authority_code：主管税务机关代码
     */
    public String getChargeTaxAuthorityCode() {
        return chargeTaxAuthorityCode;
    }

    /**
     * set method
     *
     * @param chargeTaxAuthorityCode  主管税务机关代码
     */
    public void setChargeTaxAuthorityCode(String chargeTaxAuthorityCode) {
        this.chargeTaxAuthorityCode = chargeTaxAuthorityCode == null ? null : chargeTaxAuthorityCode.trim();
    }

    @JsonIgnore
    public SellerInvoiceVehicleInfo chargeTaxAuthorityCode(String chargeTaxAuthorityCode) {
        this.chargeTaxAuthorityCode = chargeTaxAuthorityCode;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SellerInvoiceVehicleInfo that = (SellerInvoiceVehicleInfo) o;
        return Objects.equals(invoiceId, that.invoiceId) &&
                Objects.equals(manufacturerName, that.manufacturerName) &&
                Objects.equals(vehicleType, that.vehicleType) &&
                Objects.equals(vehicleBrand, that.vehicleBrand) &&
                Objects.equals(productionArea, that.productionArea) &&
                Objects.equals(certificationNo, that.certificationNo) &&
                Objects.equals(importCertificateNo, that.importCertificateNo) &&
                Objects.equals(commodityInspectionNo, that.commodityInspectionNo) &&
                Objects.equals(engineNo, that.engineNo) &&
                Objects.equals(vehicleNo, that.vehicleNo) &&
                Objects.equals(tonnage, that.tonnage) &&
                Objects.equals(maxCapacity, that.maxCapacity) &&
                Objects.equals(taxPaidProof, that.taxPaidProof) &&
                Objects.equals(identificationId, that.identificationId) &&
                Objects.equals(storeNo, that.storeNo) &&
                Objects.equals(vehicleSellerTel, that.vehicleSellerTel) &&
                Objects.equals(ext1, that.ext1) &&
                Objects.equals(ext2, that.ext2) &&
                Objects.equals(printedCode, that.printedCode) &&
                Objects.equals(printedNo, that.printedNo) &&
                Objects.equals(chargeTaxAuthorityName, that.chargeTaxAuthorityName) &&
                Objects.equals(chargeTaxAuthorityCode, that.chargeTaxAuthorityCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(invoiceId, manufacturerName, vehicleType, vehicleBrand, productionArea, certificationNo, importCertificateNo, commodityInspectionNo, engineNo, vehicleNo, tonnage, maxCapacity, taxPaidProof, identificationId, storeNo, vehicleSellerTel, ext1, ext2, printedCode, printedNo, chargeTaxAuthorityName, chargeTaxAuthorityCode);
    }

    @Override
    public String toString() {
        return "SellerInvoiceVehicleInfo{" +
                "invoiceId=" + invoiceId +
                ", manufacturerName='" + manufacturerName + '\'' +
                ", vehicleType='" + vehicleType + '\'' +
                ", vehicleBrand='" + vehicleBrand + '\'' +
                ", productionArea='" + productionArea + '\'' +
                ", certificationNo='" + certificationNo + '\'' +
                ", importCertificateNo='" + importCertificateNo + '\'' +
                ", commodityInspectionNo='" + commodityInspectionNo + '\'' +
                ", engineNo='" + engineNo + '\'' +
                ", vehicleNo='" + vehicleNo + '\'' +
                ", tonnage='" + tonnage + '\'' +
                ", maxCapacity='" + maxCapacity + '\'' +
                ", taxPaidProof='" + taxPaidProof + '\'' +
                ", identificationId='" + identificationId + '\'' +
                ", storeNo='" + storeNo + '\'' +
                ", vehicleSellerTel='" + vehicleSellerTel + '\'' +
                ", ext1='" + ext1 + '\'' +
                ", ext2='" + ext2 + '\'' +
                ", printedCode='" + printedCode + '\'' +
                ", printedNo='" + printedNo + '\'' +
                ", chargeTaxAuthorityName='" + chargeTaxAuthorityName + '\'' +
                ", chargeTaxAuthorityCode='" + chargeTaxAuthorityCode + '\'' +
                '}';
    }
}
