package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * ShowInvoiceHistoryByBatchNoRequest
 */

@JsonInclude(NON_NULL)
public class ShowInvoiceHistoryByBatchNoRequest {
  @JsonProperty("batchNo")
  private Long batchNo = null;

  @JsonIgnore
  public ShowInvoiceHistoryByBatchNoRequest batchNo(Long batchNo) {
    this.batchNo = batchNo;
    return this;
  }

   /**
   * 批次号
   * @return batchNo
  **/
  @ApiModelProperty(value = "批次号")
  public Long getBatchNo() {
    return batchNo;
  }

  public void setBatchNo(Long batchNo) {
    this.batchNo = batchNo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ShowInvoiceHistoryByBatchNoRequest showInvoiceHistoryByBatchNoRequest = (ShowInvoiceHistoryByBatchNoRequest) o;
    return Objects.equals(this.batchNo, showInvoiceHistoryByBatchNoRequest.batchNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(batchNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ShowInvoiceHistoryByBatchNoRequest {\n");

    sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
