package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

@ApiModel(
    description = "发票红冲信息(用于开具红字发票)"
)
public class RedInfo {

    @JsonProperty("originalInvoiceCode")
    private String originalInvoiceCode = null;
    @JsonProperty("originalInvoiceNo")
    private String originalInvoiceNo = null;
    @JsonProperty("redNotificationNo")
    private String redNotificationNo = null;

    public RedInfo(String originalInvoiceCode, String originalInvoiceNo, String redNotificationNo) {
        this.originalInvoiceCode = originalInvoiceCode;
        this.originalInvoiceNo = originalInvoiceNo;
        this.redNotificationNo = redNotificationNo;
    }

    public RedInfo() {
    }

    @ApiModelProperty("原发票代码")
    public String getOriginalInvoiceCode() {
        return originalInvoiceCode;
    }

    public void setOriginalInvoiceCode(String originalInvoiceCode) {
        this.originalInvoiceCode = originalInvoiceCode;
    }

    @ApiModelProperty("原发票号码")
    public String getOriginalInvoiceNo() {
        return originalInvoiceNo;
    }

    public void setOriginalInvoiceNo(String originalInvoiceNo) {
        this.originalInvoiceNo = originalInvoiceNo;
    }

    @ApiModelProperty("红字信息表编号")
    public String getRedNotificationNo() {
        return redNotificationNo;
    }

    public void setRedNotificationNo(String redNotificationNo) {
        this.redNotificationNo = redNotificationNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RedInfo redInfo = (RedInfo) o;
        return Objects.equals(originalInvoiceCode, redInfo.originalInvoiceCode) &&
                Objects.equals(originalInvoiceNo, redInfo.originalInvoiceNo) &&
                Objects.equals(redNotificationNo, redInfo.redNotificationNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(originalInvoiceCode, originalInvoiceNo, redNotificationNo);
    }

    @Override
    public String toString() {
        return "RedInfo{" +
                "originalInvoiceCode='" + originalInvoiceCode + '\'' +
                ", originalInvoiceNo='" + originalInvoiceNo + '\'' +
                ", redNotificationNo='" + redNotificationNo + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
