package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.maintenance.model.FiltersConditionRequest;
import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author <a href="mail to: libaozhong@xforceplus.com" rel="nofollow">libaozhong</a>
 * @Description: [功能描述]
 * @version: 1.0
 * @CreateDate: 2019-07-02 15:15</p>
 */

@Api(value = "operationsManage", description = "运维管理api")
public interface OperationsManageApi {

    @ApiOperation(value = "回填发票", notes = "", response = Response.class,tags = {"OperationsManageApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/operationsManage/preInvoiceBackFill",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response preInvoiceBackFill(@ApiParam(value = "预制发票回填信息", required = true) @RequestBody PreInvoiceBackFillRequest preInvoiceBackFillRequest);


    @ApiOperation(value = "查询发票", notes = "", response = SellerInvoiceQueryResponse.class,tags = {"OperationsManageApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerInvoiceQueryResponse.class)})
    @RequestMapping(value = "/operationsManage/queryInvoiceList",
            produces = {"application/json"},
            method = RequestMethod.POST)
    SellerInvoiceQueryOperationResponse queryInvoiceList(@ApiParam(value = "发票查询请求") @RequestBody SellerInvoiceQueryByConditionRequest sellerInvoiceQueryByConditionRequest);


    @ApiOperation(value = "回填发票验证", notes = "", response = PreviewInvoiceResponse.class,tags = {"OperationsManageApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = PreviewInvoiceResponse.class)})
    @RequestMapping(value = "/operationsManage/preInvoiceBackFillValid",
            produces = {"application/json"},
            method = RequestMethod.POST)
    PreviewInvoiceResponse preInvoiceBackFillValid(@ApiParam(value = "预制发票回填信息", required = true) @RequestBody PreInvoiceBackFillRequest preInvoiceBackFillRequest);


    @ApiOperation(value = "查询预制发票", notes = "", response = SellerInvoiceQueryResponse.class,tags = {"OperationsManageApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SellerInvoiceQueryResponse.class)})
    @RequestMapping(value = "/operationsManage/queryPreInvoiceList",
            produces = {"application/json"},
            method = RequestMethod.POST)
    SellerPreInvoiceOperationQueryResult queryPreInvoiceList(@ApiParam(value = "预制发票查询请求") @RequestBody FiltersConditionRequest filtersConditionRequest);



    @ApiOperation(value = "解锁预制发票", notes = "", response = Response.class,tags = {"OperationsManageApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/operationsManage/unLockPreInovice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response unLockPreInovice(@ApiParam(value = "解锁预制发票") @RequestBody OperationUnlockRequest operationUnlockRequest);


    @ApiOperation(value = "开票失败处理", notes = "", response = Response.class,tags = {"OperationsManageApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/operationsManage/releaseFailBillNo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response makeFailProcess(@ApiParam(value = "业务单号")  @RequestBody MakeFailProcessRequest makeFailProcessRequest);

    @ApiOperation(value = "开票失败处理", notes = "", response = Response.class,tags = {"OperationsManageApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/operationsManage/releaseFailPreInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response makeFailProcessByPreInvoice(@ApiParam(value = "预制发票id")  @RequestBody MakeFailPreInvoiceProcessRequest makeFailPreInvoiceProcessRequest);

    @ApiOperation(value = "处理开票失败成待开票", notes = "", response = Response.class,tags = {"OperationsManageApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/operationsManage/processMakeOutFail",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response processMakeOutFail(@ApiParam(value = "预制发票id")  @RequestBody MakeFailPreInvoiceProcessRequest makeFailPreInvoiceProcessRequest);

}
