package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.xplatframework.apimodel.BaseAsyncResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;


@Api(value = "preInvoice", description = "the preInvoice API")
public interface PreInvoiceApi {

    @ApiOperation(value = "调整预制发票明细金额", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/preInvoice/ajustTolerance",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response ajustTolerance(@ApiParam(value = "预制发票明细信息", required = true) @RequestBody PreInvoiceItemInfo preInvoiceItemInfo);


    @ApiOperation(value = "全部选中确认框数据查询", notes = "", response = AllSelectQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = AllSelectQueryResponse.class)})
    @RequestMapping(value = "/preInvoice/allSelectQuery",
            produces = {"application/json"},
            method = RequestMethod.POST)
    AllSelectQueryResponse allSelectQuery(@ApiParam(value = "全部选中查询条件") @RequestBody ConditionRequest conditionRequest);


    @ApiOperation(value = "修改规则", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/preInvoice/changeRule",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response changeRule(@ApiParam(value = "规则信息") @RequestBody RuleInfo ruleInfo);


    @ApiOperation(value = "批量确认预制发票", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/preInvoice/confirmed",
        produces = { "application/json" },
        method = RequestMethod.POST)
    Response confirmedPreInvoice(@ApiParam(value = "待确认预制发票信息", required = true) @RequestBody PreInvoiceRequest confirmedPreInvoice);


    @ApiOperation(value = "批量删除预制发票", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/preInvoice/delete",
        produces = { "application/json" },
        method = RequestMethod.POST)
    Response deletePreInvoice(@ApiParam(value = "待删除预制发票信息", required = true) @RequestBody PreInvoiceRequest preInvoiceInfo);


    @ApiOperation(value = "锁定预制发票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/preInvoice/lockPreInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response lockPreInvoice(@ApiParam(value = "锁定预制发请求参数", required = true) @RequestBody PreInvoiceRequest lockPreInvoiceRequest);


    @ApiOperation(value = "查看预制发票操作日志", notes = "", response = PreInvoiceOpLog.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "预制发票操作历史", response = PreInvoiceOpLog.class)})
    @RequestMapping(value = "/preInvoice/logList",
        produces = { "application/json" },
        method = RequestMethod.GET)
    PreInvoiceOpLog logList(@NotNull @ApiParam(value = "预制发票id", required = true) @RequestParam(value = "preInvoiceId", required = true) Long preInvoiceId);


    @ApiOperation(value = "开票", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/preInvoice/makeOut",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response makeOut(@ApiParam(value = "预制发票开票信息") @RequestBody MakeOutPreInvoiceInfo makeOutPreInvoiceInfo);


    @ApiOperation(value = "开票并打印", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/preInvoice/makeOutAndPrint",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response makeOutAndPrint(@ApiParam(value = "预制发票开票信息") @RequestBody MakeOutPreInvoiceInfo makeOutPreInvoiceInfo);


    @ApiOperation(value = "开具确认", notes = "", response = MakeOutBeforeConfirmedResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = MakeOutBeforeConfirmedResponse.class)})
    @RequestMapping(value = "/preInvoice/makeOutBeforeConfirmed",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MakeOutBeforeConfirmedResponse makeOutBeforeConfirmed(@ApiParam(value = "全部选中查询条件") @RequestBody PreInvoiceRequest conditionRequest);


    @ApiOperation(value = "预览预制发票", notes = "", response = PreviewInvoiceResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = PreviewInvoiceResponse.class)})
    @RequestMapping(value = "/preInvoice/previewInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    PreviewInvoiceResponse previewInvoice(@ApiParam(value = "预制发票Id") @RequestParam(value = "preInvoiceId", required = false) Long preInvoiceId);

    @ApiOperation(value = "查询发票开具状态", notes = "", response = MakeOutStatusResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = MakeOutStatusResponse.class)})
    @RequestMapping(value = "/preInvoice/queryMakeOutStatus",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MakeOutStatusResponse queryMakeOutStatus(@ApiParam(value = "任务id") @RequestParam(value = "taskId", required = false) String taskId);


    @ApiOperation(value = "查询下一张发票信息", notes = "", response = NextInvoiceInfoResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = NextInvoiceInfoResponse.class)})
    @RequestMapping(value = "/preInvoice/queryNextInvoiceInfo",
            produces = {"application/json"},
            method = RequestMethod.POST)
    NextInvoiceInfoResponse queryNextInvoiceInfo(@ApiParam(value = "任务id") @RequestParam(value = "taskId", required = false) String taskId);


    @ApiOperation(value = "预制发票查询", notes = "", response = SellerPreInvoiceQueryResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = SellerPreInvoiceQueryResponse.class)})
    @RequestMapping(value = "/preInvoice/queryInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    SellerPreInvoiceQueryResponse queryPreInvoice(@ApiParam(value = "发票查询请求") @RequestBody SellerPreInvoiceQueryByConditionRequest sellerPreInvoiceQueryByConditionRequest);


    @ApiOperation(value = "预制发票明细查询", notes = "", response = PreInvoiceDetails.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = PreInvoiceDetails.class)})
    @RequestMapping(value = "/preInvoice/queryPreInvoiceDetail",
            produces = {"application/json"},
            method = RequestMethod.POST)
    PreInvoiceDetails queryPreInvoiceDetail(@ApiParam(value = "明细请求参数") @RequestBody PreInvoicePageInfo preInvoicePageInfo);


    @ApiOperation(value = "批量驳回预制发票", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/preInvoice/reject",
        produces = { "application/json" },
        method = RequestMethod.POST)
    Response rejectPreInvoice(@ApiParam(value = "待驳回预制发票信息", required = true) @RequestBody PreInvoiceRequest rejectPreInvoice);


    @ApiOperation(value = "解锁预制发票", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "SellerPreInvoice", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/preInvoice/unLockPreInvoice",
        produces = { "application/json" },
        method = RequestMethod.POST)
    Response unLockPreInvoice(@ApiParam(value = "锁定预制发请求参数", required = true) @RequestBody PreInvoiceRequest unLockPreInvoiceRequest);


//    @ApiOperation(value = "查询要重置的预制发票拆票规则", notes = "", response = SellerPreInvoiceSplitRuleChangeResponse.class, authorizations = {
//            @Authorization(value = "X-Access-Token"),
//            @Authorization(value = "X-Operation-Token")
//    }, tags = {"SellerPreInvoice",})
//    @ApiResponses(value = {
//            @ApiResponse(code = 200, message = "结果", response = SellerPreInvoiceSplitRuleChangeResponse.class)})
//    @RequestMapping(value = "/querySplitRuleChange",
//            produces = {"application/json"},
//            method = RequestMethod.POST)
//    SellerPreInvoiceSplitRuleChangeResponse querySplitRuleChange(@ApiParam(value = "全部选中查询条件") @RequestBody @Validated PreInvoiceRequest conditionRequest) ;
//
//    @ApiOperation(value = "保存变更后的预制发票拆票规则", notes = "", response = Response.class, authorizations = {
//            @Authorization(value = "X-Access-Token"),
//            @Authorization(value = "X-Operation-Token")
//    }, tags = {"SellerPreInvoice",})
//    @ApiResponses(value = {
//            @ApiResponse(code = 200, message = "结果", response = Response.class)})
//    @RequestMapping(value = "/saveSplitRuleChange",
//            produces = {"application/json"},
//            method = RequestMethod.POST)
//    Response saveSplitRuleChange(@ApiParam(value = "全部选中查询条件") @RequestBody @Validated DeleteMsConfigAddRequest deleteMsConfigAddRequest)  ;


    @ApiOperation(value = "保存生成预制发票操作日志", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = BaseAsyncResponse.class)})
    @RequestMapping(value = "/saveSplitPreInvoiceOperationLog",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response saveSplitPreInvoiceOperationLog(@ApiParam(value = "保存生成预制发票操作日志") @RequestBody @Validated SellerOperationInfo sellerOperationInfo);

    @ApiOperation(value = "根据业务单id查询预制发票总金额", notes = "", response = SellerPreInvoiceResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "查询结果", response = SellerPreInvoiceResponse.class)})
    @RequestMapping(value = "/preInvoice/queryAmountWithTaxTotalBySalesbillId",
            produces = {"application/json"},
            method = RequestMethod.POST)
    SellerPreInvoiceResponse queryAmountWithTaxTotalBySalesbillId(@ApiParam(value = "发票查询请求") @RequestBody SellerPreInvoiceRequest SellerPreInvoiceRequest);

    @ApiOperation(value = "预制发票修改备注", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/updatePreviewInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response updatePreviewInvoice(@ApiParam(value = "待修改备注预制发票信息", required = true) @RequestBody UpdPreInvoiceRequest updPreInvoiceRequest);


    @ApiOperation(value = "批量修改预制发票备注发票类型校验", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"SellerPreInvoice",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class)})
    @RequestMapping(value = "/checkPreviewInvoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response checkPreviewInvoice(@ApiParam(value = "待校验备注预制发票信息", required = true) @RequestBody UpdPreInvoiceRequest updPreInvoiceRequest);

}
