package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 单据明细数据
 */
@ApiModel(description = "单据明细数据")

@JsonInclude(NON_NULL)
public class BillItem {


  @ApiModelProperty("salesbillItemId")
  private String salesbillItemId;

  @ApiModelProperty("salesbillId")
  private String salesbillId;

  @ApiModelProperty("salesbillNo")
  private String salesbillNo;

  @ApiModelProperty("batchNo")
  private Long batchNo;

  @JsonProperty("salesbillItemNo")
  private String salesbillItemNo = null;

  @JsonProperty("itemCode")
  private String itemCode = null;

  @JsonProperty("itemName")
  private String itemName = null;

  @JsonProperty("invoiceType")
  private String invoiceType;

  @JsonProperty("itemShortName")
  private String itemShortName = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("unitPriceWithTax")
  private String unitPriceWithTax = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  @JsonProperty("outterDiscountWithTax")
  private String outterDiscountWithTax = null;

  @JsonProperty("outterDiscountWithoutTax")
  private String outterDiscountWithoutTax = null;

  @JsonProperty("outterDiscountTax")
  private String outterDiscountTax = null;

  @JsonProperty("innerDiscountWithTax")
  private String innerDiscountWithTax = null;

  @JsonProperty("innerDiscountWithoutTax")
  private String innerDiscountWithoutTax = null;

  @JsonProperty("innerDiscountTax")
  private String innerDiscountTax = null;

  @JsonProperty("prepayAmountWithoutTax")
  private String prepayAmountWithoutTax = null;

  @JsonProperty("prepayAmountTax")
  private String prepayAmountTax = null;

  @JsonProperty("quantity")
  private String quantity = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxPre")
  private String taxPre = null;

  @JsonProperty("taxPreCon")
  private String taxPreCon = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonProperty("deductions")
  private String deductions = null;

  @JsonProperty("modifyMark")
  private Integer modifyMark = null;

  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("taxConvertCode")
  private String taxConvertCode = null;

  @JsonProperty("largeCategoryName")
  private String largeCategoryName = null;

  @JsonProperty("medianCategoryName")
  private String medianCategoryName = null;

  @JsonProperty("smallCategoryName")
  private String smallCategoryName = null;

  @JsonProperty("goodsNoVer")
  private String goodsNoVer;

  @JsonProperty("splitItem")
  private boolean splitItem;

  @JsonProperty("redItem")
  private boolean redItem;

  @JsonProperty("remark")
  private String remark;

  @JsonProperty("splitCode")
  private String splitCode;

  @JsonProperty("itemTypeCode")
  private String itemTypeCode;

  @JsonProperty("ext1")
  private String ext1 = null;

  @JsonProperty("ext2")
  private String ext2 = null;

  @JsonProperty("ext3")
  private String ext3 = null;

  @JsonProperty("ext4")
  private String ext4 = null;

  @JsonProperty("ext5")
  private String ext5 = null;

  @JsonProperty("ext6")
  private String ext6 = null;

  @JsonProperty("ext7")
  private String ext7 = null;

  @JsonProperty("ext8")
  private String ext8 = null;

  @JsonProperty("ext9")
  private String ext9 = null;

  @JsonProperty("ext10")
  private String ext10 = null;

  @JsonProperty("ext11")
  private String ext11 = null;

  @JsonProperty("ext12")
  private String ext12 = null;

  @JsonProperty("ext13")
  private String ext13 = null;

  @JsonProperty("ext14")
  private String ext14 = null;

  @JsonProperty("ext15")
  private String ext15 = null;

  @JsonProperty("ext16")
  private String ext16 = null;

  @JsonProperty("ext17")
  private String ext17 = null;

  @JsonProperty("ext18")
  private String ext18 = null;

  @JsonProperty("ext19")
  private String ext19 = null;

  @JsonProperty("ext20")
  private String ext20 = null;

  @JsonProperty("extInfo")
  private String extInfo = null;

  @JsonProperty("origin")
  private int origin;

  @JsonProperty("orderDetailNo")
  private String orderDetailNo;

  @JsonProperty("innerPrepayAmountWithTax")
  private BigDecimal innerPrepayAmountWithTax;

  @JsonProperty("innerPrepayAmountWithoutTax")
  private BigDecimal innerPrepayAmountWithoutTax;

  @JsonProperty("innerPrepayAmountTax")
  private BigDecimal innerPrepayAmountTax;

  @JsonProperty("outterPrepayAmountWithTax")
  private BigDecimal outterPrepayAmountWithTax;

  @JsonProperty("outterPrepayAmountWithoutTax")
  private BigDecimal outterPrepayAmountWithoutTax;

  @JsonProperty("outterPrepayAmountTax")
  private BigDecimal outterPrepayAmountTax;

  @JsonProperty("originalAmountWithoutTax")
  private BigDecimal originalAmountWithoutTax;

  @JsonProperty("discountWithoutTax")
  private BigDecimal discountWithoutTax;

  @JsonProperty("discountTax")
  private BigDecimal discountTax;

  @JsonProperty("discountWithTax")
  private BigDecimal discountWithTax;


  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }


  public String getSalesbillItemId() {
    return salesbillItemId;
  }

  public void setSalesbillItemId(String salesbillItemId) {
    this.salesbillItemId = salesbillItemId;
  }

  public String getSalesbillId() {
    return salesbillId;
  }

  public void setSalesbillId(String salesbillId) {
    this.salesbillId = salesbillId;
  }

  public String getSalesbillNo() {
    return salesbillNo;
  }

  public void setSalesbillNo(String salesbillNo) {
    this.salesbillNo = salesbillNo;
  }

  @JsonIgnore
  public BillItem salesbillItemNo(String salesbillItemNo) {
    this.salesbillItemNo = salesbillItemNo;
    return this;
  }

   /**
   * 单据明细号
   * @return salesbillItemNo
  **/
  @ApiModelProperty(value = "单据明细号")
  public String getSalesbillItemNo() {
    return salesbillItemNo;
  }

  public void setSalesbillItemNo(String salesbillItemNo) {
    this.salesbillItemNo = salesbillItemNo;
  }

  @ApiModelProperty(value = "批次号")
  public Long getBatchNo() {
    return batchNo;
  }

  public void setBatchNo(Long batchNo) {
    this.batchNo = batchNo;
  }

  @JsonIgnore
  public BillItem itemCode(String itemCode) {
    this.itemCode = itemCode;
    return this;
  }

   /**
   * 货物及服务代码
   * @return itemCode
  **/
  @ApiModelProperty(value = "货物及服务代码")
  public String getItemCode() {
    return itemCode;
  }

  public void setItemCode(String itemCode) {
    this.itemCode = itemCode;
  }

  @JsonIgnore
  public BillItem itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * 货物及服务名称
   * @return itemName
  **/
  @ApiModelProperty(value = "货物及服务名称")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  @JsonIgnore
  public BillItem itemShortName(String itemShortName) {
    this.itemShortName = itemShortName;
    return this;
  }

   /**
   * 税编分类简称
   * @return itemShortName
  **/
  @ApiModelProperty(value = "税编分类简称")
  public String getItemShortName() {
    return itemShortName;
  }

  public void setItemShortName(String itemShortName) {
    this.itemShortName = itemShortName;
  }

  @JsonIgnore
  public BillItem itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 型号规格
   * @return itemSpec
  **/
  @ApiModelProperty(value = "型号规格")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public BillItem unitPriceWithTax(String unitPriceWithTax) {
    this.unitPriceWithTax = unitPriceWithTax;
    return this;
  }

   /**
   * 含税单价
   * @return unitPriceWithTax
  **/
  @ApiModelProperty(value = "含税单价")
  public String getUnitPriceWithTax() {
    return unitPriceWithTax;
  }

  public void setUnitPriceWithTax(String unitPriceWithTax) {
    this.unitPriceWithTax = unitPriceWithTax;
  }

  @JsonIgnore
  public BillItem unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 不含税单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "不含税单价")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public BillItem outterDiscountWithTax(String outterDiscountWithTax) {
    this.outterDiscountWithTax = outterDiscountWithTax;
    return this;
  }

   /**
   * Get outterDiscountWithTax
   * @return outterDiscountWithTax
  **/
  @ApiModelProperty(value = "")
  public String getOutterDiscountWithTax() {
    return outterDiscountWithTax;
  }

  public void setOutterDiscountWithTax(String outterDiscountWithTax) {
    this.outterDiscountWithTax = outterDiscountWithTax;
  }

  @JsonIgnore
  public BillItem outterDiscountWithoutTax(String outterDiscountWithoutTax) {
    this.outterDiscountWithoutTax = outterDiscountWithoutTax;
    return this;
  }

   /**
   * 不含税外部折扣额
   * @return outterDiscountWithoutTax
  **/
  @ApiModelProperty(value = "不含税外部折扣额")
  public String getOutterDiscountWithoutTax() {
    return outterDiscountWithoutTax;
  }

  public void setOutterDiscountWithoutTax(String outterDiscountWithoutTax) {
    this.outterDiscountWithoutTax = outterDiscountWithoutTax;
  }

  @JsonIgnore
  public BillItem outterDiscountTax(String outterDiscountTax) {
    this.outterDiscountTax = outterDiscountTax;
    return this;
  }

   /**
   * Get outterDiscountTax
   * @return outterDiscountTax
  **/
  @ApiModelProperty(value = "")
  public String getOutterDiscountTax() {
    return outterDiscountTax;
  }

  public void setOutterDiscountTax(String outterDiscountTax) {
    this.outterDiscountTax = outterDiscountTax;
  }

  @JsonIgnore
  public BillItem innerDiscountWithTax(String innerDiscountWithTax) {
    this.innerDiscountWithTax = innerDiscountWithTax;
    return this;
  }

   /**
   * 含税内部折扣额
   * @return innerDiscountWithTax
  **/
  @ApiModelProperty(value = "含税内部折扣额")
  public String getInnerDiscountWithTax() {
    return innerDiscountWithTax;
  }

  public void setInnerDiscountWithTax(String innerDiscountWithTax) {
    this.innerDiscountWithTax = innerDiscountWithTax;
  }

  @JsonIgnore
  public BillItem innerDiscountWithoutTax(String innerDiscountWithoutTax) {
    this.innerDiscountWithoutTax = innerDiscountWithoutTax;
    return this;
  }

   /**
   * 不含税内部折扣额
   * @return innerDiscountWithoutTax
  **/
  @ApiModelProperty(value = "不含税内部折扣额")
  public String getInnerDiscountWithoutTax() {
    return innerDiscountWithoutTax;
  }

  public void setInnerDiscountWithoutTax(String innerDiscountWithoutTax) {
    this.innerDiscountWithoutTax = innerDiscountWithoutTax;
  }

  @JsonIgnore
  public BillItem innerDiscountTax(String innerDiscountTax) {
    this.innerDiscountTax = innerDiscountTax;
    return this;
  }

   /**
   * 内部折扣税额
   * @return innerDiscountTax
  **/
  @ApiModelProperty(value = "内部折扣税额")
  public String getInnerDiscountTax() {
    return innerDiscountTax;
  }

  public void setInnerDiscountTax(String innerDiscountTax) {
    this.innerDiscountTax = innerDiscountTax;
  }

  @JsonIgnore
  public BillItem prepayAmountWithoutTax(String prepayAmountWithoutTax) {
    this.prepayAmountWithoutTax = prepayAmountWithoutTax;
    return this;
  }

   /**
   * 不含税预付金额
   * @return prepayAmountWithoutTax
  **/
  @ApiModelProperty(value = "不含税预付金额")
  public String getPrepayAmountWithoutTax() {
    return prepayAmountWithoutTax;
  }

  public void setPrepayAmountWithoutTax(String prepayAmountWithoutTax) {
    this.prepayAmountWithoutTax = prepayAmountWithoutTax;
  }

  @JsonIgnore
  public BillItem prepayAmountTax(String prepayAmountTax) {
    this.prepayAmountTax = prepayAmountTax;
    return this;
  }

   /**
   * 含税预付金额
   * @return prepayAmountTax
  **/
  @ApiModelProperty(value = "含税预付金额")
  public String getPrepayAmountTax() {
    return prepayAmountTax;
  }

  public void setPrepayAmountTax(String prepayAmountTax) {
    this.prepayAmountTax = prepayAmountTax;
  }

  @JsonIgnore
  public BillItem quantity(String quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量
   * @return quantity
  **/
  @ApiModelProperty(value = "数量")
  public String getQuantity() {
    return quantity;
  }

  public void setQuantity(String quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public BillItem quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public BillItem amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public BillItem amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public BillItem taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public BillItem taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public BillItem taxPre(String taxPre) {
    this.taxPre = taxPre;
    return this;
  }

   /**
   * 是否享受税收优惠政策0-不1-享受
   * @return taxPre
  **/
  @ApiModelProperty(value = "是否享受税收优惠政策0-不1-享受")
  public String getTaxPre() {
    return taxPre;
  }

  public void setTaxPre(String taxPre) {
    this.taxPre = taxPre;
  }

  @JsonIgnore
  public BillItem taxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
    return this;
  }

   /**
   * 享受税收优惠政策内容
   * @return taxPreCon
  **/
  @ApiModelProperty(value = "享受税收优惠政策内容")
  public String getTaxPreCon() {
    return taxPreCon;
  }

  public void setTaxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
  }

  @JsonIgnore
  public BillItem zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }

  @JsonIgnore
  public BillItem deductions(String deductions) {
    this.deductions = deductions;
    return this;
  }

   /**
   * 可抵扣金额
   * @return deductions
  **/
  @ApiModelProperty(value = "可抵扣金额")
  public String getDeductions() {
    return deductions;
  }

  public void setDeductions(String deductions) {
    this.deductions = deductions;
  }

  @JsonIgnore
  public BillItem modifyMark(Integer modifyMark) {
    this.modifyMark = modifyMark;
    return this;
  }

  /**
   * 修改标识计数
   * @return modifyMark
   **/
  @ApiModelProperty(value = "修改标识计数")
  public Integer getModifyMark() {
    return modifyMark;
  }

  public void setModifyMark(Integer modifyMark) {
    this.modifyMark = modifyMark;
  }

  @JsonIgnore
  public BillItem goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public BillItem taxConvertCode(String taxConvertCode) {
    this.taxConvertCode = taxConvertCode;
    return this;
  }

   /**
   * 转换码
   * @return taxConvertCode
  **/
  @ApiModelProperty(value = "转换码")
  public String getTaxConvertCode() {
    return taxConvertCode;
  }

  public void setTaxConvertCode(String taxConvertCode) {
    this.taxConvertCode = taxConvertCode;
  }

  @JsonIgnore
  public BillItem largeCategoryName(String largeCategoryName) {
    this.largeCategoryName = largeCategoryName;
    return this;
  }

   /**
   * 大项目细类
   * @return largeCategoryName
  **/
  @ApiModelProperty(value = "大项目细类")
  public String getLargeCategoryName() {
    return largeCategoryName;
  }

  public void setLargeCategoryName(String largeCategoryName) {
    this.largeCategoryName = largeCategoryName;
  }

  @JsonIgnore
  public BillItem medianCategoryName(String medianCategoryName) {
    this.medianCategoryName = medianCategoryName;
    return this;
  }

   /**
   * 中项目细类
   * @return medianCategoryName
  **/
  @ApiModelProperty(value = "中项目细类")
  public String getMedianCategoryName() {
    return medianCategoryName;
  }

  public void setMedianCategoryName(String medianCategoryName) {
    this.medianCategoryName = medianCategoryName;
  }

  @JsonIgnore
  public BillItem smallCategoryName(String smallCategoryName) {
    this.smallCategoryName = smallCategoryName;
    return this;
  }

   /**
   * 小项目细类
   * @return smallCategoryName
  **/
  @ApiModelProperty(value = "小项目细类")
  public String getSmallCategoryName() {
    return smallCategoryName;
  }

  public void setSmallCategoryName(String smallCategoryName) {
    this.smallCategoryName = smallCategoryName;
  }

  @JsonIgnore
  public BillItem ext1(String ext1) {
    this.ext1 = ext1;
    return this;
  }

   /**
   * ext1
   * @return ext1
  **/
  @ApiModelProperty(value = "ext1")
  public String getExt1() {
    return ext1;
  }

  public void setExt1(String ext1) {
    this.ext1 = ext1;
  }

  @JsonIgnore
  public BillItem ext2(String ext2) {
    this.ext2 = ext2;
    return this;
  }

   /**
   * ext2
   * @return ext2
  **/
  @ApiModelProperty(value = "ext2")
  public String getExt2() {
    return ext2;
  }

  public void setExt2(String ext2) {
    this.ext2 = ext2;
  }

  @JsonIgnore
  public BillItem ext3(String ext3) {
    this.ext3 = ext3;
    return this;
  }

   /**
   * ext3
   * @return ext3
  **/
  @ApiModelProperty(value = "ext3")
  public String getExt3() {
    return ext3;
  }

  public void setExt3(String ext3) {
    this.ext3 = ext3;
  }

  @JsonIgnore
  public BillItem ext4(String ext4) {
    this.ext4 = ext4;
    return this;
  }

   /**
   * ext4
   * @return ext4
  **/
  @ApiModelProperty(value = "ext4")
  public String getExt4() {
    return ext4;
  }

  public void setExt4(String ext4) {
    this.ext4 = ext4;
  }

  @JsonIgnore
  public BillItem ext5(String ext5) {
    this.ext5 = ext5;
    return this;
  }

   /**
   * ext5
   * @return ext5
  **/
  @ApiModelProperty(value = "ext5")
  public String getExt5() {
    return ext5;
  }

  public void setExt5(String ext5) {
    this.ext5 = ext5;
  }

  @JsonIgnore
  public BillItem ext6(String ext6) {
    this.ext6 = ext6;
    return this;
  }

   /**
   * ext6
   * @return ext6
  **/
  @ApiModelProperty(value = "ext6")
  public String getExt6() {
    return ext6;
  }

  public void setExt6(String ext6) {
    this.ext6 = ext6;
  }

  @JsonIgnore
  public BillItem ext7(String ext7) {
    this.ext7 = ext7;
    return this;
  }

   /**
   * ext7
   * @return ext7
  **/
  @ApiModelProperty(value = "ext7")
  public String getExt7() {
    return ext7;
  }

  public void setExt7(String ext7) {
    this.ext7 = ext7;
  }

  @JsonIgnore
  public BillItem ext8(String ext8) {
    this.ext8 = ext8;
    return this;
  }

   /**
   * ext8
   * @return ext8
  **/
  @ApiModelProperty(value = "ext8")
  public String getExt8() {
    return ext8;
  }

  public void setExt8(String ext8) {
    this.ext8 = ext8;
  }

  @JsonIgnore
  public BillItem ext9(String ext9) {
    this.ext9 = ext9;
    return this;
  }

   /**
   * ext9
   * @return ext9
  **/
  @ApiModelProperty(value = "ext9")
  public String getExt9() {
    return ext9;
  }

  public void setExt9(String ext9) {
    this.ext9 = ext9;
  }

  @JsonIgnore
  public BillItem ext10(String ext10) {
    this.ext10 = ext10;
    return this;
  }

   /**
   * ext10
   * @return ext10
  **/
  @ApiModelProperty(value = "ext10")
  public String getExt10() {
    return ext10;
  }

  public void setExt10(String ext10) {
    this.ext10 = ext10;
  }

  @JsonIgnore
  public BillItem ext11(String ext11) {
    this.ext11 = ext11;
    return this;
  }

   /**
   * ext11
   * @return ext11
  **/
  @ApiModelProperty(value = "ext11")
  public String getExt11() {
    return ext11;
  }

  public void setExt11(String ext11) {
    this.ext11 = ext11;
  }

  @JsonIgnore
  public BillItem ext12(String ext12) {
    this.ext12 = ext12;
    return this;
  }

   /**
   * ext12
   * @return ext12
  **/
  @ApiModelProperty(value = "ext12")
  public String getExt12() {
    return ext12;
  }

  public void setExt12(String ext12) {
    this.ext12 = ext12;
  }

  @JsonIgnore
  public BillItem ext13(String ext13) {
    this.ext13 = ext13;
    return this;
  }

   /**
   * ext13
   * @return ext13
  **/
  @ApiModelProperty(value = "ext13")
  public String getExt13() {
    return ext13;
  }

  public void setExt13(String ext13) {
    this.ext13 = ext13;
  }

  @JsonIgnore
  public BillItem ext14(String ext14) {
    this.ext14 = ext14;
    return this;
  }

   /**
   * ext14
   * @return ext14
  **/
  @ApiModelProperty(value = "ext14")
  public String getExt14() {
    return ext14;
  }

  public void setExt14(String ext14) {
    this.ext14 = ext14;
  }

  @JsonIgnore
  public BillItem ext15(String ext15) {
    this.ext15 = ext15;
    return this;
  }

   /**
   * ext15
   * @return ext15
  **/
  @ApiModelProperty(value = "ext15")
  public String getExt15() {
    return ext15;
  }

  public void setExt15(String ext15) {
    this.ext15 = ext15;
  }

  @JsonIgnore
  public BillItem ext16(String ext16) {
    this.ext16 = ext16;
    return this;
  }

   /**
   * ext16
   * @return ext16
  **/
  @ApiModelProperty(value = "ext16")
  public String getExt16() {
    return ext16;
  }

  public void setExt16(String ext16) {
    this.ext16 = ext16;
  }

  @JsonIgnore
  public BillItem ext17(String ext17) {
    this.ext17 = ext17;
    return this;
  }

   /**
   * ext17
   * @return ext17
  **/
  @ApiModelProperty(value = "ext17")
  public String getExt17() {
    return ext17;
  }

  public void setExt17(String ext17) {
    this.ext17 = ext17;
  }

  @JsonIgnore
  public BillItem ext18(String ext18) {
    this.ext18 = ext18;
    return this;
  }

   /**
   * ext18
   * @return ext18
  **/
  @ApiModelProperty(value = "ext18")
  public String getExt18() {
    return ext18;
  }

  public void setExt18(String ext18) {
    this.ext18 = ext18;
  }

  @JsonIgnore
  public BillItem ext19(String ext19) {
    this.ext19 = ext19;
    return this;
  }

   /**
   * ext19
   * @return ext19
  **/
  @ApiModelProperty(value = "ext19")
  public String getExt19() {
    return ext19;
  }

  public void setExt19(String ext19) {
    this.ext19 = ext19;
  }

  @JsonIgnore
  public BillItem ext20(String ext20) {
    this.ext20 = ext20;
    return this;
  }

   /**
   * ext20
   * @return ext20
  **/
  @ApiModelProperty(value = "ext20")
  public String getExt20() {
    return ext20;
  }

  public void setExt20(String ext20) {
    this.ext20 = ext20;
  }


  @JsonIgnore
  public BillItem extInfo(String extInfo) {
    this.extInfo = extInfo;
    return this;
  }

  /**
   * extInfo
   * @return extInfo
   **/
  @ApiModelProperty(value = "extInfo")
  public String getExtInfo() {
    return extInfo;
  }

  public void setExtInfo(String extInfo) {
    this.extInfo = extInfo;
  }



  public String getGoodsNoVer() {
    return goodsNoVer;
  }

  public void setGoodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
  }

  public boolean isSplitItem() {
    return splitItem;
  }

  public void setSplitItem(boolean splitItem) {
    this.splitItem = splitItem;
  }

  public boolean isRedItem() {
    return redItem;
  }

  public void setRedItem(boolean redItem) {
    this.redItem = redItem;
  }

  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public String getSplitCode() {
    return splitCode;
  }

  public void setSplitCode(String splitCode) {
    this.splitCode = splitCode;
  }

  public String getItemTypeCode() {
    return itemTypeCode;
  }

  public void setItemTypeCode(String itemTypeCode) {
    this.itemTypeCode = itemTypeCode;
  }

  public int getOrigin() {
    return origin;
  }

  public void setOrigin(int origin) {
    this.origin = origin;
  }

  public String getOrderDetailNo() {
    return orderDetailNo;
  }

  public void setOrderDetailNo(String orderDetailNo) {
    this.orderDetailNo = orderDetailNo;
  }

  public BigDecimal getInnerPrepayAmountWithTax() {
    return innerPrepayAmountWithTax;
  }

  public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
    this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
  }

  public BigDecimal getInnerPrepayAmountWithoutTax() {
    return innerPrepayAmountWithoutTax;
  }

  public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
    this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
  }

  public BigDecimal getInnerPrepayAmountTax() {
    return innerPrepayAmountTax;
  }

  public void setInnerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
    this.innerPrepayAmountTax = innerPrepayAmountTax;
  }

  public BigDecimal getOutterPrepayAmountWithTax() {
    return outterPrepayAmountWithTax;
  }

  public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
    this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
  }

  public BigDecimal getOutterPrepayAmountWithoutTax() {
    return outterPrepayAmountWithoutTax;
  }

  public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
    this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
  }

  public BigDecimal getOutterPrepayAmountTax() {
    return outterPrepayAmountTax;
  }

  public void setOutterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
    this.outterPrepayAmountTax = outterPrepayAmountTax;
  }

  public BigDecimal getOriginalAmountWithoutTax() {
    return originalAmountWithoutTax;
  }

  public void setOriginalAmountWithoutTax(BigDecimal originalAmountWithoutTax) {
    this.originalAmountWithoutTax = originalAmountWithoutTax;
  }

  public BigDecimal getDiscountWithoutTax() {
    return discountWithoutTax;
  }

  public void setDiscountWithoutTax(BigDecimal discountWithoutTax) {
    this.discountWithoutTax = discountWithoutTax;
  }

  public BigDecimal getDiscountTax() {
    return discountTax;
  }

  public void setDiscountTax(BigDecimal discountTax) {
    this.discountTax = discountTax;
  }

  public BigDecimal getDiscountWithTax() {
    return discountWithTax;
  }

  public void setDiscountWithTax(BigDecimal discountWithTax) {
    this.discountWithTax = discountWithTax;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BillItem billItem = (BillItem) o;
    return Objects.equals(this.salesbillItemNo, billItem.salesbillItemNo) &&
        Objects.equals(this.itemCode, billItem.itemCode) &&
        Objects.equals(this.itemName, billItem.itemName) &&
        Objects.equals(this.itemShortName, billItem.itemShortName) &&
        Objects.equals(this.itemSpec, billItem.itemSpec) &&
        Objects.equals(this.unitPriceWithTax, billItem.unitPriceWithTax) &&
        Objects.equals(this.unitPrice, billItem.unitPrice) &&
        Objects.equals(this.outterDiscountWithTax, billItem.outterDiscountWithTax) &&
        Objects.equals(this.outterDiscountWithoutTax, billItem.outterDiscountWithoutTax) &&
        Objects.equals(this.outterDiscountTax, billItem.outterDiscountTax) &&
        Objects.equals(this.innerDiscountWithTax, billItem.innerDiscountWithTax) &&
        Objects.equals(this.innerDiscountWithoutTax, billItem.innerDiscountWithoutTax) &&
        Objects.equals(this.innerDiscountTax, billItem.innerDiscountTax) &&
        Objects.equals(this.prepayAmountWithoutTax, billItem.prepayAmountWithoutTax) &&
        Objects.equals(this.prepayAmountTax, billItem.prepayAmountTax) &&
        Objects.equals(this.quantity, billItem.quantity) &&
        Objects.equals(this.quantityUnit, billItem.quantityUnit) &&
        Objects.equals(this.amountWithTax, billItem.amountWithTax) &&
        Objects.equals(this.amountWithoutTax, billItem.amountWithoutTax) &&
        Objects.equals(this.taxAmount, billItem.taxAmount) &&
        Objects.equals(this.taxRate, billItem.taxRate) &&
        Objects.equals(this.taxPre, billItem.taxPre) &&
        Objects.equals(this.taxPreCon, billItem.taxPreCon) &&
        Objects.equals(this.zeroTax, billItem.zeroTax) &&
        Objects.equals(this.deductions, billItem.deductions) &&
        Objects.equals(this.modifyMark, billItem.modifyMark) &&
        Objects.equals(this.goodsTaxNo, billItem.goodsTaxNo) &&
        Objects.equals(this.taxConvertCode, billItem.taxConvertCode) &&
        Objects.equals(this.largeCategoryName, billItem.largeCategoryName) &&
        Objects.equals(this.medianCategoryName, billItem.medianCategoryName) &&
        Objects.equals(this.smallCategoryName, billItem.smallCategoryName) &&
        Objects.equals(this.ext1, billItem.ext1) &&
        Objects.equals(this.ext2, billItem.ext2) &&
        Objects.equals(this.ext3, billItem.ext3) &&
        Objects.equals(this.ext4, billItem.ext4) &&
        Objects.equals(this.ext5, billItem.ext5) &&
        Objects.equals(this.ext6, billItem.ext6) &&
        Objects.equals(this.ext7, billItem.ext7) &&
        Objects.equals(this.ext8, billItem.ext8) &&
        Objects.equals(this.ext9, billItem.ext9) &&
        Objects.equals(this.ext10, billItem.ext10) &&
        Objects.equals(this.ext11, billItem.ext11) &&
        Objects.equals(this.ext12, billItem.ext12) &&
        Objects.equals(this.ext13, billItem.ext13) &&
        Objects.equals(this.ext14, billItem.ext14) &&
        Objects.equals(this.ext15, billItem.ext15) &&
        Objects.equals(this.ext16, billItem.ext16) &&
        Objects.equals(this.ext17, billItem.ext17) &&
        Objects.equals(this.ext18, billItem.ext18) &&
        Objects.equals(this.ext19, billItem.ext19) &&
        Objects.equals(this.ext20, billItem.ext20) &&
        Objects.equals(this.extInfo, billItem.extInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(salesbillItemNo, itemCode, itemName, itemShortName, itemSpec, unitPriceWithTax, unitPrice, outterDiscountWithTax, outterDiscountWithoutTax, outterDiscountTax, innerDiscountWithTax, innerDiscountWithoutTax, innerDiscountTax, prepayAmountWithoutTax, prepayAmountTax, quantity, quantityUnit, amountWithTax, amountWithoutTax, taxAmount, taxRate, taxPre, taxPreCon, zeroTax,
            deductions, modifyMark, goodsTaxNo, taxConvertCode, largeCategoryName, medianCategoryName, smallCategoryName,
            ext1, ext2, ext3, ext4, ext5, ext6, ext7, ext8, ext9, ext10, ext11, ext12, ext13, ext14, ext15, ext16, ext17, ext18, ext19, ext20, extInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BillItem {\n");

    sb.append("    salesbillItemNo: ").append(toIndentedString(salesbillItemNo)).append("\n");
    sb.append("    itemCode: ").append(toIndentedString(itemCode)).append("\n");
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    itemShortName: ").append(toIndentedString(itemShortName)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    unitPriceWithTax: ").append(toIndentedString(unitPriceWithTax)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    outterDiscountWithTax: ").append(toIndentedString(outterDiscountWithTax)).append("\n");
    sb.append("    outterDiscountWithoutTax: ").append(toIndentedString(outterDiscountWithoutTax)).append("\n");
    sb.append("    outterDiscountTax: ").append(toIndentedString(outterDiscountTax)).append("\n");
    sb.append("    innerDiscountWithTax: ").append(toIndentedString(innerDiscountWithTax)).append("\n");
    sb.append("    innerDiscountWithoutTax: ").append(toIndentedString(innerDiscountWithoutTax)).append("\n");
    sb.append("    innerDiscountTax: ").append(toIndentedString(innerDiscountTax)).append("\n");
    sb.append("    prepayAmountWithoutTax: ").append(toIndentedString(prepayAmountWithoutTax)).append("\n");
    sb.append("    prepayAmountTax: ").append(toIndentedString(prepayAmountTax)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
    sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("    deductions: ").append(toIndentedString(deductions)).append("\n");
    sb.append("    modifyMark: ").append(toIndentedString(modifyMark)).append("\n");
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    taxConvertCode: ").append(toIndentedString(taxConvertCode)).append("\n");
    sb.append("    largeCategoryName: ").append(toIndentedString(largeCategoryName)).append("\n");
    sb.append("    medianCategoryName: ").append(toIndentedString(medianCategoryName)).append("\n");
    sb.append("    smallCategoryName: ").append(toIndentedString(smallCategoryName)).append("\n");
    sb.append("    ext1: ").append(toIndentedString(ext1)).append("\n");
    sb.append("    ext2: ").append(toIndentedString(ext2)).append("\n");
    sb.append("    ext3: ").append(toIndentedString(ext3)).append("\n");
    sb.append("    ext4: ").append(toIndentedString(ext4)).append("\n");
    sb.append("    ext5: ").append(toIndentedString(ext5)).append("\n");
    sb.append("    ext6: ").append(toIndentedString(ext6)).append("\n");
    sb.append("    ext7: ").append(toIndentedString(ext7)).append("\n");
    sb.append("    ext8: ").append(toIndentedString(ext8)).append("\n");
    sb.append("    ext9: ").append(toIndentedString(ext9)).append("\n");
    sb.append("    ext10: ").append(toIndentedString(ext10)).append("\n");
    sb.append("    ext11: ").append(toIndentedString(ext11)).append("\n");
    sb.append("    ext12: ").append(toIndentedString(ext12)).append("\n");
    sb.append("    ext13: ").append(toIndentedString(ext13)).append("\n");
    sb.append("    ext14: ").append(toIndentedString(ext14)).append("\n");
    sb.append("    ext15: ").append(toIndentedString(ext15)).append("\n");
    sb.append("    ext16: ").append(toIndentedString(ext16)).append("\n");
    sb.append("    ext17: ").append(toIndentedString(ext17)).append("\n");
    sb.append("    ext18: ").append(toIndentedString(ext18)).append("\n");
    sb.append("    ext19: ").append(toIndentedString(ext19)).append("\n");
    sb.append("    ext20: ").append(toIndentedString(ext20)).append("\n");
    sb.append("    extInfo: ").append(toIndentedString(extInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
