package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class ExportSellerInvoiceRequest {
  @JsonProperty("conditions")
  private Conditions conditions = null;

  @JsonProperty("isAllSelected")
  private Boolean isAllSelected = null;

  @JsonProperty("includes")
  private List<Long> includes = new ArrayList<Long>();

  @JsonProperty("excludes")
  private List<Long> excludes = new ArrayList<Long>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("userRole")
  private Integer userRole = null;

  @JsonProperty("sort")
  private Sort sort = null;

  @ApiModelProperty("搜索查询范围")
  private List<Long> createTime;

  @JsonProperty("groups")
  private List<List<RequestField>> groups = new ArrayList<List<RequestField>>();

  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public Integer getUserRole() {
    return userRole;
  }

  public void setUserRole(Integer userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public ExportSellerInvoiceRequest isAllSelected(Boolean isAllSelected) {
    this.isAllSelected = isAllSelected;
    return this;
  }

   /**
   * 是否全选：true-全选 false-非全选
   * @return isAllSelected
  **/
  @ApiModelProperty(value = "是否全选：true-全选 false-非全选")
  public Boolean getIsAllSelected() {
    return isAllSelected;
  }

  public void setIsAllSelected(Boolean isAllSelected) {
    this.isAllSelected = isAllSelected;
  }

  @JsonIgnore
  public ExportSellerInvoiceRequest includes(List<Long> includes) {
    this.includes = includes;
    return this;
  }

  public ExportSellerInvoiceRequest addIncludesItem(Long includesItem) {
    this.includes.add(includesItem);
    return this;
  }

   /**
   * 包含项-发票序列号主键列表
   * @return includes
  **/
  @ApiModelProperty(value = "包含项-发票序列号主键列表")
  public List<Long> getIncludes() {
    return includes;
  }

  public void setIncludes(List<Long> includes) {
    this.includes = includes;
  }

  @JsonIgnore
  public ExportSellerInvoiceRequest excludes(List<Long> excludes) {
    this.excludes = excludes;
    return this;
  }

  public ExportSellerInvoiceRequest addExcludesItem(Long excludesItem) {
    this.excludes.add(excludesItem);
    return this;
  }

   /**
   * 排除项-发票序列号主键列表
   * @return excludes
  **/
  @ApiModelProperty(value = "排除项-发票序列号主键列表")
  public List<Long> getExcludes() {
    return excludes;
  }

  public void setExcludes(List<Long> excludes) {
    this.excludes = excludes;
  }


    public Conditions getConditions() {
        return conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
  }

    public Boolean getAllSelected() {
        return isAllSelected;
  }

    public void setAllSelected(Boolean allSelected) {
        isAllSelected = allSelected;
  }

    public Sort getSort() {
      return sort;
    }

  public void setSort(Sort sort) {
    this.sort = sort;
  }

  public List<Long> getCreateTime() {
      return createTime;
    }

    public void setCreateTime(List<Long> createTime) {
      this.createTime = createTime;
    }

    public List<List<RequestField>> getGroups() {
      return groups;
    }

    public void setGroups(List<List<RequestField>> groups) {
      this.groups = groups;
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
      if (o == null) {
        return "null";
      }
      return o.toString().replace("\n", "\n    ");
    }

}
