package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@ApiModel("开票记录详情返回的预制发票信息")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IssueRecordPreInvoiceData {
    @ApiModelProperty("预制发票id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long id;
    @ApiModelProperty("发票id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long invoiceId;
    @ApiModelProperty("批次号")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long batchNo;
    @ApiModelProperty("发票号码")
    private String invoiceNo;
    @ApiModelProperty("发票代码")
    private String invoiceCode;
    @ApiModelProperty("发票类型")
    private String invoiceType;
    @ApiModelProperty("开票日期")
    private String paperDrawDate;
    @ApiModelProperty("销方名称")
    private String sellerName;
    @ApiModelProperty("销方税号")
    private String sellerTaxNo;
    @ApiModelProperty("销方租户id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long sellerGroupId;
    @ApiModelProperty("购方名称")
    private String buyerName;
    @ApiModelProperty("购方税号")
    private String buyerTaxNo;
    @ApiModelProperty("购方租户id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long buyerGroupId;
    @ApiModelProperty("业务单号")
    private String salesbillNo;
    @ApiModelProperty("含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal amountWithTax;
    @ApiModelProperty("不含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal amountWithoutTax;
    @ApiModelProperty("税额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal taxAmount;
    @ApiModelProperty("预制发票状态")
    private Integer status;
    @ApiModelProperty("处理标识")
    private String processFlag;
    @ApiModelProperty("处理备注")
    private String processRemark;
    @ApiModelProperty("创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long createTime;
    @ApiModelProperty("更新时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long updateTime;
    @ApiModelProperty("失败原因")
    private String failReason;
    @ApiModelProperty("处理状态")
    private Integer handleStatus;
    @ApiModelProperty("处理原因")
    private String handleReason;
    @ApiModelProperty("发票票种")
    private String invoiceKind;
    @ApiModelProperty("税控发票来源")
    private String taxInvoiceSource;
}
