package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsCancelSplitResponse
 */

@JsonInclude(NON_NULL)
public class MsCancelSplitResponse {
    @JsonProperty("code")
    private Integer code = 1;

    @JsonProperty("message")
    private String message = "取消成功!";

    @JsonProperty("result")
    private Object result = null;

    @JsonIgnore
    public MsCancelSplitResponse code(Integer code) {
        this.code = code;
        return this;
    }

    /**
     * 状态码,1成功，非1失败
     *
     * @return code
     **/
    @ApiModelProperty(value = "状态码,1成功，非1失败")
    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    @JsonIgnore
    public MsCancelSplitResponse message(String message) {
        this.message = message;
        return this;
    }

    /**
     * 失败消息
     *
     * @return message
     **/
    @ApiModelProperty(value = "失败消息")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public MsCancelSplitResponse result(Object result) {
        this.result = result;
        return this;
    }

    /**
     * Get result
     *
     * @return result
     **/
    @ApiModelProperty(value = "")
    public Object getResult() {
        return result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsCancelSplitResponse makeOutBeforConfirmedResponse = (MsCancelSplitResponse) o;
        return Objects.equals(this.code, makeOutBeforConfirmedResponse.code)
                && Objects.equals(this.message, makeOutBeforConfirmedResponse.message)
                && Objects.equals(this.result, makeOutBeforConfirmedResponse.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, result);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MakeOutBeforConfirmedResponse {\n");

        sb.append("    code: ").append(toIndentedString(code)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("    result: ").append(toIndentedString(result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
