package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
@Getter
@Setter
@EqualsAndHashCode
@ToString
public class MsGetRedNoListByInvoiceRequest {

  @JsonProperty("id")
  private Long id;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("applyingStatus")
  private Integer applyingStatus = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("applyTaxNo")
  private String applyTaxNo = null;

  @JsonProperty("applyStatus")
  private String applyStatus = null;

  @ApiModelProperty("搜索查询范围")
  private List<Long> createTime;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("login")
  private Integer login;

  @JsonProperty("applyStartDate")
  private String applyStartDate;

  @JsonProperty("applyendDate")
  private String applyendDate;

  @JsonProperty("requestBillNo")
  private String requestBillNo = null;

  @JsonProperty("deliveryStatus")
  private Integer deliveryStatus;

  @JsonProperty("salesbillType")
  private String salesbillType;

  private String sellerName;

  private String purchaserName;

  @ApiModelProperty("申请时间范围")
  private List<Long> applyDate;

}
