package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.phoenix.esutils.bean.SearchSort;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsSplitAndMakeOutRequest
 */

@JsonInclude(NON_NULL)
public class MsSplitAndMakeOutRequest {

    @JsonProperty("paramList")
    private List<MsSplitAndMakeOutParams> paramList = null;

    @ApiModelProperty(value = "自动开具终端")
    private String terminalCode;

    @JsonProperty("sort")
    private SearchSort sort = null;

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    @JsonIgnore
    public MsSplitAndMakeOutRequest paramList(List<MsSplitAndMakeOutParams> paramList) {
        this.paramList = paramList;
        return this;
    }

    @JsonIgnore
    public MsSplitAndMakeOutRequest sort(SearchSort sort){
        this.sort=sort;
        return this;
    }
    /**
     * 开具操作参数
     * 
     * @return List<MsSplitAndMakeOutParams>
     **/
    @ApiModelProperty(value = "开具操作参数")
    public List<MsSplitAndMakeOutParams> getParamList() {
        return paramList;
    }

    public void setParamList(List<MsSplitAndMakeOutParams> paramList) {
        this.paramList = paramList;
    }

    /**
     * 排序条件
     * @return
     */
    @ApiModelProperty(value = "排序条件")
    public SearchSort getSort() {
        return sort;
    }

    public void setSort(SearchSort sort) {
        this.sort = sort;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof MsSplitAndMakeOutRequest)) return false;

        MsSplitAndMakeOutRequest that = (MsSplitAndMakeOutRequest) o;

        if (paramList != null ? !paramList.equals(that.paramList) : that.paramList != null) return false;
        return sort != null ? sort.equals(that.sort) : that.sort == null;
    }

    @Override
    public int hashCode() {
        int result = paramList != null ? paramList.hashCode() : 0;
        result = 31 * result + (sort != null ? sort.hashCode() : 0);
        return result;
    }
}
