package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 红字信息同步请求实体
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
@Getter
@Setter
@NoArgsConstructor
public class MsSyncRedAllRequest {

    @JsonProperty("terminalInfoList")
    @ApiModelProperty(value = "设备集合")
    private List<TerminalRequest> terminalInfoList;

    @JsonProperty("startDate")
    @ApiModelProperty(value = "开始时间")
    private Long startDate;

    @JsonProperty("endDate")
    @ApiModelProperty(value = "结束时间")
    private Long endDate;

    @ApiModelProperty(value = "税号集合")
    private List<String> taxNoList;

}
