package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsSysRedNoImportDtoInnerRedNotificationDetails
 */

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsSysRedNoImportDtoInnerRedNotificationDetails {
  @JsonProperty("applyType")
  private Integer applyType = null;

  @JsonProperty("taxConvertCode")
  private String taxConvertCode = null;

  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("priceMethod")
  private Long priceMethod = null;

  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("quantityUnit")
  private String quantityUnit = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("quantity")
  private BigDecimal quantity = null;

  @JsonProperty("taxRate")
  private BigDecimal taxRate = null;

  @JsonProperty("unitPrice")
  private BigDecimal unitPrice = null;

  @JsonProperty("unitPriceWithTax")
  private BigDecimal unitPriceWithTax = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("proposerName")
  private String proposerName = null;

  @JsonProperty("proposerTel")
  private String proposerTel = null;

  @JsonProperty("reason")
  private String reason = null;

  @JsonProperty("petroleumReason")
  private String petroleumReason = null;

  @JsonProperty("taxPre")
  private Integer taxPre = null;

  @JsonProperty("taxPreCon")
  private String taxPreCon = null;

  @JsonProperty("zeroTax")
  private Integer zeroTax = null;

  @JsonProperty("deduction")
  private BigDecimal deduction = null;

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails applyType(Integer applyType) {
    this.applyType = applyType;
    return this;
  }

   /**
   * 申请类型 1-销方申请,2-购方申请——未抵扣,3-购方申请——已抵扣
   * @return applyType
  **/
  @ApiModelProperty(value = "申请类型 1-销方申请,2-购方申请——未抵扣,3-购方申请——已抵扣")
  public Integer getApplyType() {
    return applyType;
  }

  public void setApplyType(Integer applyType) {
    this.applyType = applyType;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails taxConvertCode(String taxConvertCode) {
    this.taxConvertCode = taxConvertCode;
    return this;
  }

   /**
   * 税编转换代码
   * @return taxConvertCode
  **/
  @ApiModelProperty(value = "税编转换代码")
  public String getTaxConvertCode() {
    return taxConvertCode;
  }

  public void setTaxConvertCode(String taxConvertCode) {
    this.taxConvertCode = taxConvertCode;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/
  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails priceMethod(Long priceMethod) {
    this.priceMethod = priceMethod;
    return this;
  }

   /**
   * 价格方式:0-不含税，1-含税
   * @return priceMethod
  **/
  @ApiModelProperty(value = "价格方式:0-不含税，1-含税")
  public Long getPriceMethod() {
    return priceMethod;
  }

  public void setPriceMethod(Long priceMethod) {
    this.priceMethod = priceMethod;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails cargoName(String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * 货物或服务名称
   * @return cargoName
  **/
  @ApiModelProperty(value = "货物或服务名称")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/
  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails quantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
    return this;
  }

   /**
   * 数量单位
   * @return quantityUnit
  **/
  @ApiModelProperty(value = "数量单位")
  public String getQuantityUnit() {
    return quantityUnit;
  }

  public void setQuantityUnit(String quantityUnit) {
    this.quantityUnit = quantityUnit;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails amountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public BigDecimal getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(BigDecimal amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails amountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public BigDecimal getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails quantity(BigDecimal quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量
   * @return quantity
  **/
  @ApiModelProperty(value = "数量")
  public BigDecimal getQuantity() {
    return quantity;
  }

  public void setQuantity(BigDecimal quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails taxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率")
  public BigDecimal getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(BigDecimal taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails unitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 不含税单价
   * @return unitPrice
  **/
  @ApiModelProperty(value = "不含税单价")
  public BigDecimal getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(BigDecimal unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails unitPriceWithTax(BigDecimal unitPriceWithTax) {
    this.unitPriceWithTax = unitPriceWithTax;
    return this;
  }

   /**
   * 含税单价
   * @return unitPriceWithTax
  **/
  @ApiModelProperty(value = "含税单价")
  public BigDecimal getUnitPriceWithTax() {
    return unitPriceWithTax;
  }

  public void setUnitPriceWithTax(BigDecimal unitPriceWithTax) {
    this.unitPriceWithTax = unitPriceWithTax;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails proposerName(String proposerName) {
    this.proposerName = proposerName;
    return this;
  }

   /**
   * 申请人名称
   * @return proposerName
  **/
  @ApiModelProperty(value = "申请人名称")
  public String getProposerName() {
    return proposerName;
  }

  public void setProposerName(String proposerName) {
    this.proposerName = proposerName;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails proposerTel(String proposerTel) {
    this.proposerTel = proposerTel;
    return this;
  }

   /**
   * 申请方联系方式
   * @return proposerTel
  **/
  @ApiModelProperty(value = "申请方联系方式")
  public String getProposerTel() {
    return proposerTel;
  }

  public void setProposerTel(String proposerTel) {
    this.proposerTel = proposerTel;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails reason(String reason) {
    this.reason = reason;
    return this;
  }

   /**
   * 申请原因
   * @return reason
  **/
  @ApiModelProperty(value = "申请原因")
  public String getReason() {
    return reason;
  }

  public void setReason(String reason) {
    this.reason = reason;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails petroleumReason(String petroleumReason) {
    this.petroleumReason = petroleumReason;
    return this;
  }

   /**
   * 成品油申请原因
   * @return petroleumReason
  **/
  @ApiModelProperty(value = "成品油申请原因")
  public String getPetroleumReason() {
    return petroleumReason;
  }

  public void setPetroleumReason(String petroleumReason) {
    this.petroleumReason = petroleumReason;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails taxPre(Integer taxPre) {
    this.taxPre = taxPre;
    return this;
  }

   /**
   * 是否享受税收优惠政策0-不1-享受
   * @return taxPre
  **/
  @ApiModelProperty(value = "是否享受税收优惠政策0-不1-享受")
  public Integer getTaxPre() {
    return taxPre;
  }

  public void setTaxPre(Integer taxPre) {
    this.taxPre = taxPre;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails taxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
    return this;
  }

   /**
   * 享受税收优惠政策内容
   * @return taxPreCon
  **/
  @ApiModelProperty(value = "享受税收优惠政策内容")
  public String getTaxPreCon() {
    return taxPreCon;
  }

  public void setTaxPreCon(String taxPreCon) {
    this.taxPreCon = taxPreCon;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails zeroTax(Integer zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率
   * @return zeroTax
  **/
  @ApiModelProperty(value = "零税率标志空-非0税率；0-出口退税1-免税2-不征税3-普通0税率")
  public Integer getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(Integer zeroTax) {
    this.zeroTax = zeroTax;
  }

  @JsonIgnore
  public MsSysRedNoImportDtoInnerRedNotificationDetails deduction(BigDecimal deduction) {
    this.deduction = deduction;
    return this;
  }

   /**
   * 扣除额
   * @return deduction
  **/
  @ApiModelProperty(value = "扣除额")
  public BigDecimal getDeduction() {
    return deduction;
  }

  public void setDeduction(BigDecimal deduction) {
    this.deduction = deduction;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSysRedNoImportDtoInnerRedNotificationDetails sysRedNoImportDtoInnerRedNotificationDetails = (MsSysRedNoImportDtoInnerRedNotificationDetails) o;
    return Objects.equals(this.applyType, sysRedNoImportDtoInnerRedNotificationDetails.applyType) &&
        Objects.equals(this.taxConvertCode, sysRedNoImportDtoInnerRedNotificationDetails.taxConvertCode) &&
        Objects.equals(this.goodsTaxNo, sysRedNoImportDtoInnerRedNotificationDetails.goodsTaxNo) &&
        Objects.equals(this.priceMethod, sysRedNoImportDtoInnerRedNotificationDetails.priceMethod) &&
        Objects.equals(this.cargoName, sysRedNoImportDtoInnerRedNotificationDetails.cargoName) &&
        Objects.equals(this.itemSpec, sysRedNoImportDtoInnerRedNotificationDetails.itemSpec) &&
        Objects.equals(this.quantityUnit, sysRedNoImportDtoInnerRedNotificationDetails.quantityUnit) &&
        Objects.equals(this.amountWithTax, sysRedNoImportDtoInnerRedNotificationDetails.amountWithTax) &&
        Objects.equals(this.amountWithoutTax, sysRedNoImportDtoInnerRedNotificationDetails.amountWithoutTax) &&
        Objects.equals(this.taxAmount, sysRedNoImportDtoInnerRedNotificationDetails.taxAmount) &&
        Objects.equals(this.quantity, sysRedNoImportDtoInnerRedNotificationDetails.quantity) &&
        Objects.equals(this.taxRate, sysRedNoImportDtoInnerRedNotificationDetails.taxRate) &&
        Objects.equals(this.unitPrice, sysRedNoImportDtoInnerRedNotificationDetails.unitPrice) &&
        Objects.equals(this.unitPriceWithTax, sysRedNoImportDtoInnerRedNotificationDetails.unitPriceWithTax) &&
        Objects.equals(this.invoiceCode, sysRedNoImportDtoInnerRedNotificationDetails.invoiceCode) &&
        Objects.equals(this.invoiceNo, sysRedNoImportDtoInnerRedNotificationDetails.invoiceNo) &&
        Objects.equals(this.proposerName, sysRedNoImportDtoInnerRedNotificationDetails.proposerName) &&
        Objects.equals(this.proposerTel, sysRedNoImportDtoInnerRedNotificationDetails.proposerTel) &&
        Objects.equals(this.reason, sysRedNoImportDtoInnerRedNotificationDetails.reason) &&
        Objects.equals(this.petroleumReason, sysRedNoImportDtoInnerRedNotificationDetails.petroleumReason) &&
        Objects.equals(this.taxPre, sysRedNoImportDtoInnerRedNotificationDetails.taxPre) &&
        Objects.equals(this.taxPreCon, sysRedNoImportDtoInnerRedNotificationDetails.taxPreCon) &&
        Objects.equals(this.zeroTax, sysRedNoImportDtoInnerRedNotificationDetails.zeroTax) &&
        Objects.equals(this.deduction, sysRedNoImportDtoInnerRedNotificationDetails.deduction);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applyType, taxConvertCode, goodsTaxNo, priceMethod, cargoName, itemSpec, quantityUnit, amountWithTax, amountWithoutTax, taxAmount, quantity, taxRate, unitPrice, unitPriceWithTax, invoiceCode, invoiceNo, proposerName, proposerTel, reason, petroleumReason, taxPre, taxPreCon, zeroTax, deduction);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSysRedNoImportDtoInnerRedNotificationDetails {\n");

    sb.append("    applyType: ").append(toIndentedString(applyType)).append("\n");
    sb.append("    taxConvertCode: ").append(toIndentedString(taxConvertCode)).append("\n");
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    quantityUnit: ").append(toIndentedString(quantityUnit)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    unitPriceWithTax: ").append(toIndentedString(unitPriceWithTax)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    proposerName: ").append(toIndentedString(proposerName)).append("\n");
    sb.append("    proposerTel: ").append(toIndentedString(proposerTel)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    petroleumReason: ").append(toIndentedString(petroleumReason)).append("\n");
    sb.append("    taxPre: ").append(toIndentedString(taxPre)).append("\n");
    sb.append("    taxPreCon: ").append(toIndentedString(taxPreCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("    deduction: ").append(toIndentedString(deduction)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
