package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@ApiModel(description = "开具状态信息")
@Data
public class NextInvoiceRequest {

    @ApiModelProperty(value = "设备id")
    private Long deviceId;

    @ApiModelProperty(value = "终端id")
    @NotNull
    private Long terminalId;

    @ApiModelProperty(value = "发票主类型")
    @NotBlank
    private String invoiceType;

    @ApiModelProperty(value = "集团id")
    private Long tenantId;


    @ApiModelProperty(value = "设备唯一编码")
    private String deviceUn;

    @ApiModelProperty(value = "终端唯一编码")
    private String terminalUn;

    @ApiModelProperty(value = "销方税号,仅单点登录场景有用")
//    @Getter
//    @Setter
    private String sellerTaxNo;

    @ApiModelProperty("国税发票来源")
    private String taxInvoiceSource;

    @ApiModelProperty(value = "全电开票人")
    private String issuer;
/*
    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }

    public String getTerminalUn() {
        return terminalUn;
    }

    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
    }
    public Long getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Long deviceId) {
        this.deviceId = deviceId;
    }

    public Long getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(Long terminalId) {
        this.terminalId = terminalId;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String toString() {
        return "NextInvoiceRequest{" +
                "deviceId=" + deviceId +
                ", terminalId=" + terminalId +
                ", invoiceType='" + invoiceType + '\'' +
                ", tenantId=" + tenantId +
                '}';
    }*/
}
