package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * PreInvoiceIdList
 */

@JsonInclude(NON_NULL)
public class PreInvoiceIdList {
  @JsonProperty("preInvoiceIds")
  private List<Long> preInvoiceIds = new ArrayList<Long>();

  @JsonProperty("flag")
  private String flag = null;

  @JsonIgnore
  public PreInvoiceIdList preInvoiceIds(List<Long> preInvoiceIds) {
    this.preInvoiceIds = preInvoiceIds;
    return this;
  }

  public PreInvoiceIdList addPreInvoiceIdsItem(Long preInvoiceIdsItem) {
    this.preInvoiceIds.add(preInvoiceIdsItem);
    return this;
  }

   /**
   * 预制发票id集合
   * @return preInvoiceIds
  **/
  @ApiModelProperty(value = "预制发票id集合")
  public List<Long> getPreInvoiceIds() {
    return preInvoiceIds;
  }

  public void setPreInvoiceIds(List<Long> preInvoiceIds) {
    this.preInvoiceIds = preInvoiceIds;
  }

  @JsonIgnore
  public PreInvoiceIdList flag(String flag) {
    this.flag = flag;
    return this;
  }

   /**
   * 操作标记,(lock=锁定，unLock=解锁)
   * @return flag
  **/
  @ApiModelProperty(value = "操作标记,(lock=锁定，unLock=解锁)")
  public String getFlag() {
    return flag;
  }

  public void setFlag(String flag) {
    this.flag = flag;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PreInvoiceIdList preInvoiceIdList = (PreInvoiceIdList) o;
    return Objects.equals(this.preInvoiceIds, preInvoiceIdList.preInvoiceIds) &&
        Objects.equals(this.flag, preInvoiceIdList.flag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(preInvoiceIds, flag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PreInvoiceIdList {\n");

    sb.append("    preInvoiceIds: ").append(toIndentedString(preInvoiceIds)).append("\n");
    sb.append("    flag: ").append(toIndentedString(flag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
