package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票信息
 */
@ApiModel(description = "预制发票信息")

@JsonInclude(NON_NULL)
@Data
public class PreInvoiceMainInfo {
  @JsonProperty("preInvoiceDetailCount")
  private Integer preInvoiceDetailCount = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("batchNo")
  private Long batchNo = null;

  @ApiModelProperty("外部批次号")
  private Long outBatchNo;

  @ApiModelProperty("拆票规则Id")
  private Long ruleId;

  @JsonProperty("sellerTenantId")
  private String sellerTenantId = null;

  @JsonProperty("sellerNo")
  private String sellerNo = null;

  @JsonProperty("sellerCode")
  private String sellerCode = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTenantId")
  private String purchaserTenantId = null;

  @JsonProperty("purchaserId")
  private String purchaserId = null;

  @JsonProperty("purchaserNo")
  private String purchaserNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("salesbillType")
  private String salesbillType = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("paperDrawDate")
  private String paperDrawDate = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("electronicSignature")
  private String electronicSignature = null;

  @JsonProperty("amountWithTax")
  private BigDecimal amountWithTax = null;

  @JsonProperty("amountWithoutTax")
  private BigDecimal amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @ApiModelProperty("显示税率")
  private String taxRateStr;

  @ApiModelProperty("显示税额")
  private String taxAmountStr;

  @JsonProperty("cipherTextTwoCode")
  private String cipherTextTwoCode = null;

  @JsonProperty("preInvoiceDetails")
  private List<PreInvoiceDetail> preInvoiceDetails = new ArrayList<PreInvoiceDetail>();

  @ApiModelProperty("销货清单文件打印标志 (0-否, 1-是)")
  private int saleListFileFlag;

  @ApiModelProperty("打印内容标志 (0-打印单价和数量, 1-不打印单价和数量)")
  private int displayPriceQuality;

  @ApiModelProperty("业务单号")
  private String salesbillNo;

  @ApiModelProperty("批量业务单号")
  private String salesbillNos;

  @ApiModelProperty("预制发票修改标记 0-未修改过 0>-修改次数， 这个标记字段从业务单传递过来的")
  private Integer modifyMark;

  @ApiModelProperty("特殊发票标识")
  private Integer specialInvoiceFlag;

  @ApiModelProperty("特殊发票类型")
  private String specialInvoice;

  @JsonProperty("salesBillIds")
  private List<Long> salesBillIds;

  @ApiModelProperty("红字信息编号")
  private String redNotificationNo;

  @ApiModelProperty("红字预制发票生成标识 ")
  private Integer redFlag;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @ApiModelProperty("机动车信息")
  private SellerPreInvoiceVehicleInfo preInvoiceVehicleInfo;

  @ApiModelProperty("国税发票来源")
  private String taxInvoiceSource;

  @ApiModelProperty("发票票种")
  private String invoiceKind;

}
