package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

@ApiModel(value = "预制发票和原业务单明细金额占比")
public class PreInvoiceOriginalSalesDetailAmountInfo {

    @ApiModelProperty(value = "预制发票含税金额")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "原始业务单明细Id")
    private Long  originalSalesbillItemId;

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public Long getOriginalSalesbillItemId() {
        return originalSalesbillItemId;
    }

    public void setOriginalSalesbillItemId(Long originalSalesbillItemId) {
        this.originalSalesbillItemId = originalSalesbillItemId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PreInvoiceOriginalSalesDetailAmountInfo that = (PreInvoiceOriginalSalesDetailAmountInfo) o;

        if (getAmountWithTax() != null ? !getAmountWithTax().equals(that.getAmountWithTax()) : that.getAmountWithTax() != null)
            return false;
        return getOriginalSalesbillItemId() != null ? getOriginalSalesbillItemId().equals(that.getOriginalSalesbillItemId()) : that.getOriginalSalesbillItemId() == null;
    }

    @Override
    public int hashCode() {
        int result = getAmountWithTax() != null ? getAmountWithTax().hashCode() : 0;
        result = 31 * result + (getOriginalSalesbillItemId() != null ? getOriginalSalesbillItemId().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PreInvoiceOriginalSalesDetailAmountInfo{" +
                "amountWithTax=" + amountWithTax +
                ", originalSalesbillItemId=" + originalSalesbillItemId +
                '}';
    }
}
