package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 预制发票请求参数
 */
@ApiModel(description = "预制发票请求参数")

@JsonInclude(NON_NULL)
public class PreInvoiceRequest extends BaseConfirm {
    @JsonProperty("isAllSelect")
    @NotNull
    private Integer isAllSelect;

    @JsonProperty("includes")
    private List<Long> includes = new ArrayList<Long>();

    @ApiModelProperty(value = "排除的预制发票id集合")
    private List<Long> excludes;

    @JsonProperty("condition")
    private ConditionRequest condition = null;

    @JsonProperty("userRole")
    private UserRole userRole;

    @JsonProperty("invoiceType")
    private String invoiceType;

    @ApiModelProperty("搜索查询范围")
    private List<Long> createTime;

    @ApiModelProperty(value = "页面场景")
    private Integer tableEnum = 0;

    @ApiModelProperty(value = "顺序开具得预制发票")
    private List<Long> sortPreInvoiceIds;

    @ApiModelProperty(value = "是否开具并打印")
    private Boolean isPrint = false;

    @ApiModelProperty(value = "是否已经二次确认")
    private Boolean alreadyConfirm = false;

    public Boolean getAlreadyConfirm() {
        return alreadyConfirm;
    }

    public void setAlreadyConfirm(Boolean alreadyConfirm) {
        this.alreadyConfirm = alreadyConfirm;
    }

    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }


    public UserRole getUserRole() {
        return userRole;
    }

    public void setUserRole(UserRole userRole) {
        this.userRole = userRole;
    }

    @JsonIgnore
    public PreInvoiceRequest isAllSelect(Integer isAllSelect) {
        this.isAllSelect = isAllSelect;
        return this;
    }

    /**
     * 是否全部选中,0=否，1=是
     *
     * @return isAllSelect
     **/
    @ApiModelProperty(value = "是否全部选中,0=否，1=是")
    public Integer getIsAllSelect() {
        return isAllSelect;
    }

    public void setIsAllSelect(Integer isAllSelect) {
        this.isAllSelect = isAllSelect;
    }

    @JsonIgnore
    public PreInvoiceRequest preInvoiceIds(List<Long> preInvoiceIds) {
        this.includes = preInvoiceIds;
        return this;
    }

    public PreInvoiceRequest addPreInvoiceIdsItem(Long preInvoiceIdsItem) {
        this.includes.add(preInvoiceIdsItem);
        return this;
    }

    /**
     * 预制发票id集合
     *
     * @return includes
     **/
    @ApiModelProperty(value = "选中的预制发票id集合")
    public List<Long> getIncludes() {
        return includes;
    }

    public void setIncludes(List<Long> includes) {
        this.includes = includes;
    }

    @JsonIgnore
    public PreInvoiceRequest condition(ConditionRequest condition) {
        this.condition = condition;
        return this;
    }

    public Integer getTableEnum() {
        return tableEnum;
    }

    public void setTableEnum(Integer tableEnum) {
        this.tableEnum = tableEnum;
    }

    public Boolean getIsPrint() {
        return isPrint;
    }

    public void setIsPrint(Boolean isPrint) {
        this.isPrint = isPrint;
    }

    /**
     * 全部选中查询条件
     *
     * @return condition
     **/
    @ApiModelProperty(value = "全部选中查询条件")
    public ConditionRequest getCondition() {
        return condition;
    }

    public void setCondition(ConditionRequest condition) {
        this.condition = condition;
    }


    public List<Long> getCreateTime() {
        return createTime;
    }

    public void setCreateTime(List<Long> createTime) {
        this.createTime = createTime;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PreInvoiceRequest preInvoiceRequest = (PreInvoiceRequest) o;
        return Objects.equals(this.isAllSelect, preInvoiceRequest.isAllSelect) &&
                Objects.equals(this.includes, preInvoiceRequest.includes) &&
                Objects.equals(this.condition, preInvoiceRequest.condition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isAllSelect, includes, condition);
    }


    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public List<Long> getExcludes() {
        return excludes;
    }

    public void setExcludes(List<Long> excludes) {
        this.excludes = excludes;
    }

    public List<Long> getSortPreInvoiceIds() {
        return sortPreInvoiceIds;
    }

    public void setSortPreInvoiceIds(List<Long> sortPreInvoiceIds) {
        this.sortPreInvoiceIds = sortPreInvoiceIds;
    }

    @Override
    public String toString() {
        return "PreInvoiceRequest{" +
                "isAllSelect=" + isAllSelect +
                ", includes=" + includes +
                ", excludes=" + excludes +
                ", condition=" + condition +
                '}';
    }
}
