package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class RedNotificationMainVO extends RestRedNotificationMain {

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("红字信息状态")
    private Integer applyStatus;

    @ApiModelProperty("申请状态")
    private Integer applyingStatus;

    @ApiModelProperty("红字信息表流水号")
    private String requestBillNo;

    @ApiModelProperty("同步状态")
    private Integer syncStatus;

    @ApiModelProperty("税件红字信息状态编码")
    private String redStatus;

    @ApiModelProperty(value = "同步失败原因", notes = "0未同步，1在同步中，2同步成功，3同步失败")
    private String syncMessage;

    @ApiModelProperty(value = "同步code", notes = "0 没有异常,1.同步数据成功更新失败,2 发送到税件 失败，3 其他异常")
    private Integer syncCode;

    @ApiModelProperty("同步流水号")
    private String syncSerialNo;

    @ApiModelProperty("同步状态文字")
    private String syncStatusMsg;

    @ApiModelProperty(value = "下发状态", notes = ": 0下发失败或者未下发，1下发成功")
    private Integer deliveryStatus;

    @ApiModelProperty("下发结果备注")
    private String deliveryRemark;

    @ApiModelProperty("接收失败状态码")
    private String deliveryFailedCode;

    @ApiModelProperty("红字信息编号")
    private String applyTaxNo;

    @ApiModelProperty("红字信息编号")
    private String applyRemark;

    @ApiModelProperty("创建日期")
    private String createTime;

    @ApiModelProperty("销货清单打印标志")
    private Integer saleListFileFlag;

    @ApiModelProperty("更新人")
    private Long updateUser;

    @ApiModelProperty("设备唯一码")
    private String deviceUn;

    @ApiModelProperty("终端唯一码")
    private String terminalUn;

    @ApiModelProperty("终端类型 1-单盘 2-服务器 4-区块链")
    private Integer terminalType;

    @ApiModelProperty("用户ID下发数据需要,由属地直接传过来")
    private String customerNo;

    @ApiModelProperty("请求流水号")
    private String serialNo;

    @ApiModelProperty("申请原因")
    private String reason;

    @ApiModelProperty("0 正常 1 删除")
    private Integer isDelete;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("应用Id")
    private String appId;

    @ApiModelProperty("0 未撤销(默认), 1 撤销中, 2 撤销成功，3 撤销失败")
    private Integer revokeStatus;

    @ApiModelProperty("撤销流水号")
    private String revokeSerialNo;

    @ApiModelProperty("撤销失败原因")
    private String revokeMessage;

    @ApiModelProperty("申请日期")
    private String applyDate;

    @ApiModelProperty("明细记录")
    private List<RedNotificationDetailVO> redNotificationDetailVOS;

    public Long getId() { return id; }

    public String getApplyTaxNo() {
        return applyTaxNo;
    }

    public Integer getApplyingStatus() {
        return applyingStatus;
    }

    public Integer getIsDelete() { return isDelete; }


    public void setId(Long id) {
        this.id = id;
    }

    public Integer getApplyStatus() {
        return applyStatus;
    }

    public void setApplyStatus(Integer applyStatus) {
        this.applyStatus = applyStatus;
    }

    public void setApplyingStatus(Integer applyingStatus) {
        this.applyingStatus = applyingStatus;
    }

    public String getRequestBillNo() {
        return requestBillNo;
    }

    public void setRequestBillNo(String requestBillNo) {
        this.requestBillNo = requestBillNo;
    }

    public Integer getSyncStatus() {
        return syncStatus;
    }

    public void setSyncStatus(Integer syncStatus) {
        this.syncStatus = syncStatus;
    }

    public String getRedStatus() {
        return redStatus;
    }

    public void setRedStatus(String redStatus) {
        this.redStatus = redStatus;
    }

    public String getSyncMessage() {
        return syncMessage;
    }

    public void setSyncMessage(String syncMessage) {
        this.syncMessage = syncMessage;
    }

    public Integer getSyncCode() {
        return syncCode;
    }

    public void setSyncCode(Integer syncCode) {
        this.syncCode = syncCode;
    }

    public String getSyncSerialNo() {
        return syncSerialNo;
    }

    public void setSyncSerialNo(String syncSerialNo) {
        this.syncSerialNo = syncSerialNo;
    }

    public String getSyncStatusMsg() {
        return syncStatusMsg;
    }

    public void setSyncStatusMsg(String syncStatusMsg) {
        this.syncStatusMsg = syncStatusMsg;
    }

    public Integer getDeliveryStatus() {
        return deliveryStatus;
    }

    public void setDeliveryStatus(Integer deliveryStatus) {
        this.deliveryStatus = deliveryStatus;
    }

    public String getDeliveryRemark() {
        return deliveryRemark;
    }

    public void setDeliveryRemark(String deliveryRemark) {
        this.deliveryRemark = deliveryRemark;
    }

    public String getDeliveryFailedCode() {
        return deliveryFailedCode;
    }

    public void setDeliveryFailedCode(String deliveryFailedCode) {
        this.deliveryFailedCode = deliveryFailedCode;
    }

    public void setApplyTaxNo(String applyTaxNo) {
        this.applyTaxNo = applyTaxNo;
    }

    public String getApplyRemark() {
        return applyRemark;
    }

    public void setApplyRemark(String applyRemark) {
        this.applyRemark = applyRemark;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public Integer getSaleListFileFlag() {
        return saleListFileFlag;
    }

    public void setSaleListFileFlag(Integer saleListFileFlag) {
        this.saleListFileFlag = saleListFileFlag;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }

    public String getTerminalUn() {
        return terminalUn;
    }

    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
    }

    public Integer getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(Integer terminalType) {
        this.terminalType = terminalType;
    }

    public String getCustomerNo() {
        return customerNo;
    }

    public void setCustomerNo(String customerNo) {
        this.customerNo = customerNo;
    }

    public String getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public Integer getRevokeStatus() {
        return revokeStatus;
    }

    public void setRevokeStatus(Integer revokeStatus) {
        this.revokeStatus = revokeStatus;
    }

    public String getRevokeSerialNo() {
        return revokeSerialNo;
    }

    public void setRevokeSerialNo(String revokeSerialNo) {
        this.revokeSerialNo = revokeSerialNo;
    }

    public String getRevokeMessage() {
        return revokeMessage;
    }

    public void setRevokeMessage(String revokeMessage) {
        this.revokeMessage = revokeMessage;
    }

    public String getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(String applyDate) {
        this.applyDate = applyDate;
    }

    public List<RedNotificationDetailVO> getRedNotificationDetailVOS() {
        return redNotificationDetailVOS;
    }

    public void setRedNotificationDetailVOS(List<RedNotificationDetailVO> redNotificationDetailVOS) {
        this.redNotificationDetailVOS = redNotificationDetailVOS;
    }
}
